/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenWithBrowserAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.open.browser";

    public OpenWithBrowserAction() {
        super(Messages.OpenWithBrowserAction_Open_with_Browser);
        this.setToolTipText(Messages.OpenWithBrowserAction_Open_with_Browser);
        this.setId(ID);
    }

    public void run() {
        if (super.getStructuredSelection() != null) {
            Iterator iter = super.getStructuredSelection().iterator();
            while (iter.hasNext()) {
                this.runWithSelection(iter.next());
            }
        }
    }

    private void runWithSelection(Object selectedObject) {
        String urlString = null;
        if (selectedObject instanceof ITask) {
            AbstractTask task = (AbstractTask)selectedObject;
            if (TasksUiInternal.isValidUrl(task.getUrl())) {
                urlString = task.getUrl();
            }
        } else if (selectedObject instanceof IRepositoryElement) {
            IRepositoryElement query = (IRepositoryElement)selectedObject;
            urlString = query.getUrl();
        }
        if (urlString != null) {
            TasksUiUtil.openUrl(urlString);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            for (Object element : selection.toList()) {
                if (element instanceof ITask && TasksUiInternal.isValidUrl(((ITask)element).getUrl())) {
                    return true;
                }
                if (!(element instanceof IRepositoryElement) || ((IRepositoryElement)element).getUrl() == null) continue;
                return true;
            }
        }
        return false;
    }
}

