/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaCorePlugin
extends Plugin {
    private static final String ERROR_DELETING_CONFIGURATION = "Error removing corrupt repository configuration file.";
    private static final String ERROR_INCOMPATIBLE_CONFIGURATION = "Reset Bugzilla repository configuration cache due to format change";
    public static final String CONNECTOR_KIND = "bugzilla";
    public static final String ID_PLUGIN = "org.eclipse.mylyn.bugzilla";
    private static BugzillaCorePlugin INSTANCE;
    private static boolean cacheFileRead;
    private static File repositoryConfigurationFile;
    private static BugzillaRepositoryConnector connector;
    private static final String OPTION_ALL = "All";
    private final Map<String, String> java2buzillaPlatformMap = new HashMap<String, String>();
    private static Map<String, RepositoryConfiguration> repositoryConfigurations;

    static {
        cacheFileRead = false;
        repositoryConfigurationFile = null;
        repositoryConfigurations = new HashMap<String, RepositoryConfiguration>();
    }

    public BugzillaCorePlugin() {
        this.java2buzillaPlatformMap.put("x86", "PC");
        this.java2buzillaPlatformMap.put("x86_64", "PC");
        this.java2buzillaPlatformMap.put("ia64", "PC");
        this.java2buzillaPlatformMap.put("ia64_32", "PC");
        this.java2buzillaPlatformMap.put("sparc", "Sun");
        this.java2buzillaPlatformMap.put("ppc", "Power PC");
    }

    public static BugzillaCorePlugin getDefault() {
        return INSTANCE;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    public void stop(BundleContext context) throws Exception {
        BugzillaCorePlugin.writeRepositoryConfigFile();
        INSTANCE = null;
        super.stop(context);
    }

    static void setConnector(BugzillaRepositoryConnector theConnector) {
        connector = theConnector;
    }

    public static Map<String, RepositoryConfiguration> getConfigurations() {
        BugzillaCorePlugin.readRepositoryConfigurationFile();
        return repositoryConfigurations;
    }

    public static void setConfigurationCacheFile(File file) {
        repositoryConfigurationFile = file;
    }

    public static RepositoryConfiguration getRepositoryConfiguration(String repositoryUrl) {
        BugzillaCorePlugin.readRepositoryConfigurationFile();
        return repositoryConfigurations.get(repositoryUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryConfiguration getRepositoryConfiguration(TaskRepository repository, boolean forceRefresh, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            BugzillaCorePlugin.readRepositoryConfigurationFile();
            RepositoryConfiguration configuration = repositoryConfigurations.get(repository.getRepositoryUrl());
            if (configuration == null || forceRefresh) {
                Map<String, RepositoryConfiguration> map = repositoryConfigurations;
                synchronized (map) {
                    BugzillaClient client;
                    configuration = repositoryConfigurations.get(repository.getRepositoryUrl());
                    if ((configuration == null || forceRefresh) && (configuration = (client = connector.getClientManager().getClient(repository, monitor)).getRepositoryConfiguration(monitor)) != null) {
                        BugzillaCorePlugin.internalAddConfiguration(configuration);
                    }
                }
            }
            return configuration;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, ID_PLUGIN, 1, "Error retrieving task attributes from repository.\n\n" + e.getMessage(), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRepositoryConfiguration(RepositoryConfiguration config) {
        if (config != null) {
            BugzillaCorePlugin.readRepositoryConfigurationFile();
            Map<String, RepositoryConfiguration> map = repositoryConfigurations;
            synchronized (map) {
                BugzillaCorePlugin.internalAddConfiguration(config);
            }
        }
    }

    private static void internalAddConfiguration(RepositoryConfiguration config) {
        repositoryConfigurations.remove(config.getRepositoryUrl());
        repositoryConfigurations.put(config.getRepositoryUrl(), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConfiguration(RepositoryConfiguration config) {
        Map<String, RepositoryConfiguration> map = repositoryConfigurations;
        synchronized (map) {
            repositoryConfigurations.remove(config.getRepositoryUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void readRepositoryConfigurationFile() {
        if (cacheFileRead || repositoryConfigurationFile == null || !repositoryConfigurationFile.exists()) {
            return;
        }
        Map<String, RepositoryConfiguration> map = repositoryConfigurations;
        synchronized (map) {
            block24: {
                ObjectInputStream in = null;
                try {
                    try {
                        in = new ObjectInputStream(new FileInputStream(repositoryConfigurationFile));
                        int size = in.readInt();
                        int nX = 0;
                        while (nX < size) {
                            RepositoryConfiguration item = (RepositoryConfiguration)in.readObject();
                            if (item != null) {
                                repositoryConfigurations.put(item.getRepositoryUrl(), item);
                            }
                            ++nX;
                        }
                    }
                    catch (Exception e) {
                        BugzillaCorePlugin.log((IStatus)new Status(1, ID_PLUGIN, ERROR_INCOMPATIBLE_CONFIGURATION));
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (repositoryConfigurationFile != null && repositoryConfigurationFile.exists() && !repositoryConfigurationFile.delete()) {
                                BugzillaCorePlugin.log((IStatus)new Status(4, ID_PLUGIN, 0, ERROR_DELETING_CONFIGURATION, (Throwable)e));
                            }
                        }
                        catch (Exception exception) {
                            BugzillaCorePlugin.log((IStatus)new Status(4, ID_PLUGIN, 0, ERROR_DELETING_CONFIGURATION, (Throwable)e));
                        }
                        cacheFileRead = true;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    cacheFileRead = true;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                cacheFileRead = true;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRepositoryConfigFile() {
        block20: {
            if (repositoryConfigurationFile != null) {
                ObjectOutputStream out = null;
                try {
                    try {
                        HashSet<RepositoryConfiguration> tempConfigs;
                        Map<String, RepositoryConfiguration> map = repositoryConfigurations;
                        synchronized (map) {
                            tempConfigs = new HashSet<RepositoryConfiguration>(repositoryConfigurations.values());
                        }
                        if (tempConfigs.size() > 0) {
                            out = new ObjectOutputStream(new FileOutputStream(repositoryConfigurationFile));
                            out.writeInt(tempConfigs.size());
                            for (RepositoryConfiguration repositoryConfiguration : tempConfigs) {
                                if (repositoryConfiguration == null) continue;
                                out.writeObject(repositoryConfiguration);
                            }
                        }
                    }
                    catch (IOException e) {
                        BugzillaCorePlugin.log(e);
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void log(IStatus status) {
        BugzillaCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Exception e) {
        String message = e.getMessage();
        if (e.getMessage() == null) {
            message = e.getClass().toString();
        }
        BugzillaCorePlugin.log((IStatus)new Status(4, ID_PLUGIN, 0, message, (Throwable)e));
    }

    protected IPath getCachedBugReportPath() {
        IPath stateLocation = Platform.getStateLocation((Bundle)BugzillaCorePlugin.getDefault().getBundle());
        IPath bugFile = stateLocation.append("bugReports");
        return bugFile;
    }

    public void setPlatformDefaultsOrGuess(TaskRepository repository, TaskData newBugModel) {
        String platform = repository.getProperty("bugzilla.default.platform");
        String os = repository.getProperty("bugzilla.default.os");
        if (os != null && platform != null) {
            TaskAttribute opSysAttribute = newBugModel.getRoot().getAttribute(BugzillaAttribute.OP_SYS.getKey());
            TaskAttribute platformAttribute = newBugModel.getRoot().getAttribute(BugzillaAttribute.REP_PLATFORM.getKey());
            opSysAttribute.setValue(os);
            platformAttribute.setValue(platform);
            return;
        }
        this.setPlatformOptions(newBugModel);
    }

    public void setPlatformOptions(TaskData newBugModel) {
        try {
            TaskAttribute opSysAttribute = newBugModel.getRoot().getAttribute(BugzillaAttribute.OP_SYS.getKey());
            TaskAttribute platformAttribute = newBugModel.getRoot().getAttribute(BugzillaAttribute.REP_PLATFORM.getKey());
            String OS = Platform.getOS();
            String platform = Platform.getOSArch();
            String bugzillaOS = null;
            String bugzillaPlatform = null;
            bugzillaOS = String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version");
            if (opSysAttribute != null) {
                while (bugzillaOS != null && opSysAttribute.getOption(bugzillaOS) == null) {
                    int spaceindex;
                    int dotindex = bugzillaOS.lastIndexOf(46);
                    bugzillaOS = dotindex > 0 ? bugzillaOS.substring(0, dotindex) : ((spaceindex = bugzillaOS.lastIndexOf(32)) > 0 ? bugzillaOS.substring(0, spaceindex) : null);
                }
            } else {
                bugzillaOS = null;
            }
            if (platform != null && this.java2buzillaPlatformMap.containsKey(platform)) {
                bugzillaPlatform = this.java2buzillaPlatformMap.get(platform);
                if (bugzillaPlatform != null && (bugzillaPlatform.compareTo("Power") == 0 || bugzillaPlatform.compareTo("PC") == 0) && OS != null && OS.compareTo("macosx") == 0) {
                    bugzillaPlatform = "Macintosh";
                } else if (platformAttribute != null && platformAttribute.getOption(bugzillaPlatform) == null) {
                    bugzillaPlatform = null;
                }
            }
            if (bugzillaOS != null && opSysAttribute != null) {
                opSysAttribute.setValue(bugzillaOS);
            } else if (opSysAttribute != null && opSysAttribute.getOption(OPTION_ALL) != null) {
                opSysAttribute.setValue(OPTION_ALL);
            }
            if (bugzillaPlatform != null && platformAttribute != null) {
                platformAttribute.setValue(bugzillaPlatform);
            } else if (opSysAttribute != null && platformAttribute != null && platformAttribute.getOption(OPTION_ALL) != null) {
                opSysAttribute.setValue(OPTION_ALL);
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "could not set platform options", (Throwable)e));
        }
    }

    public Set<BugzillaLanguageSettings> getLanguageSettings() {
        return BugzillaRepositoryConnector.getLanguageSettings();
    }

    public BugzillaLanguageSettings getLanguageSetting(String language) {
        return BugzillaRepositoryConnector.getLanguageSetting(language);
    }
}

