/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.AggregateInteractionEvent;
import org.eclipse.mylyn.internal.context.core.DegreeOfInterest;
import org.eclipse.mylyn.internal.context.core.InteractionContextElement;
import org.eclipse.mylyn.internal.context.core.InteractionContextRelation;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionContext
implements IInteractionContext {
    private String handleIdentifier;
    private final List<InteractionEvent> interactionHistory;
    private final Map<String, InteractionContextElement> elementMap;
    private final Map<String, IInteractionElement> landmarkMap;
    private InteractionContextElement activeNode;
    private InteractionEvent lastEdgeEvent;
    private InteractionContextElement lastEdgeNode;
    private String contentLimitedTo;
    private int numUserEvents;
    private final IInteractionContextScaling contextScaling;

    public InteractionContext(String id, IInteractionContextScaling scaling) {
        this.handleIdentifier = id;
        this.contextScaling = scaling;
        this.interactionHistory = new ArrayList<InteractionEvent>();
        this.elementMap = new HashMap<String, InteractionContextElement>();
        this.landmarkMap = new HashMap<String, IInteractionElement>();
        for (InteractionEvent event : this.interactionHistory) {
            this.parseInteractionEvent(event);
        }
        for (InteractionContextElement node : this.elementMap.values()) {
            if (!node.getInterest().isLandmark()) continue;
            this.landmarkMap.put(node.getHandleIdentifier(), node);
        }
        this.activeNode = this.lastEdgeNode;
    }

    public synchronized IInteractionElement parseEvent(InteractionEvent event) {
        this.interactionHistory.add(event);
        return this.parseInteractionEvent(event);
    }

    private IInteractionElement parseInteractionEvent(InteractionEvent event) {
        IInteractionElement navigationSource;
        InteractionContextElement node;
        if (event.getStructureHandle() == null || event.getKind() == null) {
            return null;
        }
        if (event.getKind().isUserEvent()) {
            ++this.numUserEvents;
        }
        if ((node = this.elementMap.get(event.getStructureHandle())) == null) {
            node = event instanceof AggregateInteractionEvent ? new InteractionContextElement(event.getStructureKind(), event.getStructureHandle(), this, ((AggregateInteractionEvent)event).getEventCountOnCreation()) : new InteractionContextElement(event.getStructureKind(), event.getStructureHandle(), this);
            this.elementMap.put(event.getStructureHandle(), node);
        }
        if (event.getKind().isUserEvent() && event instanceof AggregateInteractionEvent) {
            this.numUserEvents += ((AggregateInteractionEvent)event).getNumCollapsedEvents() - 1;
        }
        if (event.getNavigation() != null && !event.getNavigation().equals("null") && this.lastEdgeEvent != null && this.lastEdgeNode != null && this.lastEdgeEvent.getStructureHandle() != null && event.getKind() != InteractionEvent.Kind.PROPAGATION && event.getKind() != InteractionEvent.Kind.PREDICTION && (navigationSource = (IInteractionElement)this.elementMap.get(this.lastEdgeEvent.getStructureHandle())) != null) {
            InteractionContextRelation edge = this.lastEdgeNode.getRelation(event.getStructureHandle());
            if (edge == null) {
                edge = new InteractionContextRelation(event.getStructureKind(), event.getNavigation(), this.lastEdgeNode, node, this);
                this.lastEdgeNode.addEdge(edge);
            }
            DegreeOfInterest doi = (DegreeOfInterest)edge.getInterest();
            doi.addEvent(event);
        }
        DegreeOfInterest doi = (DegreeOfInterest)node.getInterest();
        doi.addEvent(event);
        if (doi.isLandmark()) {
            this.landmarkMap.put(node.getHandleIdentifier(), node);
        } else {
            this.landmarkMap.remove(node.getHandleIdentifier());
        }
        if (event.getKind().isUserEvent()) {
            this.lastEdgeEvent = event;
            this.lastEdgeNode = node;
            this.activeNode = node;
        }
        return node;
    }

    @Override
    public synchronized IInteractionElement get(String elementHandle) {
        if (elementHandle == null) {
            return null;
        }
        return this.elementMap.get(elementHandle);
    }

    @Override
    public synchronized boolean isInteresting(String elementHandle) {
        InteractionContextElement element = this.elementMap.get(elementHandle);
        if (element != null) {
            return element.getInterest().isInteresting();
        }
        return false;
    }

    @Override
    public synchronized List<IInteractionElement> getInteresting() {
        ArrayList<IInteractionElement> elements = new ArrayList<IInteractionElement>();
        for (String key : this.elementMap.keySet()) {
            InteractionContextElement info = this.elementMap.get(key);
            if (info == null || !info.getInterest().isInteresting()) continue;
            elements.add(info);
        }
        return elements;
    }

    @Override
    public synchronized List<IInteractionElement> getLandmarks() {
        return new ArrayList<IInteractionElement>(this.landmarkMap.values());
    }

    @Override
    public synchronized void updateElementHandle(IInteractionElement element, String newHandle) {
        InteractionContextElement currElement = this.elementMap.remove(element.getHandleIdentifier());
        if (currElement != null) {
            currElement.setHandleIdentifier(newHandle);
            this.elementMap.put(newHandle, currElement);
        }
    }

    @Override
    public synchronized IInteractionElement getActiveNode() {
        return this.activeNode;
    }

    @Override
    public synchronized void delete(Collection<IInteractionElement> nodes) {
        HashSet<String> handlesToRemove = new HashSet<String>();
        for (IInteractionElement node : nodes) {
            handlesToRemove.add(node.getHandleIdentifier());
            this.landmarkMap.remove(node.getHandleIdentifier());
            this.elementMap.remove(node.getHandleIdentifier());
            if (this.activeNode == null || !node.getHandleIdentifier().equals(this.activeNode.getHandleIdentifier())) continue;
            this.activeNode = null;
        }
        ArrayList<InteractionEvent> eventsToRemove = new ArrayList<InteractionEvent>();
        for (InteractionEvent event : this.interactionHistory) {
            if (!handlesToRemove.contains(event.getStructureHandle())) continue;
            eventsToRemove.add(event);
        }
        this.interactionHistory.removeAll(eventsToRemove);
    }

    @Override
    public synchronized void delete(IInteractionElement node) {
        this.delete(Collections.singleton(node));
    }

    @Override
    public synchronized List<IInteractionElement> getAllElements() {
        return new ArrayList<IInteractionElement>(this.elementMap.values());
    }

    @Override
    public String getHandleIdentifier() {
        return this.handleIdentifier;
    }

    public void setHandleIdentifier(String handle) {
        this.handleIdentifier = handle;
    }

    public String toString() {
        return this.handleIdentifier;
    }

    public synchronized void reset() {
        this.elementMap.clear();
        this.interactionHistory.clear();
        this.landmarkMap.clear();
        this.activeNode = null;
        this.numUserEvents = 0;
        this.lastEdgeEvent = null;
        this.lastEdgeNode = null;
    }

    public synchronized int getUserEventCount() {
        return this.numUserEvents;
    }

    @Override
    public synchronized List<InteractionEvent> getInteractionHistory() {
        return new ArrayList<InteractionEvent>(this.interactionHistory);
    }

    public synchronized void collapse() {
        ArrayList<InteractionEvent> collapsedHistory = new ArrayList<InteractionEvent>();
        for (InteractionContextElement node : this.elementMap.values()) {
            if (node.equals(this.activeNode)) continue;
            this.collapseNode(collapsedHistory, node);
        }
        if (this.activeNode != null) {
            this.collapseNode(collapsedHistory, this.activeNode);
        }
        this.interactionHistory.clear();
        this.interactionHistory.addAll(collapsedHistory);
    }

    private void collapseNode(List<InteractionEvent> collapsedHistory, InteractionContextElement node) {
        collapsedHistory.addAll(((DegreeOfInterest)node.getInterest()).getCollapsedEvents());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InteractionContext other = (InteractionContext)obj;
        if (this.contentLimitedTo == null ? other.contentLimitedTo != null : !this.contentLimitedTo.equals(other.contentLimitedTo)) {
            return false;
        }
        return !(this.handleIdentifier == null ? other.handleIdentifier != null : !this.handleIdentifier.equals(other.handleIdentifier));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contentLimitedTo == null ? 0 : this.contentLimitedTo.hashCode());
        result = 31 * result + (this.handleIdentifier == null ? 0 : this.handleIdentifier.hashCode());
        return result;
    }

    @Override
    public IInteractionContextScaling getScaling() {
        return this.contextScaling;
    }

    @Override
    public String getContentLimitedTo() {
        return this.contentLimitedTo;
    }

    @Override
    public void setContentLimitedTo(String contentLimitedTo) {
        this.contentLimitedTo = contentLimitedTo;
    }
}

