/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.DefaultMetadataURLValidator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.ICopyable;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositoryManipulatorDropTarget;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositoryNameAndLocationDialog;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.viewers.MetadataRepositoryElementComparator;
import org.eclipse.equinox.internal.p2.ui.viewers.RepositoryDetailsLabelProvider;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.UpdateManagerCompatibility;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.AddRepositoryDialog;
import org.eclipse.equinox.internal.provisional.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.AddRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.RemoveRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryLocationValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryManipulator;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class RepositoryManipulationPage
extends PreferencePage
implements IWorkbenchPreferencePage,
ICopyable {
    static final String DEFAULT_FILTER_TEXT = ProvUIMessages.RepositoryManipulationPage_DefaultFilterString;
    private static final int FILTER_DELAY = 200;
    StructuredViewerProvisioningListener listener;
    TableViewer repositoryViewer;
    Table table;
    Policy policy;
    Display display;
    boolean changed = false;
    MetadataRepositoryElementComparator comparator;
    RepositoryDetailsLabelProvider labelProvider;
    RepositoryManipulator manipulator;
    RepositoryManipulator localCacheRepoManipulator;
    CachedMetadataRepositories input;
    Text pattern;
    Text details;
    PatternFilter filter;
    WorkbenchJob filterJob;
    Button addButton;
    Button removeButton;
    Button editButton;
    Button refreshButton;
    Button disableButton;
    Button exportButton;

    public void setPolicy(Policy policy) {
        this.policy = policy;
        this.manipulator = policy.getRepositoryManipulator();
    }

    protected Control createContents(Composite parent) {
        this.display = parent.getDisplay();
        if (this.manipulator != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), "org.eclipse.equinox.p2.ui.repository_manipulation_dialog_context");
        }
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.manipulator == null ? 1 : 2;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        this.pattern = new Text(composite, 2436);
        this.pattern.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DEFAULT_FILTER_TEXT;
            }
        });
        this.pattern.setText(DEFAULT_FILTER_TEXT);
        this.pattern.selectAll();
        this.pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryManipulationPage.this.applyFilter();
            }
        });
        this.pattern.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    if (RepositoryManipulationPage.this.table.getItemCount() > 0) {
                        RepositoryManipulationPage.this.table.setFocus();
                    } else if (e.character == '\r') {
                        return;
                    }
                }
            }
        });
        this.pattern.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                RepositoryManipulationPage.this.display.asyncExec(new Runnable(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (!4.access$0(this.this$1).pattern.isDisposed() && DEFAULT_FILTER_TEXT.equals(4.access$0(this.this$1).pattern.getText().trim())) {
                            4.access$0(this.this$1).pattern.selectAll();
                        }
                    }
                });
            }

            static /* synthetic */ RepositoryManipulationPage access$0(4 var0) {
                return var0.RepositoryManipulationPage.this;
            }
        });
        gd = new GridData(4, 4, true, false);
        this.pattern.setLayoutData((Object)gd);
        if (this.manipulator != null) {
            new Label(composite, 0);
        }
        this.repositoryViewer = new TableViewer(composite, 68354);
        this.table = this.repositoryViewer.getTable();
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    RepositoryManipulationPage.this.removeRepositories();
                }
            }
        });
        this.setTableColumns();
        CopyUtils.activateCopy(this, (Control)this.table);
        this.repositoryViewer.setComparer((IElementComparer)new ProvElementComparer());
        this.comparator = new MetadataRepositoryElementComparator(0);
        this.repositoryViewer.setComparator((ViewerComparator)this.comparator);
        this.filter = new MetadataRepositoryPatternFilter();
        this.repositoryViewer.setFilters(new ViewerFilter[]{this.filter});
        this.repositoryViewer.setContentProvider((IContentProvider)new ProvElementContentProvider());
        this.labelProvider = new RepositoryDetailsLabelProvider();
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.repositoryViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                return ((MetadataRepositoryElement)element).getName();
            }

            public void modify(Object element, String property, Object value) {
                if (value != null && value.toString().length() >= 0) {
                    MetadataRepositoryElement repo;
                    if (element instanceof Item) {
                        repo = (MetadataRepositoryElement)((Item)element).getData();
                    } else if (element instanceof MetadataRepositoryElement) {
                        repo = (MetadataRepositoryElement)element;
                    } else {
                        return;
                    }
                    RepositoryManipulationPage.this.changed = true;
                    repo.setNickname(value.toString());
                    if (RepositoryManipulationPage.this.comparator.getSortKey() == 0) {
                        RepositoryManipulationPage.this.repositoryViewer.refresh(true);
                    } else {
                        RepositoryManipulationPage.this.repositoryViewer.update((Object)repo, null);
                    }
                }
            }
        });
        this.repositoryViewer.setColumnProperties(new String[]{"nickname"});
        this.repositoryViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.repositoryViewer.getTable())});
        this.repositoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (RepositoryManipulationPage.this.manipulator != null) {
                    RepositoryManipulationPage.this.validateButtons();
                }
                RepositoryManipulationPage.this.setDetails();
            }
        });
        this.repositoryViewer.setInput((Object)this.getInput());
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        this.table.setLayoutData((Object)data);
        if (this.manipulator != null) {
            DropTarget target = new DropTarget((Control)this.table, 7);
            target.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
            target.addDropListener((DropTargetListener)new RepositoryManipulatorDropTarget(this.getRepositoryManipulator(), (Control)this.table));
            Composite verticalButtonBar = this.createVerticalButtonBar(composite);
            data = new GridData(4, 4, false, false);
            data.verticalAlignment = 128;
            data.verticalIndent = 0;
            verticalButtonBar.setLayoutData((Object)data);
            this.listener = this.getViewerProvisioningListener();
            ProvUI.addProvisioningListener(this.listener);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ProvUI.removeProvisioningListener(RepositoryManipulationPage.this.listener);
                }
            });
            this.validateButtons();
        }
        this.details = new Text(composite, 72);
        data = new GridData(4, 4, true, false);
        data.heightHint = this.convertHeightInCharsToPixels(2);
        this.details.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Button createVerticalButton(Composite parent, String label, boolean defaultButton) {
        Shell shell;
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = this.setVerticalButtonLayoutData(button);
        data.horizontalAlignment = 4;
        button.setToolTipText(label);
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        return button;
    }

    private GridData setVerticalButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        return data;
    }

    private void setTableColumns() {
        this.table.setHeaderVisible(true);
        String[] columnHeaders = this.manipulator != null ? new String[]{ProvUIMessages.RepositoryManipulationPage_NameColumnTitle, ProvUIMessages.RepositoryManipulationPage_LocationColumnTitle, ProvUIMessages.RepositoryManipulationPage_EnabledColumnTitle} : new String[]{ProvUIMessages.RepositoryManipulationPage_NameColumnTitle, ProvUIMessages.RepositoryManipulationPage_LocationColumnTitle};
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(true);
            tc.setText(columnHeaders[i]);
            if (i == 2) {
                tc.setWidth(this.convertWidthInCharsToPixels(10));
                tc.setAlignment(0x1000000);
            } else if (i == 0) {
                tc.setWidth(this.convertWidthInCharsToPixels(40) * 2 / 3);
            } else {
                tc.setWidth(this.convertWidthInCharsToPixels(40));
            }
            tc.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    RepositoryManipulationPage.this.columnSelected((TableColumn)e.widget);
                }

                public void widgetSelected(SelectionEvent e) {
                    RepositoryManipulationPage.this.columnSelected((TableColumn)e.widget);
                }
            });
            if (i == 0) {
                this.table.setSortColumn(tc);
                this.table.setSortDirection(128);
            }
            ++i;
        }
    }

    private Composite createVerticalButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        this.createVerticalButtons(composite);
        return composite;
    }

    private void createVerticalButtons(Composite parent) {
        this.addButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_Add, false);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.addRepository();
            }
        });
        this.editButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_Edit, false);
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.changeRepositoryProperties();
            }
        });
        this.removeButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_Remove, false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.removeRepositories();
            }
        });
        this.refreshButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_RefreshConnection, false);
        this.refreshButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.refreshRepository();
            }
        });
        this.disableButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_DisableButton, false);
        this.disableButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.toggleRepositoryEnablement();
            }
        });
        Button button = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_Import, false);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.importRepositories();
            }
        });
        this.exportButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_Export, false);
        this.exportButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.exportRepositories();
            }
        });
    }

    CachedMetadataRepositories getInput() {
        if (this.input == null) {
            this.input = new CachedMetadataRepositories();
        }
        return this.input;
    }

    public boolean performOk() {
        if (this.changed) {
            ElementUtils.updateRepositoryUsingElements(this.getElements(), this.getShell());
        }
        return super.performOk();
    }

    private StructuredViewerProvisioningListener getViewerProvisioningListener() {
        return new StructuredViewerProvisioningListener((StructuredViewer)this.repositoryViewer, 1){

            protected void repositoryDiscovered(RepositoryEvent e) {
                RepositoryManipulationPage.this.asyncRefresh(null);
            }

            protected void repositoryChanged(RepositoryEvent e) {
                RepositoryManipulationPage.this.asyncRefresh(null);
            }
        };
    }

    MetadataRepositoryElement[] getElements() {
        return this.getInput().cachedElements.values().toArray(new MetadataRepositoryElement[this.getInput().cachedElements.size()]);
    }

    MetadataRepositoryElement[] getSelectedElements() {
        Object[] items = ((IStructuredSelection)this.repositoryViewer.getSelection()).toArray();
        ArrayList<Object> list = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof MetadataRepositoryElement) {
                list.add(items[i]);
            }
            ++i;
        }
        return list.toArray(new MetadataRepositoryElement[list.size()]);
    }

    void validateButtons() {
        MetadataRepositoryElement[] elements = this.getSelectedElements();
        this.exportButton.setEnabled(elements.length > 0);
        this.removeButton.setEnabled(elements.length > 0);
        this.editButton.setEnabled(elements.length == 1);
        this.refreshButton.setEnabled(elements.length == 1);
        if (elements.length >= 1) {
            if (this.toggleMeansDisable(elements)) {
                this.disableButton.setText(ProvUIMessages.RepositoryManipulationPage_DisableButton);
            } else {
                this.disableButton.setText(ProvUIMessages.RepositoryManipulationPage_EnableButton);
            }
            this.disableButton.setEnabled(true);
        } else {
            this.disableButton.setText(ProvUIMessages.RepositoryManipulationPage_EnableButton);
            this.disableButton.setEnabled(false);
        }
    }

    void addRepository() {
        AddRepositoryDialog dialog = new AddRepositoryDialog(this.getShell(), this.policy){

            protected RepositoryManipulator getRepositoryManipulator() {
                return RepositoryManipulationPage.this.getRepositoryManipulator();
            }
        };
        dialog.setTitle(this.manipulator.getAddOperationLabel());
        dialog.open();
    }

    void refreshRepository() {
        MetadataRepositoryElement[] selected = this.getSelectedElements();
        final ProvisionException[] fail = new ProvisionException[1];
        final boolean[] remove = new boolean[]{false};
        if (selected.length != 1) {
            return;
        }
        final URI location = selected[0].getLocation();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    block21: {
                        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)ProvUIMessages.RepositoryManipulationPage_ContactingSiteMessage, (Object)location), (int)300);
                        try {
                            ProvUI.clearRepositoryNotFound(location);
                            if (!RepositoryManipulationPage.this.includesRepo(RepositoryManipulationPage.this.manipulator.getKnownRepositories(), location)) {
                                ProvUI.startBatchOperation();
                                AddRepositoryOperation op = RepositoryManipulationPage.this.manipulator.getAddOperation(location);
                                op.setNotify(false);
                                op.execute((IProgressMonitor)mon.newChild(100));
                                remove[0] = true;
                            }
                            ProvisioningUtil.refreshArtifactRepositories(new URI[]{location}, (IProgressMonitor)mon.newChild(100));
                            ProvisioningUtil.refreshMetadataRepositories(new URI[]{location}, (IProgressMonitor)mon.newChild(100));
                        }
                        catch (ProvisionException e) {
                            fail[0] = e;
                            if (fail[0] == null && mon.isCanceled()) {
                                fail[0] = new ProvisionException((IStatus)new Status(8, "org.eclipse.equinox.p2.ui", ProvUIMessages.RepositoryManipulationPage_RefreshOperationCanceled));
                            }
                            if (!remove[0]) break block21;
                            RemoveRepositoryOperation op = RepositoryManipulationPage.this.manipulator.getRemoveOperation(new URI[]{location});
                            op.setNotify(false);
                            try {
                                op.execute((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (ProvisionException provisionException) {}
                            ProvUI.endBatchOperation(false);
                            break block21;
                        }
                        catch (OperationCanceledException e) {
                            try {
                                fail[0] = new ProvisionException((IStatus)new Status(8, "org.eclipse.equinox.p2.ui", ProvUIMessages.RepositoryManipulationPage_RefreshOperationCanceled, (Throwable)e));
                            }
                            catch (Throwable throwable) {
                                if (fail[0] == null && mon.isCanceled()) {
                                    fail[0] = new ProvisionException((IStatus)new Status(8, "org.eclipse.equinox.p2.ui", ProvUIMessages.RepositoryManipulationPage_RefreshOperationCanceled));
                                }
                                if (remove[0]) {
                                    RemoveRepositoryOperation op = RepositoryManipulationPage.this.manipulator.getRemoveOperation(new URI[]{location});
                                    op.setNotify(false);
                                    try {
                                        op.execute((IProgressMonitor)new NullProgressMonitor());
                                    }
                                    catch (ProvisionException provisionException) {}
                                    ProvUI.endBatchOperation(false);
                                }
                                throw throwable;
                            }
                            if (fail[0] == null && mon.isCanceled()) {
                                fail[0] = new ProvisionException((IStatus)new Status(8, "org.eclipse.equinox.p2.ui", ProvUIMessages.RepositoryManipulationPage_RefreshOperationCanceled));
                            }
                            if (!remove[0]) break block21;
                            RemoveRepositoryOperation op = RepositoryManipulationPage.this.manipulator.getRemoveOperation(new URI[]{location});
                            op.setNotify(false);
                            try {
                                op.execute((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (ProvisionException provisionException) {}
                            ProvUI.endBatchOperation(false);
                            break block21;
                        }
                        if (fail[0] == null && mon.isCanceled()) {
                            fail[0] = new ProvisionException((IStatus)new Status(8, "org.eclipse.equinox.p2.ui", ProvUIMessages.RepositoryManipulationPage_RefreshOperationCanceled));
                        }
                        if (remove[0]) {
                            RemoveRepositoryOperation op = RepositoryManipulationPage.this.manipulator.getRemoveOperation(new URI[]{location});
                            op.setNotify(false);
                            try {
                                op.execute((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (ProvisionException provisionException) {}
                            ProvUI.endBatchOperation(false);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        if (fail[0] != null) {
            if (fail[0].getStatus().getCode() == 1000) {
                ProvUI.notFoundStatusReported(location);
            }
            if (!fail[0].getStatus().matches(8)) {
                ProvUI.handleException(fail[0], null, 2);
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ProvUIMessages.RepositoryManipulationPage_TestConnectionTitle, (String)NLS.bind((String)ProvUIMessages.RepositoryManipulationPage_TestConnectionSuccess, (Object)URIUtil.toUnencodedString((URI)location)));
        }
        this.repositoryViewer.update((Object)selected[0], null);
        this.setDetails();
    }

    boolean includesRepo(URI[] repos, URI repo) {
        int i = 0;
        while (i < repos.length) {
            if (repos[i].equals(repo)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void toggleRepositoryEnablement() {
        MetadataRepositoryElement[] selected = this.getSelectedElements();
        if (selected.length >= 1) {
            boolean enableSites = !this.toggleMeansDisable(selected);
            int i = 0;
            while (i < selected.length) {
                selected[i].setEnabled(enableSites);
                ++i;
            }
            if (this.comparator.getSortKey() == 2) {
                this.repositoryViewer.refresh(true);
            } else {
                i = 0;
                while (i < selected.length) {
                    this.repositoryViewer.update((Object)selected[i], null);
                    ++i;
                }
            }
            this.changed = true;
        }
        this.validateButtons();
    }

    void importRepositories() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                MetadataRepositoryElement[] imported = UpdateManagerCompatibility.importSites(RepositoryManipulationPage.this.getShell());
                if (imported.length > 0) {
                    Hashtable repos = RepositoryManipulationPage.this.getInput().cachedElements;
                    RepositoryManipulationPage.this.changed = true;
                    int i = 0;
                    while (i < imported.length) {
                        repos.put(URIUtil.toUnencodedString((URI)imported[i].getLocation()), imported[i]);
                        ++i;
                    }
                    RepositoryManipulationPage.this.asyncRefresh(null);
                }
            }
        });
    }

    void exportRepositories() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                MetadataRepositoryElement[] elements = RepositoryManipulationPage.this.getSelectedElements();
                if (elements.length == 0) {
                    elements = RepositoryManipulationPage.this.getElements();
                }
                UpdateManagerCompatibility.exportSites(RepositoryManipulationPage.this.getShell(), elements);
            }
        });
    }

    void changeRepositoryProperties() {
        final MetadataRepositoryElement[] selected = this.getSelectedElements();
        if (selected.length != 1) {
            return;
        }
        RepositoryNameAndLocationDialog dialog = new RepositoryNameAndLocationDialog(this.getShell(), this.policy){

            protected String getInitialLocationText() {
                return URIUtil.toUnencodedString((URI)selected[0].getLocation());
            }

            protected String getInitialNameText() {
                return selected[0].getName();
            }

            protected RepositoryLocationValidator getRepositoryLocationValidator() {
                return new RepositoryLocationValidator(this, selected){
                    final /* synthetic */ 23 this$1;
                    private final /* synthetic */ MetadataRepositoryElement[] val$selected;
                    {
                        this.this$1 = var1_1;
                        this.val$selected = metadataRepositoryElementArray;
                    }

                    public IStatus validateRepositoryLocation(URI uri, boolean contactRepositories, IProgressMonitor monitor) {
                        if (URIUtil.sameURI((URI)uri, (URI)this.val$selected[0].getLocation())) {
                            return Status.OK_STATUS;
                        }
                        return 23.access$0(this.this$1).getRepositoryManipulator().getRepositoryLocationValidator(this.this$1.getShell()).validateRepositoryLocation(uri, contactRepositories, monitor);
                    }
                };
            }

            static /* synthetic */ RepositoryManipulationPage access$0(23 var0) {
                return var0.RepositoryManipulationPage.this;
            }
        };
        int retCode = dialog.open();
        if (retCode == 0) {
            selected[0].setNickname(dialog.getName());
            selected[0].setLocation(dialog.getLocation());
            this.changed = true;
            this.repositoryViewer.update((Object)selected[0], null);
            this.setDetails();
        }
    }

    void columnSelected(TableColumn tc) {
        TableColumn[] cols = this.table.getColumns();
        int i = 0;
        while (i < cols.length) {
            if (cols[i] == tc) {
                if (i != this.comparator.getSortKey()) {
                    this.comparator.setSortKey(i);
                    this.table.setSortColumn(tc);
                    this.comparator.sortAscending();
                    this.table.setSortDirection(128);
                } else if (this.comparator.isAscending()) {
                    this.table.setSortDirection(1024);
                    this.comparator.sortDescending();
                } else {
                    this.table.setSortDirection(128);
                    this.comparator.sortAscending();
                }
                this.repositoryViewer.refresh();
                break;
            }
            ++i;
        }
    }

    void asyncRefresh(final MetadataRepositoryElement elementToSelect) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                RepositoryManipulationPage.this.repositoryViewer.refresh();
                if (elementToSelect != null) {
                    RepositoryManipulationPage.this.repositoryViewer.setSelection((ISelection)new StructuredSelection((Object)elementToSelect), true);
                }
            }
        });
    }

    void applyFilter() {
        String text = this.pattern.getText();
        if (text == DEFAULT_FILTER_TEXT) {
            text = "";
        }
        if (text.length() == 0) {
            this.filter.setPattern(null);
        } else {
            this.filter.setPattern(text);
        }
        if (this.filterJob != null) {
            this.filterJob.cancel();
        }
        this.filterJob = new WorkbenchJob("filter job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!RepositoryManipulationPage.this.repositoryViewer.getTable().isDisposed()) {
                    RepositoryManipulationPage.this.repositoryViewer.refresh();
                }
                return Status.OK_STATUS;
            }
        };
        this.filterJob.setSystem(true);
        this.filterJob.schedule(200L);
    }

    void setDetails() {
        MetadataRepositoryElement[] selections = this.getSelectedElements();
        if (selections.length == 1) {
            this.details.setText(selections[0].getDescription());
        } else {
            this.details.setText("");
        }
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
        if (this.policy == null) {
            this.setPolicy(Policy.getDefault());
        }
    }

    void removeRepositories() {
        MetadataRepositoryElement[] selections = this.getSelectedElements();
        if (selections.length > 0) {
            String message = ProvUIMessages.RepositoryManipulationPage_RemoveConfirmMessage;
            if (selections.length == 1) {
                message = NLS.bind((String)ProvUIMessages.RepositoryManipulationPage_RemoveConfirmSingleMessage, (Object)URIUtil.toUnencodedString((URI)selections[0].getLocation()));
            }
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)ProvUIMessages.RepositoryManipulationPage_RemoveConfirmTitle, (String)message)) {
                this.changed = true;
                int i = 0;
                while (i < selections.length) {
                    this.getInput().cachedElements.remove(URIUtil.toUnencodedString((URI)selections[i].getLocation()));
                    ++i;
                }
                this.asyncRefresh(null);
            }
        }
    }

    RepositoryManipulator getRepositoryManipulator() {
        if (this.localCacheRepoManipulator == null) {
            this.localCacheRepoManipulator = new RepositoryManipulator(){

                public AddRepositoryOperation getAddOperation(URI location) {
                    return new AddRepositoryOperation(this, "Cached add repo operation", new URI[]{location}){
                        final /* synthetic */ 27 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected IStatus doExecute(IProgressMonitor monitor) {
                            MetadataRepositoryElement element = null;
                            int i = 0;
                            while (i < this.locations.length) {
                                element = new MetadataRepositoryElement((Object)27.access$0(this.this$1).getInput(), this.locations[i], true);
                                if (this.nicknames != null) {
                                    element.setNickname(this.nicknames[i]);
                                }
                                27.access$0(this.this$1).getInput().cachedElements.put(URIUtil.toUnencodedString((URI)this.locations[i]), element);
                                ++i;
                            }
                            27.access$0(this.this$1).changed = true;
                            27.access$0(this.this$1).asyncRefresh(element);
                            return Status.OK_STATUS;
                        }

                        protected IStatus doBatchedExecute(IProgressMonitor monitor) {
                            return null;
                        }

                        protected void setNickname(URI loc, String nickname) {
                        }
                    };
                }

                public String getAddOperationLabel() {
                    return RepositoryManipulationPage.this.manipulator.getAddOperationLabel();
                }

                public URI[] getKnownRepositories() {
                    return RepositoryManipulationPage.this.getKnownRepositories();
                }

                public String getManipulatorButtonLabel() {
                    return RepositoryManipulationPage.this.manipulator.getManipulatorButtonLabel();
                }

                public String getManipulatorLinkLabel() {
                    return RepositoryManipulationPage.this.manipulator.getManipulatorLinkLabel();
                }

                public RemoveRepositoryOperation getRemoveOperation(URI[] repoLocations) {
                    return new RemoveRepositoryOperation(this, "Cached remove repo operation", repoLocations){
                        final /* synthetic */ 27 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected IStatus doBatchedExecute(IProgressMonitor monitor) {
                            27.access$0(this.this$1).removeRepositories();
                            return Status.OK_STATUS;
                        }
                    };
                }

                public String getRemoveOperationLabel() {
                    return RepositoryManipulationPage.this.manipulator.getRemoveOperationLabel();
                }

                public RepositoryLocationValidator getRepositoryLocationValidator(Shell shell) {
                    return new DefaultMetadataURLValidator(this){
                        final /* synthetic */ 27 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected URI[] getKnownLocations() {
                            return this.this$1.getKnownRepositories();
                        }
                    };
                }

                public boolean manipulateRepositories(Shell shell) {
                    return true;
                }

                public String getManipulatorInstructionString() {
                    return null;
                }

                public String getRepositoryNotFoundInstructionString() {
                    return null;
                }

                static /* synthetic */ RepositoryManipulationPage access$0(27 var0) {
                    return var0.RepositoryManipulationPage.this;
                }
            };
        }
        return this.localCacheRepoManipulator;
    }

    public void copyToClipboard(Control activeControl) {
        MetadataRepositoryElement[] elements = this.getSelectedElements();
        if (elements.length == 0) {
            elements = this.getElements();
        }
        String text = "";
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            buffer.append(this.labelProvider.getClipboardText(elements[i], "\t"));
            if (i > 0) {
                buffer.append(CopyUtils.NEWLINE);
            }
            ++i;
        }
        text = buffer.toString();
        if (text.length() == 0) {
            return;
        }
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    private boolean toggleMeansDisable(MetadataRepositoryElement[] elements) {
        double count = 0.0;
        int i = 0;
        while (i < elements.length) {
            if (elements[i].isEnabled()) {
                count += 1.0;
            }
            ++i;
        }
        return count / (double)elements.length > 0.5;
    }

    URI[] getKnownRepositories() {
        MetadataRepositoryElement[] elements = this.getElements();
        URI[] locations = new URI[elements.length];
        int i = 0;
        while (i < elements.length) {
            locations[i] = elements[i].getLocation();
            ++i;
        }
        return locations;
    }

    class CachedMetadataRepositories
    extends MetadataRepositories {
        Hashtable cachedElements;

        CachedMetadataRepositories() {
            super(RepositoryManipulationPage.this.policy);
            this.setIncludeDisabledRepositories(RepositoryManipulationPage.this.manipulator != null);
        }

        public int getQueryType() {
            return 1;
        }

        public Object[] getChildren(Object o) {
            if (this.cachedElements == null) {
                Object[] children = super.getChildren(o);
                this.cachedElements = new Hashtable(children.length);
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof MetadataRepositoryElement) {
                        this.cachedElements.put(URIUtil.toUnencodedString((URI)((MetadataRepositoryElement)children[i]).getLocation()), children[i]);
                    }
                    ++i;
                }
            }
            return this.cachedElements.values().toArray();
        }
    }

    class MetadataRepositoryPatternFilter
    extends PatternFilter {
        MetadataRepositoryPatternFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            if (element instanceof MetadataRepositoryElement) {
                return this.wordMatches(String.valueOf(RepositoryManipulationPage.this.labelProvider.getColumnText(element, 0)) + " " + RepositoryManipulationPage.this.labelProvider.getColumnText(element, 1));
            }
            return false;
        }
    }
}

