/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.ui.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.ExistingIUInProfileAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.UpdateWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class UpdateAction
extends ExistingIUInProfileAction {
    protected IUElementListRoot root;
    protected ArrayList initialSelections;
    boolean resolveIsVisible = true;
    QueryableMetadataRepositoryManager manager;
    boolean skipSelectionPage = false;

    public UpdateAction(Policy policy, ISelectionProvider selectionProvider, String profileId, boolean resolveIsVisible) {
        super(ProvUI.UPDATE_COMMAND_LABEL, policy, selectionProvider, profileId);
        this.setToolTipText(ProvUI.UPDATE_COMMAND_TOOLTIP);
        this.resolveIsVisible = resolveIsVisible;
    }

    public void setRepositoryManager(QueryableMetadataRepositoryManager manager) {
        this.manager = manager;
    }

    public void setSkipSelectionPage(boolean skipSelectionPage) {
        this.skipSelectionPage = skipSelectionPage;
    }

    protected int performAction(IInstallableUnit[] ius, String targetProfileId, PlannerResolutionOperation resolution) {
        Assert.isNotNull((Object)this.initialSelections);
        Assert.isNotNull((Object)this.root);
        Assert.isNotNull((Object)resolution);
        UpdateWizard wizard = new UpdateWizard(this.getPolicy(), targetProfileId, this.root, this.initialSelections.toArray(), resolution, this.manager);
        wizard.setSkipSelectionsPage(this.skipSelectionPage);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(this.getShell(), wizard);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.update_wizard_context");
        return dialog.open();
    }

    protected ProfileChangeRequest getProfileChangeRequest(IInstallableUnit[] ius, String targetProfileId, MultiStatus status, IProgressMonitor monitor) {
        this.initialSelections = new ArrayList();
        this.root = new IUElementListRoot();
        ProfileChangeRequest request = UpdateWizard.createProfileChangeRequest(ius, targetProfileId, this.root, this.initialSelections, monitor);
        if (request == null) {
            status.add(PlanAnalyzer.getStatus(10000, null));
            return null;
        }
        return request;
    }

    protected String getTaskName() {
        return ProvUIMessages.UpdateIUProgress;
    }

    protected boolean isResolveUserVisible() {
        return this.resolveIsVisible;
    }

    protected int getLockConstant() {
        return 2;
    }

    protected IStatus getNoProfileOrSelectionStatus(String id, IInstallableUnit[] ius) {
        if (ius.length == 0) {
            return PlanAnalyzer.getStatus(10000, null);
        }
        return super.getNoProfileOrSelectionStatus(id, ius);
    }
}

