/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.query;

import java.util.Iterator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElementWrapper;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;

public class AvailableIUWrapper
extends QueriedElementWrapper {
    private boolean makeCategories;
    private IProfile profile;
    private boolean hideInstalledIUs = false;
    private boolean drillDownChild = false;
    InformationCache cache = null;
    static /* synthetic */ Class class$0;

    public AvailableIUWrapper(IQueryable queryable, Object parent, boolean makeCategories, boolean makeDrillDownChild) {
        super(queryable, parent);
        this.makeCategories = makeCategories;
        this.drillDownChild = makeDrillDownChild;
    }

    public void markInstalledIUs(IProfile targetProfile, boolean hideInstalled) {
        this.profile = targetProfile;
        this.hideInstalledIUs = hideInstalled;
    }

    protected boolean shouldWrap(Object match) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter(match, clazz);
        this.cache = this.computeIUInformation(iu);
        if (this.hideInstalledIUs && this.cache.isInstalled && !this.cache.isUpdate) {
            this.emptyExplanationString = ProvUIMessages.AvailableIUWrapper_AllAreInstalled;
            this.emptyExplanationSeverity = 1;
            this.emptyExplanationDescription = ProvUIMessages.IUViewQueryContext_AllAreInstalledDescription;
            return false;
        }
        return true;
    }

    private InformationCache computeIUInformation(IInstallableUnit iu) {
        boolean isUpdate = false;
        boolean isInstalled = false;
        if (this.profile != null && iu != null) {
            Collector collector = this.profile.query((Query)new InstallableUnitQuery(iu.getId()), new Collector(), null);
            Iterator iter = collector.iterator();
            while (iter.hasNext()) {
                IInstallableUnit installed = (IInstallableUnit)iter.next();
                if (installed.getVersion().compareTo((Object)iu.getVersion()) < 0) {
                    isUpdate = true;
                    continue;
                }
                isUpdate = false;
                isInstalled = true;
            }
        }
        return new InformationCache(iu, isUpdate, isInstalled);
    }

    protected Object wrap(Object item) {
        IIUElement element;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter(item, clazz);
        boolean isUpdate = false;
        boolean isInstalled = false;
        if (this.cache != null && this.cache.item == item) {
            isUpdate = this.cache.isUpdate;
            isInstalled = this.cache.isInstalled;
        } else {
            InformationCache iuInformation = this.computeIUInformation(iu);
            isUpdate = iuInformation.isUpdate;
            isInstalled = iuInformation.isInstalled;
        }
        if (item instanceof AvailableIUElement) {
            element = (AvailableIUElement)item;
            ((AvailableIUElement)element).setIsInstalled(isInstalled);
            ((AvailableIUElement)element).setIsUpdate(isUpdate);
            return super.wrap(item);
        }
        if (!(item instanceof IInstallableUnit)) {
            return super.wrap(item);
        }
        if (this.makeCategories && this.isCategory(iu)) {
            return super.wrap(new CategoryElement(this.parent, iu));
        }
        element = this.makeDefaultElement(iu);
        if (element instanceof AvailableIUElement) {
            IIUElement availableElement = element;
            ((AvailableIUElement)availableElement).setIsInstalled(isInstalled);
            ((AvailableIUElement)availableElement).setIsUpdate(isUpdate);
        }
        return super.wrap(element);
    }

    protected IIUElement makeDefaultElement(IInstallableUnit iu) {
        if (this.parent instanceof AvailableIUElement) {
            this.drillDownChild = ((AvailableIUElement)this.parent).shouldShowChildren();
        }
        return new AvailableIUElement(this.parent, iu, null, this.drillDownChild);
    }

    protected boolean isCategory(IInstallableUnit iu) {
        String isCategory = iu.getProperty("org.eclipse.equinox.p2.type.category");
        return isCategory != null && Boolean.valueOf(isCategory) != false;
    }

    protected boolean makeCategory() {
        return this.makeCategories;
    }

    class InformationCache {
        Object item = null;
        boolean isUpdate = false;
        boolean isInstalled = false;

        public InformationCache(Object item, boolean isUpdate, boolean isInstalled) {
            this.item = item;
            this.isUpdate = isUpdate;
            this.isInstalled = isInstalled;
        }
    }
}

