/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contexts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.contexts.DebugModelContextBindingManager;
import org.eclipse.debug.internal.ui.contexts.DebugWindowContextService;
import org.eclipse.debug.internal.ui.views.ViewContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class DebugContextManager
implements IDebugContextManager {
    private static DebugContextManager fgDefault;
    private Map fServices = new HashMap();
    private ListenerList fGlobalListeners = new ListenerList();

    private DebugContextManager() {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)new WindowListener());
    }

    public static IDebugContextManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new DebugContextManager();
            DebugModelContextBindingManager.getDefault();
            ViewContextManager.getDefault();
        }
        return fgDefault;
    }

    protected DebugWindowContextService createService(IWorkbenchWindow window) {
        DebugWindowContextService service = (DebugWindowContextService)this.fServices.get(window);
        if (service == null) {
            service = new DebugWindowContextService(window);
            this.fServices.put(window, service);
            Object[] listeners = this.fGlobalListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IDebugContextListener listener = (IDebugContextListener)listeners[i];
                service.addDebugContextListener(listener);
                ++i;
            }
        }
        return service;
    }

    protected IDebugContextService getService(IWorkbenchWindow window) {
        return (DebugWindowContextService)this.fServices.get(window);
    }

    public void addDebugContextListener(IDebugContextListener listener) {
        this.fGlobalListeners.add((Object)listener);
        DebugWindowContextService[] services = this.getServices();
        int i = 0;
        while (i < services.length) {
            DebugWindowContextService service = services[i];
            service.addDebugContextListener(listener);
            ++i;
        }
    }

    public void removeDebugContextListener(IDebugContextListener listener) {
        this.fGlobalListeners.remove((Object)listener);
        DebugWindowContextService[] services = this.getServices();
        int i = 0;
        while (i < services.length) {
            DebugWindowContextService service = services[i];
            service.removeDebugContextListener(listener);
            ++i;
        }
    }

    private DebugWindowContextService[] getServices() {
        Collection sevices = this.fServices.values();
        return sevices.toArray(new DebugWindowContextService[sevices.size()]);
    }

    public IDebugContextService getContextService(IWorkbenchWindow window) {
        return this.createService(window);
    }

    static /* synthetic */ Map access$0(DebugContextManager debugContextManager) {
        return debugContextManager.fServices;
    }

    private class WindowListener
    implements IWindowListener {
        private WindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            new UIJob(this, window.getShell().getDisplay(), "DebugContextManager windowClosed() handler", window){
                final /* synthetic */ WindowListener this$1;
                private final /* synthetic */ IWorkbenchWindow val$window;
                {
                    this.this$1 = windowListener;
                    this.val$window = iWorkbenchWindow;
                    this.setSystem(true);
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DebugWindowContextService service = (DebugWindowContextService)DebugContextManager.access$0(WindowListener.access$1(this.this$1)).remove(this.val$window);
                    if (service != null) {
                        service.dispose();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        static /* synthetic */ DebugContextManager access$1(WindowListener windowListener) {
            return windowListener.DebugContextManager.this;
        }
    }
}

