/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.util.CodeSnippetParsingUtil;
import org.eclipse.jdt.internal.core.util.RecordedParsingInformation;
import org.eclipse.jdt.internal.formatter.AbortFormatting;
import org.eclipse.jdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.jdt.internal.formatter.FormatJavadoc;
import org.eclipse.jdt.internal.formatter.FormatJavadocBlock;
import org.eclipse.jdt.internal.formatter.FormatJavadocNode;
import org.eclipse.jdt.internal.formatter.FormatJavadocReference;
import org.eclipse.jdt.internal.formatter.FormatJavadocText;
import org.eclipse.jdt.internal.formatter.FormatterCommentParser;
import org.eclipse.jdt.internal.formatter.Location;
import org.eclipse.jdt.internal.formatter.OptimizedReplaceEdit;
import org.eclipse.jdt.internal.formatter.align.Alignment;
import org.eclipse.jdt.internal.formatter.align.AlignmentException;
import org.eclipse.jdt.internal.formatter.comment.CommentFormatterUtil;
import org.eclipse.jdt.internal.formatter.comment.HTMLEntity2JavaReader;
import org.eclipse.jdt.internal.formatter.comment.IJavaDocTagConstants;
import org.eclipse.jdt.internal.formatter.comment.Java2HTMLEntityReader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class Scribe
implements IJavaDocTagConstants {
    private static final int INITIAL_SIZE = 100;
    private boolean checkLineWrapping;
    public int column;
    private int[][] commentPositions;
    public Alignment currentAlignment;
    public int currentToken;
    private OptimizedReplaceEdit[] edits;
    public int editsIndex;
    public CodeFormatterVisitor formatter;
    public int indentationLevel;
    public int lastNumberOfNewLines;
    public int line;
    private int[] lineEnds;
    private int maxLines;
    private String lineSeparator;
    public Alignment memberAlignment;
    public boolean needSpace = false;
    public int nlsTagCounter;
    public int pageWidth;
    public boolean pendingSpace = false;
    public Scanner scanner;
    public int scannerEndPosition;
    public int tabLength;
    public int indentationSize;
    private final IRegion[] regions;
    private IRegion[] adaptedRegions;
    public int tabChar;
    public int numberOfIndentations;
    private boolean useTabsOnlyForLeadingIndents;
    private final boolean indentEmptyLines;
    private static final int INCLUDE_BLOCK_COMMENTS = 4128;
    private static final int INCLUDE_JAVA_DOC = 4160;
    private static final int INCLUDE_LINE_COMMENTS = 4112;
    private static final int SKIP_FIRST_WHITESPACE_TOKEN = -2;
    private static final int INVALID_TOKEN = 2000;
    private int formatComments = 0;
    private int headerEndPosition = -1;
    String commentIndentation;
    private FormatterCommentParser formatterCommentParser;

    Scribe(CodeFormatterVisitor formatter, long sourceLevel, IRegion[] regions, CodeSnippetParsingUtil codeSnippetParsingUtil, boolean includeComments) {
        RecordedParsingInformation information;
        this.scanner = new Scanner(true, true, false, sourceLevel, null, null, true);
        this.formatter = formatter;
        this.pageWidth = formatter.preferences.page_width;
        this.tabLength = formatter.preferences.tab_size;
        this.indentationLevel = 0;
        this.numberOfIndentations = 0;
        this.useTabsOnlyForLeadingIndents = formatter.preferences.use_tabs_only_for_leading_indentations;
        this.indentEmptyLines = formatter.preferences.indent_empty_lines;
        this.tabChar = formatter.preferences.tab_char;
        this.indentationSize = this.tabChar == 4 ? formatter.preferences.indentation_size : this.tabLength;
        this.lineSeparator = formatter.preferences.line_separator;
        this.indentationLevel = formatter.preferences.initial_indentation_level * this.indentationSize;
        this.regions = regions;
        if (codeSnippetParsingUtil != null && (information = codeSnippetParsingUtil.recordedParsingInformation) != null) {
            this.lineEnds = information.lineEnds;
            this.commentPositions = information.commentPositions;
        }
        if (formatter.preferences.comment_format_line_comment) {
            this.formatComments |= 0x10;
        }
        if (formatter.preferences.comment_format_block_comment) {
            this.formatComments |= 0x20;
        }
        if (formatter.preferences.comment_format_javadoc_comment) {
            this.formatComments |= 0x40;
        }
        if (includeComments) {
            this.formatComments |= 0x1000;
        }
        this.reset();
    }

    private void adaptRegions() {
        int max = this.regions.length;
        if (max == 1 && this.regions[0].getOffset() == 0 && this.regions[0].getLength() == this.scannerEndPosition) {
            this.adaptedRegions = this.regions;
            return;
        }
        this.adaptedRegions = new IRegion[max];
        int commentIndex = 0;
        int i = 0;
        while (i < max) {
            IRegion aRegion = this.regions[i];
            int offset = aRegion.getOffset();
            int length = aRegion.getLength();
            int index = this.getCommentIndex(commentIndex, offset);
            int adaptedOffset = offset;
            int adaptedLength = length;
            if (index >= 0 && (adaptedOffset = this.commentPositions[index][0]) >= 0) {
                adaptedLength = length + offset - adaptedOffset;
                commentIndex = index;
                int j = 0;
                while (j < this.editsIndex) {
                    int editOffset = this.edits[j].offset;
                    int editEnd = editOffset + this.edits[j].length;
                    if (editEnd == adaptedOffset) {
                        if (j > 0 && this.edits[j].replacement.trim().length() == 0) {
                            adaptedLength += adaptedOffset - this.edits[j].offset;
                            adaptedOffset = editOffset;
                            break;
                        }
                    } else if (editEnd > adaptedOffset) break;
                    ++j;
                }
            }
            if ((index = this.getCommentIndex(commentIndex, offset + length - 1)) >= 0 && this.commentPositions[index][0] >= 0) {
                int commentEnd = this.commentPositions[index][1];
                if (commentEnd < 0) {
                    commentEnd = -commentEnd;
                }
                adaptedLength = commentEnd - adaptedOffset;
                commentIndex = index;
            }
            this.adaptedRegions[i] = adaptedLength != length ? new Region(adaptedOffset, adaptedLength) : aRegion;
            ++i;
        }
    }

    private void adaptEdits() {
        int max = this.regions.length;
        if (max == 1 && this.regions[0].getOffset() == 0 && this.regions[0].getLength() == this.scannerEndPosition) {
            return;
        }
        OptimizedReplaceEdit[] sortedEdits = new OptimizedReplaceEdit[this.editsIndex];
        System.arraycopy(this.edits, 0, sortedEdits, 0, this.editsIndex);
        Arrays.sort(sortedEdits, new Comparator(){

            public int compare(Object o1, Object o2) {
                OptimizedReplaceEdit edit1 = (OptimizedReplaceEdit)o1;
                OptimizedReplaceEdit edit2 = (OptimizedReplaceEdit)o2;
                return edit1.offset - edit2.offset;
            }
        });
        int currentEdit = -1;
        int i = 0;
        while (i < max) {
            int length;
            IRegion region = this.adaptedRegions[i];
            int offset = region.getOffset();
            int index = this.adaptEdit(sortedEdits, currentEdit, offset, offset + (length = region.getLength()));
            if (index != -1) {
                currentEdit = index;
            }
            ++i;
        }
    }

    private int adaptEdit(OptimizedReplaceEdit[] sortedEdits, int start, int regionStart, int regionEnd) {
        int linesCount;
        int idx;
        int linesReplaced;
        int length;
        char ch;
        int editEnd;
        int editStart;
        int top;
        int bottom = start == -1 ? 0 : start;
        int topEnd = top = sortedEdits.length - 1;
        int i = 0;
        OptimizedReplaceEdit edit = null;
        int overlapIndex = -1;
        int linesOutside = -1;
        while (bottom <= top) {
            i = bottom + (top - bottom) / 2;
            edit = sortedEdits[i];
            editStart = edit.offset;
            editEnd = editStart + edit.length;
            if (regionStart < editStart) {
                top = i - 1;
                if (regionEnd >= editStart) continue;
                topEnd = top;
                continue;
            }
            if (regionStart >= editEnd) {
                bottom = i + 1;
                continue;
            }
            linesOutside = 0;
            this.scanner.resetTo(editStart, editEnd - 1);
            while (!this.scanner.atEnd()) {
                boolean before = this.scanner.currentPosition < regionStart;
                ch = (char)this.scanner.getNextChar();
                if (ch != '\n' || !before) continue;
                ++linesOutside;
            }
            edit.offset = regionStart;
            edit.length -= edit.offset - editStart;
            length = edit.replacement.length();
            if (length > 0) {
                linesReplaced = 0;
                idx = 0;
                while (idx < length) {
                    if (edit.replacement.charAt(idx) == '\n') {
                        ++linesReplaced;
                    }
                    ++idx;
                }
                if (linesReplaced > 0) {
                    int n = linesCount = linesOutside >= linesReplaced ? linesReplaced : linesOutside;
                    if (linesCount > 0) {
                        int idx2 = 0;
                        while (idx2 < length) {
                            char ch2 = edit.replacement.charAt(idx2);
                            if (ch2 == '\n') {
                                if (--linesCount == 0) {
                                    ++idx2;
                                    break;
                                }
                            } else if (ch2 != '\r') break;
                            ++idx2;
                        }
                        edit.replacement = idx2 >= length ? "" : edit.replacement.substring(idx2);
                    }
                }
            }
            overlapIndex = i;
            break;
        }
        if (overlapIndex != -1) {
            bottom = overlapIndex;
        }
        while (bottom <= topEnd) {
            i = bottom + (topEnd - bottom) / 2;
            edit = sortedEdits[i];
            editStart = edit.offset;
            editEnd = editStart + edit.length;
            if (regionEnd < editStart) {
                topEnd = i - 1;
                continue;
            }
            if (regionEnd >= editEnd) {
                bottom = i + 1;
                continue;
            }
            linesOutside = 0;
            this.scanner.resetTo(editStart, editEnd - 1);
            while (!this.scanner.atEnd()) {
                boolean after = this.scanner.currentPosition >= regionEnd;
                ch = (char)this.scanner.getNextChar();
                if (ch != '\n' || !after) continue;
                ++linesOutside;
            }
            length = edit.replacement.length();
            if (length > 0) {
                linesReplaced = 0;
                idx = 0;
                while (idx < length) {
                    if (edit.replacement.charAt(idx) == '\n') {
                        ++linesReplaced;
                    }
                    ++idx;
                }
                if (linesReplaced == 0) {
                    edit.replacement = "";
                } else {
                    int n = linesCount = linesReplaced > linesOutside ? linesReplaced - linesOutside : 0;
                    if (linesCount == 0) {
                        edit.replacement = "";
                    } else {
                        StringBuffer buffer = new StringBuffer();
                        int j = 0;
                        while (j < linesCount) {
                            buffer.append(this.lineSeparator);
                            ++j;
                        }
                        edit.replacement = buffer.toString();
                    }
                }
            }
            edit.length -= editEnd - regionEnd;
            return i;
        }
        return overlapIndex;
    }

    private final void addDeleteEdit(int start, int end) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(start, end - start + 1, Util.EMPTY_STRING);
    }

    public final void addInsertEdit(int insertPosition, String insertedString) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(insertPosition, 0, insertedString);
    }

    private final void addOptimizedReplaceEdit(int offset, int length, String replacement) {
        if (this.editsIndex > 0) {
            OptimizedReplaceEdit previous = this.edits[this.editsIndex - 1];
            int previousOffset = previous.offset;
            int previousLength = previous.length;
            int endOffsetOfPreviousEdit = previousOffset + previousLength;
            int replacementLength = replacement.length();
            String previousReplacement = previous.replacement;
            int previousReplacementLength = previousReplacement.length();
            if (previousOffset == offset && previousLength == length && (replacementLength == 0 || previousReplacementLength == 0)) {
                if (this.currentAlignment != null) {
                    Location location = this.currentAlignment.location;
                    if (location.editsIndex == this.editsIndex) {
                        --location.editsIndex;
                        location.textEdit = previous;
                    }
                }
                --this.editsIndex;
                return;
            }
            if (endOffsetOfPreviousEdit == offset) {
                if (length != 0) {
                    if (replacementLength != 0) {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength + length, String.valueOf(previousReplacement) + replacement);
                    } else if (previousLength + length == previousReplacementLength) {
                        boolean canBeRemoved = true;
                        int i = previousOffset;
                        while (i < previousOffset + previousReplacementLength) {
                            if (this.scanner.source[i] != previousReplacement.charAt(i - previousOffset)) {
                                this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousReplacementLength, previousReplacement);
                                canBeRemoved = false;
                                break;
                            }
                            ++i;
                        }
                        if (canBeRemoved) {
                            if (this.currentAlignment != null) {
                                Location location = this.currentAlignment.location;
                                if (location.editsIndex == this.editsIndex) {
                                    --location.editsIndex;
                                    location.textEdit = previous;
                                }
                            }
                            --this.editsIndex;
                        }
                    } else {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength + length, previousReplacement);
                    }
                } else if (replacementLength != 0) {
                    this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength, String.valueOf(previousReplacement) + replacement);
                }
            } else if (offset + length == previousOffset && previousLength + length == replacementLength + previousReplacementLength) {
                boolean canBeRemoved = true;
                String totalReplacement = String.valueOf(replacement) + previousReplacement;
                int i = 0;
                while (i < previousLength + length) {
                    if (this.scanner.source[i + offset] != totalReplacement.charAt(i)) {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(offset, previousLength + length, totalReplacement);
                        canBeRemoved = false;
                        break;
                    }
                    ++i;
                }
                if (canBeRemoved) {
                    if (this.currentAlignment != null) {
                        Location location = this.currentAlignment.location;
                        if (location.editsIndex == this.editsIndex) {
                            --location.editsIndex;
                            location.textEdit = previous;
                        }
                    }
                    --this.editsIndex;
                }
            } else {
                this.edits[this.editsIndex++] = new OptimizedReplaceEdit(offset, length, replacement);
            }
        } else {
            this.edits[this.editsIndex++] = new OptimizedReplaceEdit(offset, length, replacement);
        }
    }

    public final void addReplaceEdit(int start, int end, String replacement) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(start, end - start + 1, replacement);
    }

    public void alignFragment(Alignment alignment, int fragmentIndex) {
        alignment.fragmentIndex = fragmentIndex;
        alignment.checkColumn();
        alignment.performFragmentEffect();
    }

    public void checkNLSTag(int sourceStart) {
        if (this.hasNLSTag(sourceStart)) {
            ++this.nlsTagCounter;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int consumeInvalidToken(int end) {
        this.scanner.resetTo(this.scanner.startPosition, end);
        if (this.scanner.currentCharacter == '\\') {
            this.scanner.currentPosition = this.scanner.startPosition + 1;
        }
        previousPosition = this.scanner.currentPosition;
        ch = (char)this.scanner.getNextChar();
        if (!this.scanner.atEnd()) ** GOTO lbl10
        return 2000;
lbl-1000:
        // 1 sources

        {
            previousPosition = this.scanner.currentPosition;
            ch = (char)this.scanner.getNextChar();
lbl10:
            // 2 sources

            ** while (!this.scanner.atEnd() && ch != '*' && !ScannerHelper.isWhitespace((char)ch))
        }
lbl11:
        // 1 sources

        this.scanner.currentPosition = previousPosition;
        return 2000;
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart) {
        return this.createAlignment(name, mode, 2, count, sourceRestart);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, adjust);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart) {
        return this.createAlignment(name, mode, tieBreakRule, count, sourceRestart, this.formatter.preferences.continuation_indentation, false);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, continuationIndent, adjust);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        Alignment alignment = new Alignment(name, mode, tieBreakRule, this, count, sourceRestart, continuationIndent);
        if (adjust && this.memberAlignment != null) {
            Alignment current = this.memberAlignment;
            while (current.enclosing != null) {
                current = current.enclosing;
            }
            if ((current.mode & 0x100) != 0) {
                int indentSize = this.indentationSize;
                switch (current.chunkKind) {
                    case 2: 
                    case 3: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? this.indentationLevel + indentSize : this.indentationLevel + continuationIndent * indentSize;
                        alignment.update();
                        break;
                    }
                    case 1: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? current.originalIndentationLevel + indentSize : current.originalIndentationLevel + continuationIndent * indentSize;
                        alignment.update();
                    }
                }
            } else {
                block4 : switch (current.mode & 0x70) {
                    case 16: 
                    case 32: 
                    case 48: 
                    case 64: 
                    case 80: {
                        int indentSize = this.indentationSize;
                        switch (current.chunkKind) {
                            case 2: 
                            case 3: {
                                alignment.breakIndentationLevel = (mode & 4) != 0 ? this.indentationLevel + indentSize : this.indentationLevel + continuationIndent * indentSize;
                                alignment.update();
                                break block4;
                            }
                            case 1: {
                                alignment.breakIndentationLevel = (mode & 4) != 0 ? current.originalIndentationLevel + indentSize : current.originalIndentationLevel + continuationIndent * indentSize;
                                alignment.update();
                            }
                        }
                    }
                }
            }
        }
        return alignment;
    }

    public Alignment createMemberAlignment(String name, int mode, int count, int sourceRestart) {
        Alignment mAlignment = this.createAlignment(name, mode, 2, count, sourceRestart);
        mAlignment.breakIndentationLevel = this.indentationLevel;
        return mAlignment;
    }

    public void enterAlignment(Alignment alignment) {
        alignment.enclosing = this.currentAlignment;
        alignment.location.lastLocalDeclarationSourceStart = this.formatter.lastLocalDeclarationSourceStart;
        this.currentAlignment = alignment;
    }

    public void enterMemberAlignment(Alignment alignment) {
        alignment.enclosing = this.memberAlignment;
        alignment.location.lastLocalDeclarationSourceStart = this.formatter.lastLocalDeclarationSourceStart;
        this.memberAlignment = alignment;
    }

    public void exitAlignment(Alignment alignment, boolean discardAlignment) {
        Alignment current = this.currentAlignment;
        while (current != null) {
            if (current == alignment) break;
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = alignment.location.outputIndentationLevel;
        this.numberOfIndentations = alignment.location.numberOfIndentations;
        this.formatter.lastLocalDeclarationSourceStart = alignment.location.lastLocalDeclarationSourceStart;
        if (discardAlignment) {
            this.currentAlignment = alignment.enclosing;
        }
    }

    public void exitMemberAlignment(Alignment alignment) {
        Alignment current = this.memberAlignment;
        while (current != null) {
            if (current == alignment) break;
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = current.location.outputIndentationLevel;
        this.numberOfIndentations = current.location.numberOfIndentations;
        this.formatter.lastLocalDeclarationSourceStart = alignment.location.lastLocalDeclarationSourceStart;
        this.memberAlignment = current.enclosing;
    }

    public Alignment getAlignment(String name) {
        if (this.currentAlignment != null) {
            return this.currentAlignment.getAlignment(name);
        }
        return null;
    }

    public int getColumnIndentationLevel() {
        return this.column - 1;
    }

    public final int getCommentIndex(int position) {
        if (this.commentPositions == null) {
            return -1;
        }
        int length = this.commentPositions.length;
        if (length == 0) {
            return -1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = g + (d - g) / 2;
            int bound = this.commentPositions[m][1];
            if (bound < 0) {
                bound = -bound;
            }
            if (bound < position) {
                g = m + 1;
                continue;
            }
            if (bound > position) {
                d = m - 1;
                continue;
            }
            return m;
        }
        return -(g + 1);
    }

    private int getCommentIndex(int start, int position) {
        int commentsLength;
        int n = commentsLength = this.commentPositions == null ? 0 : this.commentPositions.length;
        if (commentsLength == 0) {
            return -1;
        }
        if (position == 0) {
            if (commentsLength > 0 && this.commentPositions[0][0] == 0) {
                return 0;
            }
            return -1;
        }
        int bottom = start;
        int top = commentsLength - 1;
        int i = 0;
        int[] comment = null;
        while (bottom <= top) {
            i = bottom + (top - bottom) / 2;
            comment = this.commentPositions[i];
            int commentStart = comment[0];
            if (commentStart < 0) {
                commentStart = -commentStart;
            }
            if (position < commentStart) {
                top = i - 1;
                continue;
            }
            int commentEnd = comment[1];
            if (commentEnd < 0) {
                commentEnd = -commentEnd;
            }
            if (position >= commentEnd) {
                bottom = i + 1;
                continue;
            }
            return i;
        }
        return -1;
    }

    private IRegion getCoveringAdaptedRegion(int offset, int end) {
        IRegion region;
        int index = this.getIndexOfAdaptedRegionAt(offset);
        if (index < 0) {
            index = -(index + 1);
            if (--index < 0) {
                return null;
            }
        }
        if ((region = this.adaptedRegions[index]).getOffset() <= offset && end <= region.getOffset() + region.getLength() - 1) {
            return region;
        }
        return null;
    }

    private int getCurrentCommentOffset(int start) {
        int linePtr = -Arrays.binarySearch(this.lineEnds, start);
        int offset = 0;
        int beginningOfLine = this.getLineEnd(linePtr - 1);
        if (beginningOfLine == -1) {
            beginningOfLine = 0;
        }
        int currentStartPosition = start;
        char[] source = this.scanner.source;
        while (beginningOfLine > currentStartPosition) {
            if (linePtr > 0) {
                beginningOfLine = this.getLineEnd(--linePtr);
                continue;
            }
            beginningOfLine = 0;
            break;
        }
        int i = currentStartPosition - 1;
        while (i >= beginningOfLine) {
            char currentCharacter = source[i];
            switch (currentCharacter) {
                case '\t': {
                    offset += this.tabLength;
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    ++offset;
                }
            }
            --i;
        }
        return offset;
    }

    public String getEmptyLines(int linesNumber) {
        if (this.nlsTagCounter > 0) {
            return Util.EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.lastNumberOfNewLines == 0) {
            ++linesNumber;
            int i = 0;
            while (i < linesNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        } else if (this.lastNumberOfNewLines == 1) {
            int i = 0;
            while (i < linesNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        } else {
            if (this.lastNumberOfNewLines - 1 >= linesNumber) {
                return Util.EMPTY_STRING;
            }
            int realNewLineNumber = linesNumber - this.lastNumberOfNewLines + 1;
            int i = 0;
            while (i < realNewLineNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += realNewLineNumber;
            this.line += realNewLineNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        }
        return String.valueOf(buffer);
    }

    private int getIndexOfAdaptedRegionAt(int offset) {
        if (this.adaptedRegions.length == 1) {
            int offset2 = this.adaptedRegions[0].getOffset();
            if (offset2 == offset) {
                return 0;
            }
            return offset2 < offset ? -2 : -1;
        }
        return Arrays.binarySearch(this.adaptedRegions, new Region(offset, 0), new Comparator(){

            public int compare(Object o1, Object o2) {
                int r1Offset = ((IRegion)o1).getOffset();
                int r2Offset = ((IRegion)o2).getOffset();
                return r1Offset - r2Offset;
            }
        });
    }

    public OptimizedReplaceEdit getLastEdit() {
        if (this.editsIndex > 0) {
            return this.edits[this.editsIndex - 1];
        }
        return null;
    }

    public final int getLineEnd(int lineNumber) {
        if (this.lineEnds == null) {
            return -1;
        }
        if (lineNumber >= this.lineEnds.length + 1) {
            return this.scannerEndPosition;
        }
        if (lineNumber <= 0) {
            return -1;
        }
        return this.lineEnds[lineNumber - 1];
    }

    Alignment getMemberAlignment() {
        return this.memberAlignment;
    }

    public String getNewLine() {
        if (this.nlsTagCounter > 0) {
            return Util.EMPTY_STRING;
        }
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return Util.EMPTY_STRING;
        }
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
        return this.lineSeparator;
    }

    public int getNextIndentationLevel(int someColumn) {
        int indent = someColumn - 1;
        if (indent == 0) {
            return this.indentationLevel;
        }
        if (this.tabChar == 1) {
            if (this.useTabsOnlyForLeadingIndents) {
                return indent;
            }
            int rem = indent % this.indentationSize;
            int addition = rem == 0 ? 0 : this.indentationSize - rem;
            return indent + addition;
        }
        return indent;
    }

    private String getPreserveEmptyLines(int count) {
        if (count == 0) {
            if (this.currentAlignment != null && this.memberAlignment != null && !this.formatter.preferences.join_wrapped_lines && this.memberAlignment.depth() <= this.currentAlignment.depth()) {
                int savedIndentation = this.indentationLevel;
                StringBuffer buffer = new StringBuffer(this.getNewLine());
                this.indentationLevel = this.currentAlignment.breakIndentationLevel;
                this.printIndentationIfNecessary(buffer);
                this.indentationLevel = savedIndentation;
                return buffer.toString();
            }
            return Util.EMPTY_STRING;
        }
        if (this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
            int linesToPreserve = Math.min(count, this.formatter.preferences.number_of_empty_lines_to_preserve);
            return this.getEmptyLines(linesToPreserve);
        }
        return this.getNewLine();
    }

    private IRegion getAdaptedRegionAt(int offset) {
        int index = this.getIndexOfAdaptedRegionAt(offset);
        if (index < 0) {
            return null;
        }
        return this.adaptedRegions[index];
    }

    public TextEdit getRootEdit() {
        int textRegionEnd;
        int textRegionStart;
        IRegion lastRegion;
        this.adaptRegions();
        this.adaptEdits();
        MultiTextEdit edit = null;
        int regionsLength = this.adaptedRegions.length;
        if (regionsLength == 1) {
            lastRegion = this.adaptedRegions[0];
            textRegionStart = lastRegion.getOffset();
            textRegionEnd = textRegionStart + lastRegion.getLength();
        } else {
            textRegionStart = this.adaptedRegions[0].getOffset();
            lastRegion = this.adaptedRegions[regionsLength - 1];
            textRegionEnd = lastRegion.getOffset() + lastRegion.getLength();
        }
        int length = textRegionEnd - textRegionStart + 1;
        edit = textRegionStart <= 0 ? (length <= 0 ? new MultiTextEdit(0, 0) : new MultiTextEdit(0, textRegionEnd)) : new MultiTextEdit(textRegionStart, length - 1);
        int i = 0;
        int max = this.editsIndex;
        while (i < max) {
            OptimizedReplaceEdit currentEdit = this.edits[i];
            if (this.isValidEdit(currentEdit)) {
                try {
                    edit.addChild((TextEdit)new ReplaceEdit(currentEdit.offset, currentEdit.length, currentEdit.replacement));
                }
                catch (MalformedTreeException ex) {
                    CommentFormatterUtil.log(ex);
                    throw ex;
                }
            }
            ++i;
        }
        this.edits = null;
        return edit;
    }

    public void handleLineTooLong() {
        int relativeDepth = 0;
        int outerMostDepth = -1;
        Alignment targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.tieBreakRule == 1 && targetAlignment.couldBreak()) {
                outerMostDepth = relativeDepth;
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
        if (outerMostDepth >= 0) {
            throw new AlignmentException(1, outerMostDepth);
        }
        relativeDepth = 0;
        targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.couldBreak()) {
                throw new AlignmentException(1, relativeDepth);
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
    }

    private boolean hasNLSTag(int sourceStart) {
        if (this.lineEnds == null) {
            return false;
        }
        int index = Arrays.binarySearch(this.lineEnds, sourceStart);
        int currentLineEnd = this.getLineEnd(-index);
        if (currentLineEnd != -1) {
            int lineIndexForComment;
            int start;
            int commentIndex = this.getCommentIndex(currentLineEnd);
            if (commentIndex < 0) {
                commentIndex = -commentIndex - 2;
            }
            if (commentIndex >= 0 && commentIndex < this.commentPositions.length && (start = this.commentPositions[commentIndex][0]) < 0 && (lineIndexForComment = Arrays.binarySearch(this.lineEnds, start = -start)) == index) {
                return CharOperation.indexOf(Scanner.TAG_PREFIX, this.scanner.source, true, start, currentLineEnd) != -1;
            }
        }
        return false;
    }

    private boolean includesBlockComments() {
        return (this.formatComments & 0x1020) == 4128 && this.headerEndPosition < this.scanner.currentPosition || this.formatter.preferences.comment_format_header && this.headerEndPosition >= this.scanner.currentPosition;
    }

    private boolean includesJavadocComments() {
        return (this.formatComments & 0x1040) == 4160 && this.headerEndPosition < this.scanner.currentPosition || this.formatter.preferences.comment_format_header && this.headerEndPosition >= this.scanner.currentPosition;
    }

    private boolean includesLineComments() {
        return (this.formatComments & 0x1010) == 4112 && this.headerEndPosition < this.scanner.currentPosition || this.formatter.preferences.comment_format_header && this.headerEndPosition >= this.scanner.currentPosition;
    }

    boolean includesComments() {
        return (this.formatComments & 0x1000) != 0;
    }

    public void indent() {
        this.indentationLevel += this.indentationSize;
        ++this.numberOfIndentations;
    }

    public void initializeScanner(char[] compilationUnitSource) {
        this.scanner.setSource(compilationUnitSource);
        this.scannerEndPosition = compilationUnitSource.length;
        this.scanner.resetTo(0, this.scannerEndPosition - 1);
        this.edits = new OptimizedReplaceEdit[100];
        this.maxLines = this.lineEnds == null ? -1 : this.lineEnds.length - 1;
        this.scanner.lineEnds = this.lineEnds;
        this.scanner.linePtr = this.maxLines;
        this.initFormatterCommentParser();
    }

    private void initFormatterCommentParser() {
        if (this.formatterCommentParser == null) {
            this.formatterCommentParser = new FormatterCommentParser(this.scanner.sourceLevel);
        }
        this.formatterCommentParser.scanner.setSource(this.scanner.source);
        this.formatterCommentParser.source = this.scanner.source;
        this.formatterCommentParser.scanner.lineEnds = this.lineEnds;
        this.formatterCommentParser.scanner.linePtr = this.maxLines;
        this.formatterCommentParser.parseHtmlTags = this.formatter.preferences.comment_format_html;
    }

    private boolean isOnFirstColumn(int start) {
        if (this.lineEnds == null) {
            return start == 0;
        }
        int index = Arrays.binarySearch(this.lineEnds, start);
        int previousLineEnd = this.getLineEnd(-index - 1);
        return previousLineEnd != -1 && previousLineEnd == start - 1;
    }

    private boolean isValidEdit(OptimizedReplaceEdit edit) {
        int editLength = edit.length;
        int editReplacementLength = edit.replacement.length();
        int editOffset = edit.offset;
        if (editLength != 0) {
            IRegion covering = this.getCoveringAdaptedRegion(editOffset, editOffset + editLength - 1);
            if (covering != null) {
                if (editReplacementLength != 0 && editLength == editReplacementLength) {
                    int i = editOffset;
                    int max = editOffset + editLength;
                    while (i < max) {
                        if (this.scanner.source[i] != edit.replacement.charAt(i - editOffset)) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                return true;
            }
            IRegion starting = this.getAdaptedRegionAt(editOffset + editLength);
            if (starting != null) {
                int i = editOffset;
                int max = editOffset + editLength;
                while (i < max) {
                    int replacementStringIndex = i - editOffset;
                    if (replacementStringIndex >= editReplacementLength || this.scanner.source[i] != edit.replacement.charAt(replacementStringIndex)) break;
                    ++i;
                }
                if (i - editOffset != editReplacementLength && i != editOffset + editLength - 1) {
                    edit.offset = starting.getOffset();
                    edit.length = 0;
                    edit.replacement = edit.replacement.substring(i - editOffset);
                    return true;
                }
            }
            return false;
        }
        IRegion covering = this.getCoveringAdaptedRegion(editOffset, editOffset);
        if (covering != null) {
            return true;
        }
        if (editOffset == this.scannerEndPosition) {
            int index = Arrays.binarySearch(this.adaptedRegions, new Region(editOffset, 0), new Comparator(){

                public int compare(Object o1, Object o2) {
                    IRegion r1 = (IRegion)o1;
                    IRegion r2 = (IRegion)o2;
                    int r1End = r1.getOffset() + r1.getLength();
                    int r2End = r2.getOffset() + r2.getLength();
                    return r1End - r2End;
                }
            });
            return index >= 0;
        }
        return false;
    }

    private void preserveEmptyLines(int count, int insertPosition) {
        if (count > 0) {
            if (this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                int linesToPreserve = Math.min(count, this.formatter.preferences.number_of_empty_lines_to_preserve);
                this.printEmptyLines(linesToPreserve, insertPosition);
            } else {
                this.printNewLine(insertPosition);
            }
        }
    }

    private void print(int length, boolean considerSpaceIfAny) {
        if (this.checkLineWrapping && length + this.column > this.pageWidth) {
            this.handleLineTooLong();
        }
        this.lastNumberOfNewLines = 0;
        if (this.indentationLevel != 0) {
            this.printIndentationIfNecessary();
        }
        if (considerSpaceIfAny) {
            this.space();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), " ");
        }
        this.pendingSpace = false;
        this.needSpace = false;
        this.column += length;
        this.needSpace = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void printBlockComment(boolean isJavadoc) {
        currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        includesBlockComments = isJavadoc == false && this.includesBlockComments() != false;
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
        isNewLine = false;
        start = currentTokenStartPosition;
        nextCharacterStart = currentTokenStartPosition;
        previousStart = currentTokenStartPosition;
        onFirstColumn = this.isOnFirstColumn(start);
        indentComment = false;
        if (!(this.indentationLevel == 0 || !isJavadoc && this.formatter.preferences.never_indent_block_comments_on_first_column && onFirstColumn)) {
            indentComment = true;
            this.printIndentationIfNecessary();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(currentTokenStartPosition, " ");
        }
        this.needSpace = false;
        this.pendingSpace = false;
        commentColumn = this.column;
        if (includesBlockComments && this.printBlockComment(currentTokenStartPosition, currentTokenEndPosition)) {
            return;
        }
        currentIndentationLevel = this.indentationLevel;
        if (commentColumn - 1 > this.indentationLevel) {
            this.indentationLevel = commentColumn - 1;
        }
        currentCommentOffset = onFirstColumn != false ? 0 : this.getCurrentCommentOffset(start);
        formatComment = isJavadoc != false && (this.formatComments & 64) != 0 || isJavadoc == false && (this.formatComments & 32) != 0;
        try {
            while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
                nextCharacterStart = this.scanner.currentPosition;
                switch (currentCharacter) {
                    case 13: {
                        start = previousStart;
                        isNewLine = true;
                        if (!this.scanner.getNextChar('\n')) break;
                        currentCharacter = 10;
                        nextCharacterStart = this.scanner.currentPosition;
                        break;
                    }
                    case 10: {
                        start = previousStart;
                        isNewLine = true;
                        nextCharacterStart = this.scanner.currentPosition;
                        break;
                    }
                    default: {
                        if (!isNewLine) ** GOTO lbl61
                        this.column = 1;
                        ++this.line;
                        isNewLine = false;
                        buffer = new StringBuffer();
                        if (!onFirstColumn) ** GOTO lbl57
                        buffer.append(this.lineSeparator);
                        if (indentComment) {
                            this.printIndentationIfNecessary(buffer);
                        }
                        if (!formatComment) ** GOTO lbl108
                        if (!ScannerHelper.isWhitespace((char)currentCharacter)) ** GOTO lbl71
                        previousStartPosition = this.scanner.currentPosition;
                        if (true) ** GOTO lbl68
lbl57:
                        // 1 sources

                        if (!ScannerHelper.isWhitespace((char)currentCharacter)) ** GOTO lbl89
                        previousStartPosition = this.scanner.currentPosition;
                        count = 0;
                        ** GOTO lbl86
lbl61:
                        // 1 sources

                        this.column += nextCharacterStart - previousStart;
                        break;
                        do {
                            previousStart = nextCharacterStart;
                            previousStartPosition = this.scanner.currentPosition;
                            currentCharacter = this.scanner.getNextChar();
                            nextCharacterStart = this.scanner.currentPosition;
lbl68:
                            // 2 sources

                        } while (currentCharacter != -1 && currentCharacter != 13 && currentCharacter != 10 && ScannerHelper.isWhitespace((char)currentCharacter));
                        if (currentCharacter == 13 || currentCharacter == 10) {
                            nextCharacterStart = previousStartPosition;
                        }
lbl71:
                        // 4 sources

                        if (currentCharacter == 13 || currentCharacter == 10) ** GOTO lbl108
                        buffer.append(' ');
                        ** GOTO lbl108
                        while (count < currentCommentOffset) {
                            previousStart = nextCharacterStart;
                            previousStartPosition = this.scanner.currentPosition;
                            switch (currentCharacter) {
                                case 9: {
                                    count += this.tabLength;
                                    break;
                                }
                                default: {
                                    ++count;
                                }
                            }
                            currentCharacter = this.scanner.getNextChar();
                            nextCharacterStart = this.scanner.currentPosition;
lbl86:
                            // 2 sources

                            if (currentCharacter != -1 && currentCharacter != 13 && currentCharacter != 10 && ScannerHelper.isWhitespace((char)currentCharacter)) continue;
                        }
                        if (currentCharacter == 13 || currentCharacter == 10) {
                            nextCharacterStart = previousStartPosition;
                        }
lbl89:
                        // 4 sources

                        buffer.append(this.lineSeparator);
                        if (indentComment) {
                            this.printIndentationIfNecessary(buffer);
                        }
                        if (formatComment) {
                            previousStartTemp = previousStart;
                            nextCharacterStartTemp = nextCharacterStart;
                            while (currentCharacter != -1 && currentCharacter != 13 && currentCharacter != 10 && ScannerHelper.isWhitespace((char)currentCharacter)) {
                                previousStart = nextCharacterStart;
                                currentCharacter = this.scanner.getNextChar();
                                nextCharacterStart = this.scanner.currentPosition;
                            }
                            if (currentCharacter == 42) {
                                buffer.append(' ');
                            } else {
                                previousStart = previousStartTemp;
                                nextCharacterStart = nextCharacterStartTemp;
                            }
                            this.scanner.currentPosition = nextCharacterStart;
                        }
lbl108:
                        // 6 sources

                        this.addReplaceEdit(start, previousStart - 1, String.valueOf(buffer));
                        break;
                    }
                }
                previousStart = nextCharacterStart;
                this.scanner.currentPosition = nextCharacterStart;
            }
        }
        finally {
            this.indentationLevel = currentIndentationLevel;
        }
        this.lastNumberOfNewLines = 0;
        this.needSpace = false;
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean printBlockComment(int currentTokenStartPosition, int currentTokenEndPosition) {
        int scannerLine;
        int maxColumn = this.formatter.preferences.comment_line_length + 1;
        int indentLevel = this.indentationLevel;
        int indentations = this.numberOfIndentations;
        block1 : switch (this.tabChar) {
            case 1: {
                switch (this.tabLength) {
                    case 0: {
                        this.indentationLevel = 0;
                        this.column = 1;
                        this.numberOfIndentations = 0;
                        break block1;
                    }
                    case 1: {
                        this.numberOfIndentations = this.indentationLevel = this.column - 1;
                        break block1;
                    }
                }
                this.indentationLevel = this.column / this.tabLength * this.tabLength;
                this.column = this.indentationLevel + 1;
                this.numberOfIndentations = this.indentationLevel / this.tabLength;
                break;
            }
            case 4: {
                if (this.tabLength == 0) {
                    this.indentationLevel = 0;
                    this.column = 1;
                    this.numberOfIndentations = 0;
                    break;
                }
                this.indentationLevel = this.column - 1;
                this.numberOfIndentations = this.indentationLevel / this.tabLength;
                break;
            }
            case 2: {
                if (this.indentationSize == 0) {
                    this.indentationLevel = 0;
                    this.column = 1;
                    this.numberOfIndentations = 0;
                    break;
                }
                this.indentationLevel = this.column - 1;
                break;
            }
        }
        StringBuffer buffer = new StringBuffer();
        this.scanner.getNextChar();
        this.scanner.getNextChar();
        this.column += 2;
        this.scanner.skipComments = true;
        StringBuffer tokensBuffer = new StringBuffer();
        int editStart = this.scanner.currentPosition;
        int editEnd = -1;
        int previousToken = -1;
        boolean newLine = false;
        boolean multiLines = false;
        boolean hasMultiLines = false;
        boolean hasTokens = false;
        boolean bufferHasTokens = false;
        boolean lineHasTokens = false;
        int hasTextOnFirstLine = 0;
        boolean firstWord = true;
        boolean clearBlankLines = this.formatter.preferences.comment_clear_blank_lines_in_block_comment;
        boolean joinLines = this.formatter.preferences.join_lines_in_comments;
        int firstLine = scannerLine = Util.getLineNumber(this.scanner.currentPosition, this.lineEnds, 0, this.maxLines);
        int lineNumber = scannerLine;
        int lastTextLine = -1;
        block17: while (!this.scanner.atEnd()) {
            int max;
            int linesGap;
            int token;
            try {
                token = this.scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                token = this.consumeInvalidToken(currentTokenEndPosition - 1);
                newLine = false;
            }
            boolean insertSpace = previousToken == 1000 && (!firstWord || !hasTokens);
            boolean isTokenStar = false;
            switch (token) {
                case 1000: {
                    if (tokensBuffer.length() > 0) {
                        if (hasTextOnFirstLine == 1 && multiLines) {
                            this.printBlockCommentHeaderLine(buffer);
                            hasTextOnFirstLine = -1;
                        }
                        buffer.append(tokensBuffer);
                        this.column += tokensBuffer.length();
                        tokensBuffer.setLength(0);
                        bufferHasTokens = true;
                    }
                    previousToken = previousToken == -1 ? -2 : token;
                    lineNumber = Util.getLineNumber(this.scanner.currentPosition, this.lineEnds, scannerLine > 1 ? scannerLine - 2 : 0, this.maxLines);
                    if (lineNumber > scannerLine) {
                        hasMultiLines = true;
                        newLine = true;
                    }
                    scannerLine = lineNumber;
                    continue block17;
                }
                case 4: {
                    isTokenStar = true;
                    lineNumber = Util.getLineNumber(this.scanner.currentPosition, this.lineEnds, scannerLine > 1 ? scannerLine - 2 : 0, this.maxLines);
                    if (lineNumber == firstLine && previousToken == -2) {
                        editStart = this.scanner.getCurrentTokenStartPosition();
                    }
                    previousToken = token;
                    if (this.scanner.currentCharacter == '/') {
                        editEnd = this.scanner.startPosition - 1;
                        if (tokensBuffer.length() > 0) {
                            buffer.append(tokensBuffer);
                            this.column += tokensBuffer.length();
                        }
                        if (multiLines || hasMultiLines) {
                            buffer.append(this.lineSeparator);
                            this.column = 1;
                            this.printIndentationIfNecessary(buffer);
                        }
                        buffer.append(' ');
                        this.column += BLOCK_FOOTER_LENGTH + 1;
                        this.scanner.getNextChar();
                        continue block17;
                    }
                    if (!newLine) break;
                    scannerLine = lineNumber;
                    newLine = false;
                    continue block17;
                }
                case 86: {
                    if (!newLine) break;
                    this.scanner.resetTo(this.scanner.startPosition, currentTokenEndPosition - 1);
                    this.scanner.getNextChar();
                    previousToken = 4;
                    scannerLine = Util.getLineNumber(this.scanner.currentPosition, this.lineEnds, scannerLine > 1 ? scannerLine - 2 : 0, this.maxLines);
                    continue block17;
                }
                case 2: 
                case 9: {
                    if (previousToken != -1) break;
                    this.indentationLevel = indentLevel;
                    this.numberOfIndentations = indentations;
                    this.lastNumberOfNewLines = 0;
                    this.needSpace = false;
                    this.scanner.skipComments = false;
                    this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
                    return false;
                }
            }
            lineNumber = Util.getLineNumber(this.scanner.currentPosition, this.lineEnds, scannerLine > 1 ? scannerLine - 2 : 0, this.maxLines);
            if (lastTextLine == -1) {
                linesGap = lineNumber - firstLine;
                max = 0;
            } else {
                linesGap = lineNumber - lastTextLine;
                if (token == 53 && linesGap == 1) {
                    linesGap = 2;
                }
                int n = max = joinLines && lineHasTokens ? 1 : 0;
            }
            if (linesGap > max) {
                if (clearBlankLines) {
                    linesGap = token == 53 ? 1 : (max == 0 || !joinLines ? 1 : 0);
                }
                int i = 0;
                while (i < linesGap) {
                    if (tokensBuffer.length() > 0) {
                        if (hasTextOnFirstLine == 1) {
                            this.printBlockCommentHeaderLine(buffer);
                            hasTextOnFirstLine = -1;
                        }
                        buffer.append(tokensBuffer);
                        tokensBuffer.setLength(0);
                        bufferHasTokens = true;
                    }
                    buffer.append(this.lineSeparator);
                    this.column = 1;
                    this.printIndentationIfNecessary(buffer);
                    buffer.append(" * ");
                    this.column += BLOCK_LINE_PREFIX_LENGTH;
                    firstWord = true;
                    multiLines = true;
                    ++i;
                }
                boolean bl = insertSpace = insertSpace && linesGap == 0;
            }
            if (newLine) {
                lineHasTokens = false;
            }
            int tokenStart = this.scanner.getCurrentTokenStartPosition();
            int tokenLength = (this.scanner.atEnd() ? this.scanner.eofPosition : this.scanner.currentPosition) - tokenStart;
            hasTokens = true;
            if (!isTokenStar) {
                lineHasTokens = true;
            }
            if (hasTextOnFirstLine == 0 && !isTokenStar) {
                if (firstLine == lineNumber) {
                    hasTextOnFirstLine = 1;
                    ++this.column;
                } else {
                    hasTextOnFirstLine = -1;
                }
            }
            int lastColumn = this.column + tokensBuffer.length() + tokenLength;
            if (insertSpace) {
                ++lastColumn;
            }
            if (lineHasTokens && !firstWord && lastColumn > maxColumn) {
                String tokensString = tokensBuffer.toString().trim();
                if (hasTextOnFirstLine == 1) {
                    this.printBlockCommentHeaderLine(buffer);
                }
                if (this.indentationLevel + tokensString.length() + tokenLength > maxColumn) {
                    buffer.append(tokensString);
                    this.column += tokensString.length();
                    tokensBuffer.setLength(0);
                }
                if (bufferHasTokens) {
                    buffer.append(this.lineSeparator);
                    this.column = 1;
                    this.printIndentationIfNecessary(buffer);
                    buffer.append(" * ");
                    this.column += BLOCK_LINE_PREFIX_LENGTH;
                }
                if (tokensBuffer.length() > 0) {
                    buffer.append(tokensString);
                    this.column += tokensString.length();
                    tokensBuffer.setLength(0);
                }
                buffer.append(this.scanner.source, tokenStart, tokenLength);
                bufferHasTokens = true;
                this.column += tokenLength;
                multiLines = true;
                hasTextOnFirstLine = -1;
            } else {
                if (insertSpace) {
                    tokensBuffer.append(' ');
                }
                tokensBuffer.append(this.scanner.source, tokenStart, tokenLength);
            }
            previousToken = token;
            newLine = false;
            firstWord = false;
            scannerLine = lineNumber;
            lastTextLine = lineNumber;
        }
        if (hasTokens || multiLines) {
            StringBuffer replacement = new StringBuffer();
            if (hasTextOnFirstLine == 1) {
                if (hasMultiLines || multiLines) {
                    int col = this.column;
                    replacement.append(this.lineSeparator);
                    this.column = 1;
                    this.printIndentationIfNecessary(replacement);
                    replacement.append(" * ");
                    this.column = col;
                } else {
                    replacement.append(' ');
                }
            }
            replacement.append(buffer);
            this.addReplaceEdit(editStart, editEnd, replacement.toString());
        }
        this.indentationLevel = indentLevel;
        this.numberOfIndentations = indentations;
        this.lastNumberOfNewLines = 0;
        this.needSpace = false;
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
        this.scanner.skipComments = false;
        return true;
    }

    private void printBlockCommentHeaderLine(StringBuffer buffer) {
        if (buffer.length() == 0) {
            buffer.append(this.lineSeparator);
            this.column = 1;
            this.printIndentationIfNecessary(buffer);
            buffer.append(" * ");
            this.column += BLOCK_LINE_PREFIX_LENGTH;
        } else {
            StringBuffer insert = new StringBuffer();
            insert.append(this.lineSeparator);
            this.column = 1;
            this.printIndentationIfNecessary(insert);
            insert.append(" * ");
            this.column += BLOCK_LINE_PREFIX_LENGTH;
            buffer.insert(0, insert.toString());
        }
    }

    public void printEndOfCompilationUnit() {
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasComment = false;
            boolean hasLineComment = false;
            boolean hasWhitespace = false;
            int count = 0;
            block14: while (true) {
                this.currentToken = this.scanner.getNextToken();
                switch (this.currentToken) {
                    case 1000: {
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        count = 0;
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (count == 0) {
                            hasWhitespace = true;
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasLineComment) {
                            this.preserveEmptyLines(count, this.scanner.getCurrentTokenStartPosition());
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasComment) {
                            if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            } else {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            }
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else {
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        }
                        currentTokenStartPosition = this.scanner.currentPosition;
                        continue block14;
                    }
                    case 1001: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printLineComment();
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        count = 0;
                        continue block14;
                    }
                    case 1002: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printBlockComment(false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        continue block14;
                    }
                    case 1003: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.startPosition);
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.startPosition);
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        if (this.includesJavadocComments()) {
                            this.printJavadocComment(this.scanner.startPosition, this.scanner.currentPosition);
                        } else {
                            this.printBlockComment(true);
                        }
                        this.printNewLine();
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        continue block14;
                    }
                    case 27: {
                        this.print(this.scanner.currentPosition - this.scanner.startPosition, this.formatter.preferences.insert_space_before_semicolon);
                        continue block14;
                    }
                    case 68: {
                        if (count >= 1 || this.formatter.preferences.insert_new_line_at_end_of_file_if_missing) {
                            this.printNewLine(this.scannerEndPosition);
                        }
                        return;
                    }
                }
                break;
            }
            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
            return;
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    private void printCodeSnippet(int startPosition, int endPosition) {
        String convertedSnippet;
        String snippet = new String(this.scanner.source, startPosition, endPosition - startPosition + 1);
        DefaultLineTracker tracker = new DefaultLineTracker();
        String contentPrefix = "*";
        StringBuffer inputBuffer = new StringBuffer();
        inputBuffer.setLength(0);
        inputBuffer.append(snippet);
        tracker.set(snippet);
        int lines = tracker.getNumberOfLines() - 1;
        while (lines > 0) {
            int lineOffset;
            try {
                lineOffset = tracker.getLineOffset(lines);
            }
            catch (BadLocationException e) {
                CommentFormatterUtil.log(e);
                return;
            }
            int prefixOffset = inputBuffer.indexOf(contentPrefix, lineOffset);
            if (prefixOffset >= 0 && inputBuffer.substring(lineOffset, prefixOffset).trim().length() == 0) {
                inputBuffer.delete(lineOffset, prefixOffset + 1 + 1);
            }
            --lines;
        }
        HTMLEntity2JavaReader reader = new HTMLEntity2JavaReader(new StringReader(inputBuffer.toString()));
        char[] buf = new char[snippet.length()];
        try {
            int read = reader.read(buf);
            convertedSnippet = new String(buf, 0, read);
        }
        catch (IOException e) {
            CommentFormatterUtil.log(e);
            return;
        }
        String formattedSnippet = convertedSnippet;
        TextEdit edit = CommentFormatterUtil.format2(4096, convertedSnippet, 0, this.lineSeparator, this.formatter.preferences.getMap());
        if (edit != null) {
            formattedSnippet = CommentFormatterUtil.evaluateFormatterEdit(convertedSnippet, edit, null);
        }
        StringBuffer outputBuffer = new StringBuffer();
        tracker = new DefaultLineTracker();
        this.column = 1;
        this.printIndentationIfNecessary(outputBuffer);
        outputBuffer.append(" * ");
        String linePrefix = outputBuffer.toString();
        outputBuffer.setLength(0);
        Java2HTMLEntityReader javaReader = new Java2HTMLEntityReader(new StringReader(formattedSnippet));
        buf = new char[256];
        StringBuffer conversionBuffer = new StringBuffer();
        try {
            int l;
            do {
                if ((l = javaReader.read(buf)) == -1) continue;
                conversionBuffer.append(buf, 0, l);
            } while (l > 0);
            formattedSnippet = conversionBuffer.toString();
        }
        catch (IOException e) {
            CommentFormatterUtil.log(e);
            return;
        }
        outputBuffer.append(formattedSnippet);
        tracker.set(outputBuffer.toString());
        int lines2 = tracker.getNumberOfLines() - 1;
        while (lines2 > 0) {
            try {
                outputBuffer.insert(tracker.getLineOffset(lines2), linePrefix);
            }
            catch (BadLocationException e) {
                CommentFormatterUtil.log(e);
                return;
            }
            --lines2;
        }
        this.addReplaceEdit(startPosition, endPosition, outputBuffer.toString());
    }

    void printComment() {
        this.printComment(0);
    }

    void printComment(int kind) {
        boolean rejectLineComment = kind == 32 || kind == 64;
        boolean rejectBlockComment = kind == 16 || kind == 64;
        boolean rejectJavadocComment = kind == 16 || kind == 32;
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasComment = false;
            boolean hasLineComment = false;
            boolean hasWhitespace = false;
            int count = 0;
            block12: while ((this.currentToken = this.scanner.getNextToken()) != 68) {
                switch (this.currentToken) {
                    case 1000: {
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        count = 0;
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (count == 0) {
                            hasWhitespace = true;
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasLineComment) {
                            this.preserveEmptyLines(count, this.scanner.getCurrentTokenStartPosition());
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasComment) {
                            if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            } else {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            }
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (!(count == 0 || this.formatter.preferences.join_wrapped_lines && this.formatter.preferences.number_of_empty_lines_to_preserve == 0)) {
                            this.addReplaceEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition(), this.getPreserveEmptyLines(count - 1));
                        } else {
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        }
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1001: {
                        if (rejectLineComment) continue block12;
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printLineComment();
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        count = 0;
                        break;
                    }
                    case 1002: {
                        if (rejectBlockComment) continue block12;
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printBlockComment(false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        break;
                    }
                    case 1003: {
                        if (rejectJavadocComment) continue block12;
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        if (this.includesJavadocComments()) {
                            this.printJavadocComment(this.scanner.startPosition, this.scanner.currentPosition);
                        } else {
                            this.printBlockComment(true);
                        }
                        this.printNewLine();
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    void printComment(int kind, String source, int start, int end, int level) {
        this.initializeScanner(source.toCharArray());
        this.scanner.resetTo(start, end);
        this.numberOfIndentations = level;
        this.indentationLevel = level * this.indentationSize;
        this.column = this.indentationLevel + 1;
        switch (kind) {
            case 16: {
                this.printComment(kind);
                break;
            }
            case 32: {
                this.printComment(kind);
                break;
            }
            case 64: {
                this.printJavadocComment(start, end);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void printLineComment() {
        block16: {
            currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
            currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
            includesLineComments = this.includesLineComments();
            isNlsTag = false;
            if (CharOperation.indexOf(Scanner.TAG_PREFIX, this.scanner.source, true, currentTokenStartPosition, currentTokenEndPosition) != -1) {
                this.nlsTagCounter = 0;
                isNlsTag = true;
            }
            this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
            start = currentTokenStartPosition;
            nextCharacterStart = currentTokenStartPosition;
            if (!(this.indentationLevel == 0 || this.formatter.preferences.never_indent_line_comments_on_first_column && this.isOnFirstColumn(start))) {
                this.printIndentationIfNecessary();
            }
            if (this.pendingSpace) {
                this.addInsertEdit(currentTokenStartPosition, " ");
            }
            this.needSpace = false;
            this.pendingSpace = false;
            previousStart = currentTokenStartPosition;
            if (isNlsTag || !includesLineComments) ** GOTO lbl31
            this.printLineComment(currentTokenStartPosition, currentTokenEndPosition - 1);
            break block16;
lbl-1000:
            // 1 sources

            {
                nextCharacterStart = this.scanner.currentPosition;
                switch (currentCharacter) {
                    case 13: {
                        start = previousStart;
                        break block4;
                    }
                    case 10: {
                        start = previousStart;
                        break block4;
                    }
                    default: {
                        previousStart = nextCharacterStart;
                    }
                }
lbl31:
                // 2 sources

                ** while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1)
            }
lbl32:
            // 3 sources

            if (start != currentTokenStartPosition) {
                this.addReplaceEdit(start, currentTokenEndPosition - 1, this.lineSeparator);
                ++this.line;
                this.column = 1;
                this.lastNumberOfNewLines = 1;
            }
        }
        this.needSpace = false;
        this.pendingSpace = false;
        if (this.currentAlignment != null) {
            if (this.memberAlignment != null) {
                if (this.currentAlignment.location.inputOffset > this.memberAlignment.location.inputOffset) {
                    if (this.currentAlignment.couldBreak() && this.currentAlignment.wasSplit) {
                        this.currentAlignment.performFragmentEffect();
                    }
                } else {
                    this.indentationLevel = Math.max(this.indentationLevel, this.memberAlignment.breakIndentationLevel);
                }
            } else if (this.currentAlignment.couldBreak() && this.currentAlignment.wasSplit) {
                this.currentAlignment.performFragmentEffect();
            }
        }
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
    }

    /*
     * Unable to fully structure code
     */
    private void printLineComment(int commentStart, int commentEnd) {
        firstColumn = this.column;
        indentLevel = this.indentationLevel;
        indentations = this.numberOfIndentations;
        this.indentationLevel = this.getNextIndentationLevel(firstColumn);
        this.numberOfIndentations = this.indentationLevel / this.indentationSize;
        this.scanner.resetTo(commentStart, commentEnd);
        this.scanner.getNextChar();
        this.scanner.getNextChar();
        this.column += 2;
        maxColumn = this.formatter.preferences.comment_line_length + 1;
        previousToken = -1;
        lastTokenEndPosition = commentStart;
        spaceStartPosition = -1;
        spaceEndPosition = -1;
        this.scanner.skipComments = true;
        newLineString = null;
        this.commentIndentation = null;
        while (!this.scanner.atEnd()) {
            try {
                token = this.scanner.getNextToken();
            }
            catch (InvalidInputException v0) {
                token = this.consumeInvalidToken(commentEnd);
            }
            switch (token) {
                case 1000: {
                    previousToken = previousToken == -1 ? -2 : token;
                    spaceStartPosition = this.scanner.getCurrentTokenStartPosition();
                    spaceEndPosition = this.scanner.getCurrentTokenEndPosition();
                    break;
                }
                case 68: {
                    break;
                }
                case 26: {
                    if (previousToken != -1 && previousToken != -2) ** GOTO lbl53
                    identifier = this.scanner.getCurrentTokenSource();
                    startPosition = this.scanner.getCurrentTokenStartPosition();
                    restartPosition = this.scanner.currentPosition;
                    if (!CharOperation.equals(identifier, Parser.FALL_THROUGH_TAG, 0, 5) || this.scanner.currentCharacter != '-') ** GOTO lbl51
                    try {
                        this.scanner.getNextToken();
                        token = this.scanner.getNextToken();
                        if (token != 26 || !CharOperation.endsWith(Parser.FALL_THROUGH_TAG, identifier = this.scanner.getCurrentTokenSource())) ** GOTO lbl51
                        if (previousToken == -2) {
                            this.addReplaceEdit(spaceStartPosition, startPosition - 1, " ");
                        }
                        this.scanner.startPosition = startPosition;
                        previousToken = token;
                        ** GOTO lbl53
                    }
                    catch (InvalidInputException v1) {}
lbl51:
                    // 3 sources

                    this.scanner.startPosition = startPosition;
                    this.scanner.currentPosition = restartPosition;
                }
lbl53:
                // 4 sources

                default: {
                    tokenStart = this.scanner.getCurrentTokenStartPosition();
                    tokenLength = (this.scanner.atEnd() != false ? this.scanner.eofPosition : this.scanner.currentPosition) - tokenStart;
                    if (previousToken == -1) {
                        this.addInsertEdit(this.scanner.startPosition, " ");
                        ++this.column;
                    } else if (previousToken == -2) {
                        this.addReplaceEdit(spaceStartPosition, this.scanner.startPosition - 1, " ");
                        ++this.column;
                        spaceStartPosition = -1;
                    } else {
                        v2 = insertSpace = previousToken == 1000;
                        if (insertSpace) {
                            ++tokenLength;
                        }
                        if (spaceStartPosition > 0 && this.column + tokenLength > maxColumn) {
                            ++this.lastNumberOfNewLines;
                            ++this.line;
                            if (newLineString == null) {
                                newLineBuffer = new StringBuffer(this.lineSeparator);
                                this.column = 1;
                                this.printIndentationIfNecessary(newLineBuffer);
                                newLineBuffer.append("// ");
                                this.column += Scribe.LINE_COMMENT_PREFIX_LENGTH;
                                newLineString = newLineBuffer.toString();
                                firstColumn = this.column;
                            } else {
                                this.column = firstColumn;
                            }
                            if (lastTokenEndPosition > spaceEndPosition) {
                                this.column += lastTokenEndPosition - (spaceEndPosition + 1);
                            }
                            if (this.edits[this.editsIndex - 1].offset == spaceStartPosition) {
                                --this.editsIndex;
                            }
                            this.addReplaceEdit(spaceStartPosition, spaceEndPosition, newLineString);
                            spaceStartPosition = -1;
                            if (insertSpace) {
                                --tokenLength;
                            }
                        } else if (insertSpace) {
                            this.addReplaceEdit(spaceStartPosition, this.scanner.startPosition - 1, " ");
                        }
                    }
                    this.column += tokenLength;
                    previousToken = token;
                    lastTokenEndPosition = this.scanner.currentPosition;
                }
            }
        }
        this.scanner.skipComments = false;
        this.indentationLevel = indentLevel;
        this.numberOfIndentations = indentations;
        this.lastNumberOfNewLines = 0;
        this.scanner.resetTo(lastTokenEndPosition, commentEnd);
        while (!this.scanner.atEnd()) {
            spaceEndPosition = this.scanner.currentPosition;
            this.scanner.getNextChar();
            if (this.scanner.currentCharacter != '\n' && this.scanner.currentCharacter != '\r') continue;
            this.column = 1;
            ++this.line;
            ++this.lastNumberOfNewLines;
            break;
        }
        if (previousToken != -1 && lastTokenEndPosition != commentStart && spaceEndPosition > lastTokenEndPosition) {
            this.addDeleteEdit(lastTokenEndPosition, spaceEndPosition - 1);
        }
    }

    public void printEmptyLines(int linesNumber) {
        this.printEmptyLines(linesNumber, this.scanner.getCurrentTokenEndPosition() + 1);
    }

    private void printEmptyLines(int linesNumber, int insertPosition) {
        String buffer = this.getEmptyLines(linesNumber);
        if (Util.EMPTY_STRING == buffer) {
            return;
        }
        this.addInsertEdit(insertPosition, buffer);
    }

    void printIndentationIfNecessary() {
        StringBuffer buffer = new StringBuffer();
        this.printIndentationIfNecessary(buffer);
        if (buffer.length() > 0) {
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), buffer.toString());
            this.pendingSpace = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void printIndentationIfNecessary(StringBuffer buffer) {
        switch (this.tabChar) {
            case 1: {
                useTabsForLeadingIndents = this.useTabsOnlyForLeadingIndents;
                numberOfLeadingIndents = this.numberOfIndentations;
                indentationsAsTab = 0;
                if (!useTabsForLeadingIndents) ** GOTO lbl30
                while (this.column <= this.indentationLevel) {
                    if (indentationsAsTab < numberOfLeadingIndents) {
                        if (buffer != null) {
                            buffer.append('\t');
                        }
                        ++indentationsAsTab;
                        complement = this.tabLength - (this.column - 1) % this.tabLength;
                        this.column += complement;
                        this.needSpace = false;
                        continue;
                    }
                    if (buffer != null) {
                        buffer.append(' ');
                    }
                    ++this.column;
                    this.needSpace = false;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    if (buffer != null) {
                        buffer.append('\t');
                    }
                    complement = this.tabLength - (this.column - 1) % this.tabLength;
                    this.column += complement;
                    this.needSpace = false;
lbl30:
                    // 2 sources

                    ** while (this.column <= this.indentationLevel)
                }
lbl31:
                // 1 sources

                break;
            }
            case 2: {
                while (this.column <= this.indentationLevel) {
                    if (buffer != null) {
                        buffer.append(' ');
                    }
                    ++this.column;
                    this.needSpace = false;
                }
                break;
            }
            case 4: {
                useTabsForLeadingIndents = this.useTabsOnlyForLeadingIndents;
                numberOfLeadingIndents = this.numberOfIndentations;
                indentationsAsTab = false;
                if (!useTabsForLeadingIndents) ** GOTO lbl105
                columnForLeadingIndents = numberOfLeadingIndents * this.indentationSize;
                while (this.column <= this.indentationLevel) {
                    if (this.column <= columnForLeadingIndents) {
                        if (this.column - 1 + this.tabLength <= this.indentationLevel) {
                            if (buffer != null) {
                                buffer.append('\t');
                            }
                            this.column += this.tabLength;
                        } else if (this.column - 1 + this.indentationSize <= this.indentationLevel) {
                            i = 0;
                            max = this.indentationSize;
                            while (i < max) {
                                if (buffer != null) {
                                    buffer.append(' ');
                                }
                                ++this.column;
                                ++i;
                            }
                        } else {
                            if (buffer != null) {
                                buffer.append(' ');
                            }
                            ++this.column;
                        }
                    } else {
                        i = this.column;
                        max = this.indentationLevel;
                        while (i <= max) {
                            if (buffer != null) {
                                buffer.append(' ');
                            }
                            ++this.column;
                            ++i;
                        }
                    }
                    this.needSpace = false;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    if (this.column - 1 + this.tabLength <= this.indentationLevel) {
                        if (buffer != null) {
                            buffer.append('\t');
                        }
                        this.column += this.tabLength;
                    } else if (this.column - 1 + this.indentationSize <= this.indentationLevel) {
                        i = 0;
                        max = this.indentationSize;
                        while (i < max) {
                            if (buffer != null) {
                                buffer.append(' ');
                            }
                            ++this.column;
                            ++i;
                        }
                    } else {
                        if (buffer != null) {
                            buffer.append(' ');
                        }
                        ++this.column;
                    }
                    this.needSpace = false;
lbl105:
                    // 2 sources

                    ** while (this.column <= this.indentationLevel)
                }
            }
        }
lbl106:
        // 6 sources

    }

    private void printJavadocBlock(FormatJavadocBlock block) {
        if (block == null) {
            return;
        }
        int previousEnd = block.tagEnd;
        int maxNodes = block.nodesPtr;
        boolean headerLine = block.isHeaderLine() && this.lastNumberOfNewLines == 0;
        int maxColumn = this.formatter.preferences.comment_line_length + 1;
        if (headerLine) {
            ++maxColumn;
        }
        if (!block.isInlined()) {
            this.lastNumberOfNewLines = 0;
        }
        if (block.isDescription()) {
            if (!block.isInlined()) {
                this.commentIndentation = null;
            }
        } else {
            FormatJavadocReference reference;
            int tagLength = previousEnd - block.sourceStart + 1;
            this.column += tagLength;
            if (!block.isInlined()) {
                boolean indentRootTags = this.formatter.preferences.comment_indent_root_tags && !block.isInDescription();
                int commentIndentationLevel = 0;
                if (indentRootTags) {
                    boolean indentParamTag;
                    commentIndentationLevel = tagLength + 1;
                    boolean bl = indentParamTag = this.formatter.preferences.comment_indent_parameter_description && block.isInParamTag();
                    if (indentParamTag) {
                        commentIndentationLevel += this.indentationSize;
                    }
                }
                if (commentIndentationLevel == 0) {
                    this.commentIndentation = null;
                } else {
                    StringBuffer indentationBuffer = new StringBuffer();
                    int i = 0;
                    while (i < commentIndentationLevel) {
                        indentationBuffer.append(' ');
                        ++i;
                    }
                    this.commentIndentation = indentationBuffer.toString();
                }
            }
            if ((reference = block.reference) != null) {
                this.printJavadocBlockReference(block, reference);
                previousEnd = reference.sourceEnd;
            }
            if (maxNodes < 0) {
                if (block.isInlined()) {
                    ++this.column;
                }
                return;
            }
        }
        int previousLine = Util.getLineNumber(previousEnd, this.lineEnds, 0, this.maxLines);
        boolean clearBlankLines = this.formatter.preferences.comment_clear_blank_lines_in_javadoc_comment;
        boolean joinLines = this.formatter.preferences.join_lines_in_comments;
        int i = 0;
        while (i <= maxNodes) {
            int newLines;
            FormatJavadocNode node = block.nodes[i];
            int nodeStart = node.sourceStart;
            if (i == 0) {
                int n = newLines = this.formatter.preferences.comment_insert_new_line_for_parameter && block.isParamTag() ? 1 : 0;
                if (nodeStart > previousEnd + 1) {
                    if (!clearBlankLines || !joinLines) {
                        int startLine = Util.getLineNumber(nodeStart, this.lineEnds, previousLine - 1, this.maxLines);
                        int gapLine = previousLine;
                        if (joinLines) {
                            ++gapLine;
                        }
                        if (startLine > gapLine) {
                            newLines = startLine - previousLine;
                        }
                        if (clearBlankLines && newLines > 0) {
                            newLines = 1;
                        }
                    }
                    if (newLines == 0) {
                        newLines = this.printJavadocBlockNodesNewLines(block, node, previousEnd);
                    }
                    this.printJavadocGapLines(previousEnd + 1, nodeStart - 1, newLines, clearBlankLines, false, null);
                } else {
                    StringBuffer buffer = new StringBuffer();
                    if (newLines > 0) {
                        int j = 0;
                        while (j < newLines) {
                            this.printJavadocNewLine(buffer);
                            ++j;
                        }
                        this.addInsertEdit(nodeStart, buffer.toString());
                    }
                }
            } else {
                int n = newLines = this.column > maxColumn ? 1 : 0;
                if (!clearBlankLines && node.lineStart > previousLine + 1) {
                    newLines = node.lineStart - previousLine;
                }
                if (newLines < node.linesBefore) {
                    newLines = node.linesBefore;
                }
                if (newLines == 0) {
                    newLines = this.printJavadocBlockNodesNewLines(block, node, previousEnd);
                }
                if (newLines > 0 || nodeStart > previousEnd + 1) {
                    this.printJavadocGapLines(previousEnd + 1, nodeStart - 1, newLines, clearBlankLines, false, null);
                }
            }
            if (headerLine && newLines > 0) {
                headerLine = false;
                --maxColumn;
            }
            if (node.isText()) {
                FormatJavadocText text = (FormatJavadocText)node;
                if (text.isHtmlTag()) {
                    if (text.isImmutableHtmlTag()) {
                        if (newLines > 0 && this.commentIndentation != null) {
                            this.addInsertEdit(node.sourceStart, this.commentIndentation);
                            this.column += this.commentIndentation.length();
                        }
                        this.printJavadocHtmlImmutableTag(text, block, newLines > 0);
                        this.column += this.getTextLength(block, text);
                    } else {
                        this.printJavadocHtmlTag(text, block, newLines > 0);
                    }
                } else {
                    this.printJavadocText(text, block, newLines > 0);
                }
            } else {
                if (newLines > 0 && this.commentIndentation != null) {
                    this.addInsertEdit(node.sourceStart, this.commentIndentation);
                    this.column += this.commentIndentation.length();
                }
                this.printJavadocBlock((FormatJavadocBlock)node);
            }
            previousEnd = node.sourceEnd;
            previousLine = Util.getLineNumber(previousEnd, this.lineEnds, node.lineStart > 1 ? node.lineStart - 2 : 0, this.maxLines);
            ++i;
        }
        this.lastNumberOfNewLines = 0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int printJavadocBlockNodesNewLines(FormatJavadocBlock block, FormatJavadocNode node, int previousEnd) {
        block31: {
            int maxColumn = this.formatter.preferences.comment_line_length + 1;
            int nodeStart = node.sourceStart;
            try {
                this.scanner.resetTo(nodeStart, node.sourceEnd);
                int length = 0;
                int newLines = 0;
                boolean newLine = false;
                boolean headerLine = block.isHeaderLine() && this.lastNumberOfNewLines == 0;
                int firstColumn = 1 + this.indentationLevel + BLOCK_LINE_PREFIX_LENGTH;
                if (this.commentIndentation != null) {
                    firstColumn += this.commentIndentation.length();
                }
                if (headerLine) {
                    ++maxColumn;
                }
                if (node.isText()) {
                    FormatJavadocText text = (FormatJavadocText)node;
                    if (text.isImmutableHtmlTag()) {
                        if (nodeStart > previousEnd + 1) {
                            ++length;
                        }
                        int lastColumn = this.column + length;
                        block10: while (!this.scanner.atEnd()) {
                            int token = this.scanner.getNextToken();
                            switch (token) {
                                case 1000: {
                                    if (CharOperation.indexOf('\n', this.scanner.source, this.scanner.startPosition, this.scanner.currentPosition) >= 0) {
                                        return newLines;
                                    }
                                    length = 1;
                                    break;
                                }
                                case 4: {
                                    if (newLine) {
                                        newLine = false;
                                        continue block10;
                                    }
                                    length = 1;
                                    break;
                                }
                                default: {
                                    length = (this.scanner.atEnd() ? this.scanner.eofPosition : this.scanner.currentPosition) - this.scanner.startPosition;
                                }
                            }
                            if ((lastColumn += length) <= maxColumn) continue;
                            ++newLines;
                            if (headerLine) {
                                --maxColumn;
                                headerLine = false;
                            }
                            lastColumn = firstColumn;
                        }
                        return newLines;
                    }
                    if (text.isHtmlTag()) {
                        if (text.getHtmlTagID() == 256) {
                            return 0;
                        }
                        this.scanner.getNextToken();
                        if (this.scanner.getNextToken() == 6) {
                            ++length;
                            this.scanner.getNextToken();
                        }
                        length += (this.scanner.atEnd() ? this.scanner.eofPosition : this.scanner.currentPosition) - this.scanner.startPosition;
                        this.scanner.getNextToken();
                        ++length;
                    } else {
                        int tokenLength;
                        int token;
                        while ((token = this.scanner.getNextToken()) != 1000 && token != 68 && this.column + (length += (tokenLength = (this.scanner.atEnd() ? this.scanner.eofPosition : this.scanner.currentPosition) - this.scanner.startPosition)) < maxColumn) {
                        }
                    }
                } else {
                    FormatJavadocBlock inlinedBlock = (FormatJavadocBlock)node;
                    length += inlinedBlock.tagEnd - inlinedBlock.sourceStart + 1;
                    if (inlinedBlock.reference != null) {
                        ++length;
                        this.scanner.resetTo(inlinedBlock.reference.sourceStart, inlinedBlock.reference.sourceEnd);
                        int previousToken = -1;
                        block12: while (!this.scanner.atEnd()) {
                            int token = this.scanner.getNextToken();
                            int tokenLength = (this.scanner.atEnd() ? this.scanner.eofPosition : this.scanner.currentPosition) - this.scanner.startPosition;
                            switch (token) {
                                case 1000: {
                                    if (previousToken != 30) break;
                                    ++length;
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                                default: {
                                    if (this.column + (length += tokenLength) > maxColumn) break block12;
                                }
                            }
                            previousToken = token;
                        }
                    }
                    ++length;
                }
                if (nodeStart > previousEnd + 1) {
                    ++length;
                }
                if (firstColumn + length >= maxColumn && node == block.nodes[0]) {
                    return 0;
                }
                if (this.column + length > maxColumn) {
                    return 1;
                }
            }
            catch (InvalidInputException invalidInputException) {
                int tokenLength = 1;
                if (nodeStart > previousEnd + 1) {
                    ++tokenLength;
                }
                if (this.column + tokenLength <= maxColumn) break block31;
                return 1;
            }
        }
        return 0;
    }

    private void printJavadocBlockReference(FormatJavadocBlock block, FormatJavadocReference reference) {
        int maxColumn = this.formatter.preferences.comment_line_length + 1;
        boolean headerLine = block.isHeaderLine();
        boolean inlined = block.isInlined();
        if (headerLine) {
            ++maxColumn;
        }
        this.scanner.resetTo(block.tagEnd + 1, reference.sourceEnd);
        StringBuffer buffer = new StringBuffer();
        boolean needFormat = false;
        int previousToken = -1;
        int spacePosition = -1;
        String newLineString = null;
        int firstColumn = -1;
        while (!this.scanner.atEnd()) {
            try {
                int token = this.scanner.getNextToken();
                int tokenLength = (this.scanner.atEnd() ? this.scanner.eofPosition : this.scanner.currentPosition) - this.scanner.startPosition;
                block1 : switch (token) {
                    case 1000: {
                        if (previousToken != -1 || tokenLength > 1 || this.scanner.currentCharacter != ' ') {
                            needFormat = true;
                        }
                        switch (previousToken) {
                            case 4: 
                            case 28: {
                                break block1;
                            }
                            default: {
                                spacePosition = buffer.length();
                            }
                            case -1: 
                        }
                        buffer.append(' ');
                        ++this.column;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        if (!inlined && spacePosition > 0 && this.column + tokenLength > maxColumn) {
                            ++this.lastNumberOfNewLines;
                            ++this.line;
                            if (newLineString == null) {
                                StringBuffer newLineBuffer = new StringBuffer(this.lineSeparator);
                                this.column = 1;
                                this.printIndentationIfNecessary(newLineBuffer);
                                newLineBuffer.append(" * ");
                                this.column += BLOCK_LINE_PREFIX_LENGTH;
                                if (this.commentIndentation != null) {
                                    newLineBuffer.append(this.commentIndentation);
                                    this.column += this.commentIndentation.length();
                                }
                                newLineString = newLineBuffer.substring(0, newLineBuffer.length() - 1);
                                firstColumn = this.column;
                            } else {
                                this.column = firstColumn;
                            }
                            this.column = firstColumn + buffer.length() - spacePosition - 1;
                            buffer.insert(spacePosition, newLineString);
                            if (headerLine) {
                                headerLine = false;
                                --maxColumn;
                            }
                            spacePosition = -1;
                        }
                        buffer.append(this.scanner.source, this.scanner.startPosition, tokenLength);
                        this.column += tokenLength;
                    }
                }
                previousToken = token;
            }
            catch (InvalidInputException invalidInputException) {}
        }
        if (needFormat) {
            this.addReplaceEdit(block.tagEnd + 1, reference.sourceEnd, buffer.toString());
        }
    }

    private int getTextLength(FormatJavadocBlock block, FormatJavadocText text) {
        int startLine;
        if (text.isImmutableHtmlTag()) {
            this.scanner.resetTo(text.sourceStart, text.sourceEnd);
            int textLength = 0;
            while (!this.scanner.atEnd()) {
                try {
                    int token = this.scanner.getNextToken();
                    if (token == 1000 && CharOperation.indexOf('\n', this.scanner.source, this.scanner.startPosition, this.scanner.currentPosition) >= 0) {
                        textLength = 0;
                        this.scanner.getNextChar();
                        if (this.scanner.currentCharacter == '*') {
                            this.scanner.getNextChar();
                            if (this.scanner.currentCharacter == ' ') continue;
                            ++textLength;
                            continue;
                        }
                        ++textLength;
                        continue;
                    }
                    textLength += (this.scanner.atEnd() ? this.scanner.eofPosition : this.scanner.currentPosition) - this.scanner.startPosition;
                }
                catch (InvalidInputException invalidInputException) {
                    return textLength;
                }
            }
            return textLength;
        }
        if (block.isOneLineTag()) {
            return text.sourceEnd - text.sourceStart + 1;
        }
        int endLine = startLine = Util.getLineNumber(text.sourceStart, this.lineEnds, 0, this.maxLines);
        int previousEnd = -1;
        int i = 0;
        while (i <= text.separatorsPtr) {
            int end = (int)(text.separators[i] >>> 32);
            if ((endLine = Util.getLineNumber(end, this.lineEnds, endLine - 1, this.maxLines)) > startLine) {
                return previousEnd - text.sourceStart + 1;
            }
            previousEnd = end;
            ++i;
        }
        return text.sourceEnd - text.sourceStart + 1;
    }

    void printJavadocComment(int start, int end) {
        int lastIndentationLevel = this.indentationLevel;
        try {
            this.scanner.resetTo(start, end - 1);
            if (!this.formatterCommentParser.parse(start, end - 1)) {
                return;
            }
            FormatJavadoc javadoc = (FormatJavadoc)this.formatterCommentParser.docComment;
            if (this.indentationLevel != 0) {
                this.printIndentationIfNecessary();
            }
            if (this.pendingSpace) {
                this.addInsertEdit(start, " ");
            }
            if (javadoc.blocks == null) {
                return;
            }
            this.needSpace = false;
            this.pendingSpace = false;
            int length = javadoc.blocks.length;
            FormatJavadocBlock previousBlock = javadoc.blocks[0];
            this.lastNumberOfNewLines = 0;
            int currentLine = this.line;
            int firstBlockStart = previousBlock.sourceStart;
            this.printIndentationIfNecessary(null);
            this.column += JAVADOC_HEADER_LENGTH;
            int index = 1;
            if (length > 1) {
                FormatJavadocBlock block;
                if (previousBlock.isDescription()) {
                    this.printJavadocBlock(previousBlock);
                    block = javadoc.blocks[index++];
                    int newLines = this.formatter.preferences.comment_insert_empty_line_before_root_tags ? 2 : 1;
                    this.printJavadocGapLines(previousBlock.sourceEnd + 1, block.sourceStart - 1, newLines, this.formatter.preferences.comment_clear_blank_lines_in_javadoc_comment, false, null);
                    previousBlock = block;
                }
                while (index < length) {
                    this.printJavadocBlock(previousBlock);
                    block = javadoc.blocks[index++];
                    this.printJavadocGapLines(previousBlock.sourceEnd + 1, block.sourceStart - 1, 1, this.formatter.preferences.comment_clear_blank_lines_in_javadoc_comment, false, null);
                    previousBlock = block;
                }
            }
            this.printJavadocBlock(previousBlock);
            int newLines = this.line > currentLine || javadoc.isMultiLine() ? 1 : 0;
            this.printJavadocGapLines(javadoc.textStart, firstBlockStart - 1, newLines, this.formatter.preferences.comment_clear_blank_lines_in_javadoc_comment, false, null);
            this.printJavadocGapLines(previousBlock.sourceEnd + 1, javadoc.textEnd, newLines, this.formatter.preferences.comment_clear_blank_lines_in_javadoc_comment, true, null);
        }
        finally {
            this.scanner.resetTo(end, this.scannerEndPosition - 1);
            this.needSpace = false;
            this.indentationLevel = lastIndentationLevel;
            this.lastNumberOfNewLines = 0;
        }
    }

    /*
     * Exception decompiling
     */
    private void printJavadocGapLines(int textStartPosition, int textEndPosition, int newLines, boolean clearBlankLines, boolean footer, StringBuffer output) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[SWITCH], 6[CASE]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void printJavadocHtmlImmutableTag(FormatJavadocText text, FormatJavadocBlock block, boolean textOnNewLine) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int printJavadocHtmlTag(FormatJavadocText text, FormatJavadocBlock block, boolean textOnNewLine) {
        boolean needIndentation;
        boolean closingTag;
        boolean isHtmlSeparatorTag;
        int textStart;
        boolean clearBlankLines = this.formatter.preferences.comment_clear_blank_lines_in_javadoc_comment;
        boolean headerLine = block.isHeaderLine() && this.lastNumberOfNewLines == 0;
        int firstColumn = 1 + this.indentationLevel + BLOCK_LINE_PREFIX_LENGTH;
        if (headerLine) {
            ++firstColumn;
        }
        int nextStart = textStart = text.sourceStart;
        int startLine = Util.getLineNumber(textStart, this.lineEnds, 0, this.maxLines);
        int htmlTagID = text.getHtmlTagID();
        StringBuffer buffer = new StringBuffer();
        int max = text.separatorsPtr;
        int linesAfter = 0;
        int previousEnd = -1;
        boolean isHtmlBreakTag = htmlTagID == 256;
        boolean bl = isHtmlSeparatorTag = htmlTagID == 4096;
        if (isHtmlBreakTag) {
            return 1;
        }
        boolean isCode = htmlTagID == 512;
        int idx = 0;
        int ptr = 0;
        while (idx <= max || text.htmlNodesPtr != -1 && ptr <= text.htmlNodesPtr) {
            int endLine;
            int linesGap;
            int end = idx > max ? text.sourceEnd : (int)(text.separators[idx] >>> 32);
            int nodeKind = 0;
            if (text.htmlNodesPtr >= 0 && ptr <= text.htmlNodesPtr && end > text.htmlNodes[ptr].sourceStart) {
                boolean immutable;
                int newLines;
                FormatJavadocNode node = text.htmlNodes[ptr];
                FormatJavadocText htmlTag = node.isText() ? (FormatJavadocText)node : null;
                int n = newLines = htmlTag == null ? 0 : htmlTag.linesBefore;
                if (linesAfter > newLines && (newLines = linesAfter) > 1 && clearBlankLines && (idx < 2 || (text.htmlIndexes[idx - 2] & 0xFF00) != 512)) {
                    newLines = 1;
                }
                if (textStart < previousEnd) {
                    this.addReplaceEdit(textStart, previousEnd, buffer.toString());
                }
                boolean bl2 = immutable = htmlTag == null ? false : htmlTag.isImmutableHtmlTag();
                if (newLines == 0) {
                    newLines = this.printJavadocBlockNodesNewLines(block, node, previousEnd);
                }
                int nodeStart = node.sourceStart;
                if (newLines > 0 || idx > 1 && nodeStart > previousEnd + 1) {
                    this.printJavadocGapLines(previousEnd + 1, nodeStart - 1, newLines, clearBlankLines, false, null);
                }
                if (newLines > 0) {
                    textOnNewLine = true;
                }
                buffer = new StringBuffer();
                if (node.isText()) {
                    if (immutable) {
                        if (textOnNewLine && this.commentIndentation != null) {
                            this.addInsertEdit(node.sourceStart, this.commentIndentation);
                            this.column += this.commentIndentation.length();
                        }
                        this.printJavadocHtmlImmutableTag(htmlTag, block, textOnNewLine);
                        this.column += this.getTextLength(block, htmlTag);
                        linesAfter = 0;
                    } else {
                        linesAfter = this.printJavadocHtmlTag(htmlTag, block, textOnNewLine);
                    }
                    nodeKind = 1;
                } else {
                    if (textOnNewLine && this.commentIndentation != null) {
                        this.addInsertEdit(node.sourceStart, this.commentIndentation);
                        this.column += this.commentIndentation.length();
                    }
                    this.printJavadocBlock((FormatJavadocBlock)node);
                    linesAfter = 0;
                    nodeKind = 2;
                }
                textStart = node.sourceEnd + 1;
                ++ptr;
                if (idx > max) {
                    return linesAfter;
                }
            } else {
                if (idx > 0 && linesAfter > 0) {
                    this.printJavadocGapLines(previousEnd + 1, nextStart, linesAfter, clearBlankLines, false, buffer);
                    textOnNewLine = true;
                }
                boolean needIndentation2 = textOnNewLine;
                if (idx > 0 && !needIndentation2 && text.isTextAfterHtmlSeparatorTag(idx - 1)) {
                    needIndentation2 = true;
                }
                this.needSpace = idx > 1 && previousEnd + 1 < nextStart;
                this.printJavadocTextLine(buffer, nextStart, end, block, idx == 0, needIndentation2, idx == 0 || text.htmlIndexes[idx - 1] != -1);
                linesAfter = 0;
                if (idx == 0) {
                    if (isHtmlSeparatorTag) {
                        linesAfter = 1;
                    }
                } else if (text.htmlIndexes[idx - 1] == 256) {
                    linesAfter = 1;
                }
            }
            if ((linesGap = (startLine = Util.getLineNumber(nextStart = (int)text.separators[idx], this.lineEnds, (endLine = Util.getLineNumber(end, this.lineEnds, startLine - 1, this.maxLines)) - 1, this.maxLines)) - endLine) > 0 && !clearBlankLines && (idx == 0 || linesGap > 1 || idx < max && nodeKind == 1 && (text.htmlIndexes[idx - 1] & 0xFF00) != 2048) && linesAfter < linesGap) {
                linesAfter = linesGap;
            }
            boolean bl3 = textOnNewLine = linesAfter > 0;
            if (isCode) {
                int codeEnd = (int)(text.separators[max] >>> 32);
                if (codeEnd > end) {
                    if (this.formatter.preferences.comment_format_source) {
                        int newLines;
                        block46: {
                            if (textStart < end) {
                                this.addReplaceEdit(textStart, end, buffer.toString());
                            }
                            this.scanner.resetTo(end + 1, nextStart - 1);
                            newLines = 0;
                            try {
                                int token = this.scanner.getNextToken();
                                while (true) {
                                    switch (token) {
                                        case 1000: {
                                            if (CharOperation.indexOf('\n', this.scanner.source, this.scanner.startPosition, this.scanner.currentPosition) >= 0) {
                                                ++newLines;
                                                break;
                                            }
                                            break block46;
                                        }
                                        case 4: {
                                            nextStart = this.scanner.currentPosition + 1;
                                            break;
                                        }
                                        default: {
                                            break block46;
                                        }
                                    }
                                    token = this.scanner.getNextToken();
                                }
                            }
                            catch (InvalidInputException invalidInputException) {}
                        }
                        if (newLines == 0) {
                            newLines = 1;
                        }
                        this.printJavadocGapLines(end + 1, nextStart - 1, newLines, false, false, null);
                        this.printCodeSnippet(nextStart, codeEnd);
                        nextStart = (int)text.separators[max];
                        this.printJavadocGapLines(codeEnd + 1, nextStart - 1, 1, false, false, null);
                        return 2;
                    }
                } else {
                    nextStart = (int)text.separators[max];
                    if (nextStart - 1 > end + 1) {
                        int line1 = Util.getLineNumber(end + 1, this.lineEnds, startLine - 1, this.maxLines);
                        int line2 = Util.getLineNumber(nextStart - 1, this.lineEnds, line1 - 1, this.maxLines);
                        int gapLines = line2 - line1 - 1;
                        this.printJavadocGapLines(end + 1, nextStart - 1, gapLines, false, false, null);
                        if (gapLines > 0) {
                            textOnNewLine = true;
                        }
                    }
                }
                return 1;
            }
            previousEnd = end;
            ++idx;
        }
        boolean bl4 = closingTag = isHtmlBreakTag || text.htmlIndexes != null && (text.htmlIndexes[max] & 0xFF00) == htmlTagID;
        if (previousEnd != -1) {
            if (max > 0 && isHtmlSeparatorTag && closingTag && linesAfter == 0) {
                linesAfter = 1;
            }
            if (linesAfter > 0) {
                this.printJavadocGapLines(previousEnd + 1, nextStart - 1, linesAfter, clearBlankLines, false, buffer);
                boolean bl5 = textOnNewLine = linesAfter > 0;
            }
        }
        if (!(needIndentation = textOnNewLine) && !isHtmlBreakTag && text.htmlIndexes != null && text.isTextAfterHtmlSeparatorTag(max)) {
            needIndentation = true;
        }
        this.needSpace = !closingTag && max > 0 && previousEnd + 1 < nextStart;
        this.printJavadocTextLine(buffer, nextStart, text.sourceEnd, block, max <= 0, needIndentation, closingTag);
        if (textStart < text.sourceEnd) {
            this.addReplaceEdit(textStart, text.sourceEnd, buffer.toString());
        }
        this.needSpace = false;
        this.scanner.resetTo(text.sourceEnd + 1, this.scannerEndPosition - 1);
        if (max > 0 && isHtmlSeparatorTag) {
            return 1;
        }
        return 0;
    }

    private void printJavadocNewLine(StringBuffer buffer) {
        buffer.append(this.lineSeparator);
        this.column = 1;
        this.printIndentationIfNecessary(buffer);
        buffer.append(" * ");
        this.column += BLOCK_LINE_PREFIX_LENGTH;
        ++this.line;
        ++this.lastNumberOfNewLines;
    }

    private void printJavadocText(FormatJavadocText text, FormatJavadocBlock block, boolean textOnNewLine) {
        int textStart;
        boolean clearBlankLines = this.formatter.preferences.comment_clear_blank_lines_in_javadoc_comment;
        boolean joinLines = this.formatter.preferences.join_lines_in_comments;
        StringBuffer buffer = new StringBuffer();
        int nextStart = textStart = text.sourceStart;
        int startLine = Util.getLineNumber(textStart, this.lineEnds, 0, this.maxLines);
        int idx = 0;
        int max = text.separatorsPtr;
        while (idx <= max) {
            int end = (int)(text.separators[idx] >>> 32);
            boolean needIndentation = textOnNewLine;
            if (idx > 0 && !needIndentation && text.isTextAfterHtmlSeparatorTag(idx - 1)) {
                needIndentation = true;
            }
            this.needSpace = idx > 0;
            this.printJavadocTextLine(buffer, nextStart, end, block, idx == 0, needIndentation, false);
            textOnNewLine = false;
            nextStart = (int)text.separators[idx];
            if (!clearBlankLines || !joinLines) {
                int endLine = Util.getLineNumber(end, this.lineEnds, startLine - 1, this.maxLines);
                startLine = Util.getLineNumber(nextStart, this.lineEnds, endLine - 1, this.maxLines);
                int gapLine = endLine;
                if (joinLines) {
                    ++gapLine;
                }
                if (startLine > gapLine) {
                    this.addReplaceEdit(textStart, end, buffer.toString());
                    textStart = nextStart;
                    buffer.setLength(0);
                    int newLines = startLine - endLine;
                    if (clearBlankLines) {
                        newLines = 1;
                    }
                    this.printJavadocGapLines(end + 1, nextStart - 1, newLines, this.formatter.preferences.comment_clear_blank_lines_in_javadoc_comment, false, null);
                    textOnNewLine = true;
                }
            }
            ++idx;
        }
        boolean needIndentation = textOnNewLine;
        this.needSpace = text.separatorsPtr >= 0;
        this.printJavadocTextLine(buffer, nextStart, text.sourceEnd, block, text.separatorsPtr == -1, needIndentation, false);
        this.addReplaceEdit(textStart, text.sourceEnd, buffer.toString());
        this.needSpace = false;
        this.scanner.resetTo(text.sourceEnd + 1, this.scannerEndPosition - 1);
    }

    private void printJavadocTextLine(StringBuffer buffer, int textStart, int textEnd, FormatJavadocBlock block, boolean firstText, boolean needIndentation, boolean isHtmlTag) {
        boolean headerLine = block.isHeaderLine() && this.lastNumberOfNewLines == 0;
        StringBuffer tokensBuffer = new StringBuffer();
        int firstColumn = 1 + this.indentationLevel + BLOCK_LINE_PREFIX_LENGTH;
        int maxColumn = this.formatter.preferences.comment_line_length + 1;
        if (headerLine) {
            ++firstColumn;
            ++maxColumn;
        }
        if (needIndentation && this.commentIndentation != null) {
            buffer.append(this.commentIndentation);
            this.column += this.commentIndentation.length();
        }
        if (this.column < firstColumn) {
            this.column = firstColumn;
        }
        String newLineString = null;
        try {
            this.scanner.resetTo(textStart, textEnd);
            this.scanner.skipComments = true;
            int previousToken = -1;
            boolean textOnNewLine = needIndentation;
            block9: while (!this.scanner.atEnd()) {
                int token;
                try {
                    token = this.scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {
                    token = this.consumeInvalidToken(textEnd);
                }
                int tokensBufferLength = tokensBuffer.length();
                int tokenStart = this.scanner.getCurrentTokenStartPosition();
                int tokenLength = (this.scanner.atEnd() ? this.scanner.eofPosition : this.scanner.currentPosition) - tokenStart;
                boolean insertSpace = (previousToken == 1000 || this.needSpace) && !textOnNewLine;
                String tokensBufferString = tokensBuffer.toString().trim();
                switch (token) {
                    case 1000: {
                        if (tokensBufferLength > 0) {
                            boolean shouldSplit;
                            boolean bl = shouldSplit = this.column + tokensBufferLength > maxColumn && !isHtmlTag && (insertSpace || tokensBufferLength > 1) && tokensBufferString.charAt(0) != '@';
                            if (shouldSplit) {
                                ++this.lastNumberOfNewLines;
                                ++this.line;
                                if (newLineString == null) {
                                    StringBuffer newLineBuffer = new StringBuffer(this.lineSeparator);
                                    this.column = 1;
                                    this.printIndentationIfNecessary(newLineBuffer);
                                    newLineBuffer.append(" * ");
                                    this.column += BLOCK_LINE_PREFIX_LENGTH;
                                    if (this.commentIndentation != null) {
                                        newLineBuffer.append(this.commentIndentation);
                                        this.column += this.commentIndentation.length();
                                    }
                                    firstColumn = this.column;
                                    newLineString = newLineBuffer.toString();
                                } else {
                                    this.column = firstColumn;
                                }
                                buffer.append(newLineString);
                                buffer.append(tokensBufferString);
                                this.column += tokensBufferString.length();
                                if (headerLine) {
                                    --firstColumn;
                                    --maxColumn;
                                    headerLine = false;
                                }
                            } else {
                                buffer.append(tokensBuffer);
                                this.column += tokensBufferLength;
                            }
                            tokensBuffer.setLength(0);
                        }
                        textOnNewLine = false;
                        previousToken = token;
                        break;
                    }
                    case 51: {
                        if (this.scanner.currentPosition > this.scanner.eofPosition) {
                            this.scanner.resetTo(this.scanner.startPosition, textEnd);
                            this.scanner.getNextChar();
                            token = 1;
                        }
                    }
                    default: {
                        boolean shouldSplit;
                        int lastColumn = this.column + tokensBufferLength + tokenLength;
                        if (insertSpace) {
                            ++lastColumn;
                        }
                        boolean bl = shouldSplit = !(lastColumn <= maxColumn || isHtmlTag && previousToken != -1 || token == 53 || tokensBufferLength != 0 && tokensBuffer.charAt(tokensBufferLength - 1) == '@');
                        if (shouldSplit) {
                            if (!(tokensBufferLength <= 0 && tokenLength >= maxColumn || isHtmlTag || tokensBufferLength <= 0 || firstColumn + tokensBufferLength + tokenLength < maxColumn)) {
                                buffer.append(tokensBuffer);
                                this.column += tokensBufferLength;
                                tokensBuffer.setLength(0);
                                tokensBufferLength = 0;
                                textOnNewLine = false;
                            }
                            if (!(tokensBufferLength <= 0 && tokenLength >= maxColumn || textOnNewLine && firstText)) {
                                ++this.lastNumberOfNewLines;
                                ++this.line;
                                if (newLineString == null) {
                                    StringBuffer newLineBuffer = new StringBuffer(this.lineSeparator);
                                    this.column = 1;
                                    this.printIndentationIfNecessary(newLineBuffer);
                                    newLineBuffer.append(" * ");
                                    this.column += BLOCK_LINE_PREFIX_LENGTH;
                                    if (this.commentIndentation != null) {
                                        newLineBuffer.append(this.commentIndentation);
                                        this.column += this.commentIndentation.length();
                                    }
                                    firstColumn = this.column;
                                    newLineString = newLineBuffer.toString();
                                } else {
                                    this.column = firstColumn;
                                }
                                buffer.append(newLineString);
                            }
                            if (tokensBufferLength > 0) {
                                String tokensString = tokensBufferString;
                                buffer.append(tokensString);
                                this.column += tokensString.length();
                                tokensBuffer.setLength(0);
                                tokensBufferLength = 0;
                            }
                            buffer.append(this.scanner.source, tokenStart, tokenLength);
                            this.column += tokenLength;
                            textOnNewLine = false;
                            if (headerLine) {
                                --firstColumn;
                                --maxColumn;
                                headerLine = false;
                            }
                        } else {
                            if (insertSpace) {
                                tokensBuffer.append(' ');
                            }
                            tokensBuffer.append(this.scanner.source, tokenStart, tokenLength);
                        }
                        previousToken = token;
                        this.needSpace = false;
                        if (!headerLine || lastColumn != maxColumn || !this.scanner.atEnd()) continue block9;
                        ++this.lastNumberOfNewLines;
                        ++this.line;
                    }
                }
            }
        }
        finally {
            this.scanner.skipComments = false;
            if (tokensBuffer.length() > 0) {
                buffer.append(tokensBuffer);
                this.column += tokensBuffer.length();
            }
        }
    }

    public void printModifiers(Annotation[] annotations, ASTVisitor visitor) {
        this.printModifiers(annotations, visitor, 0);
    }

    public void printModifiers(Annotation[] annotations, ASTVisitor visitor, int annotationSourceKind) {
        try {
            int annotationsLength = annotations != null ? annotations.length : 0;
            int annotationsIndex = 0;
            boolean isFirstModifier = true;
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasComment = false;
            boolean hasModifiers = false;
            while ((this.currentToken = this.scanner.getNextToken()) != 68) {
                switch (this.currentToken) {
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: {
                        hasModifiers = true;
                        this.print(this.scanner.currentPosition - this.scanner.startPosition, !isFirstModifier);
                        isFirstModifier = false;
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 53: {
                        hasModifiers = true;
                        if (!isFirstModifier) {
                            this.space();
                        }
                        this.scanner.resetTo(this.scanner.getCurrentTokenStartPosition(), this.scannerEndPosition - 1);
                        if (annotationsIndex < annotationsLength) {
                            annotations[annotationsIndex++].traverse(visitor, (BlockScope)null);
                            boolean shouldAddNewLine = false;
                            switch (annotationSourceKind) {
                                case 1: {
                                    if (!this.formatter.preferences.insert_new_line_after_annotation_on_member) break;
                                    shouldAddNewLine = true;
                                    break;
                                }
                                case 2: {
                                    if (!this.formatter.preferences.insert_new_line_after_annotation_on_parameter) break;
                                    shouldAddNewLine = true;
                                    break;
                                }
                                case 3: {
                                    if (!this.formatter.preferences.insert_new_line_after_annotation_on_local_variable) break;
                                    shouldAddNewLine = true;
                                }
                            }
                            if (shouldAddNewLine) {
                                this.printNewLine();
                            }
                        } else {
                            return;
                        }
                        isFirstModifier = false;
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1002: {
                        this.printBlockComment(false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        break;
                    }
                    case 1003: {
                        this.printBlockComment(true);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        break;
                    }
                    case 1001: {
                        this.printLineComment();
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        int count = 0;
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (count >= 1 && hasComment) {
                            this.printNewLine();
                        }
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = false;
                        break;
                    }
                    default: {
                        if (hasModifiers) {
                            this.space();
                        }
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printNewLine() {
        this.printNewLine(this.scanner.getCurrentTokenEndPosition() + 1);
    }

    public void printNewLine(int insertPosition) {
        if (this.nlsTagCounter > 0) {
            return;
        }
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return;
        }
        this.addInsertEdit(insertPosition, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
    }

    public void printNextToken(int expectedTokenType) {
        this.printNextToken(expectedTokenType, false);
    }

    public void printNextToken(int expectedTokenType, boolean considerSpaceIfAny) {
        this.printComment(0);
        try {
            this.currentToken = this.scanner.getNextToken();
            if (expectedTokenType != this.currentToken) {
                throw new AbortFormatting("unexpected token type, expecting:" + expectedTokenType + ", actual:" + this.currentToken);
            }
            this.print(this.scanner.currentPosition - this.scanner.startPosition, considerSpaceIfAny);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printNextToken(int[] expectedTokenTypes) {
        this.printNextToken(expectedTokenTypes, false);
    }

    public void printNextToken(int[] expectedTokenTypes, boolean considerSpaceIfAny) {
        this.printComment(0);
        try {
            this.currentToken = this.scanner.getNextToken();
            if (Arrays.binarySearch(expectedTokenTypes, this.currentToken) < 0) {
                StringBuffer expectations = new StringBuffer(5);
                int i = 0;
                while (i < expectedTokenTypes.length) {
                    if (i > 0) {
                        expectations.append(',');
                    }
                    expectations.append(expectedTokenTypes[i]);
                    ++i;
                }
                throw new AbortFormatting("unexpected token type, expecting:[" + expectations.toString() + "], actual:" + this.currentToken);
            }
            this.print(this.scanner.currentPosition - this.scanner.startPosition, considerSpaceIfAny);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printArrayQualifiedReference(int numberOfTokens, int sourceEnd) {
        int currentTokenStartPosition = this.scanner.currentPosition;
        int numberOfIdentifiers = 0;
        try {
            block11: do {
                this.printComment(0);
                this.currentToken = this.scanner.getNextToken();
                switch (this.currentToken) {
                    case 68: {
                        return;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1002: 
                    case 1003: {
                        this.printBlockComment(false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1001: {
                        this.printLineComment();
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 26: {
                        this.print(this.scanner.currentPosition - this.scanner.startPosition, false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        if (++numberOfIdentifiers != numberOfTokens) continue block11;
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                    case 3: {
                        this.print(this.scanner.currentPosition - this.scanner.startPosition, false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 29: {
                        currentTokenStartPosition = this.scanner.startPosition;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            } while (this.scanner.currentPosition <= sourceEnd);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printQualifiedReference(int sourceEnd, boolean expectParenthesis) {
        int currentTokenStartPosition = this.scanner.currentPosition;
        try {
            do {
                this.printComment(0);
                this.currentToken = this.scanner.getNextToken();
                switch (this.currentToken) {
                    case 68: {
                        return;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1002: 
                    case 1003: {
                        this.printBlockComment(false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1001: {
                        this.printLineComment();
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 3: 
                    case 26: {
                        this.print(this.scanner.currentPosition - this.scanner.startPosition, false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 29: {
                        if (expectParenthesis) {
                            currentTokenStartPosition = this.scanner.startPosition;
                        }
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            } while (this.scanner.currentPosition <= sourceEnd);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    private void printRule(StringBuffer stringBuffer) {
        int i = 0;
        while (i < this.pageWidth) {
            if (i % this.tabLength == 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
            }
            ++i;
        }
        stringBuffer.append(this.lineSeparator);
        i = 0;
        while (i < this.pageWidth / this.tabLength) {
            stringBuffer.append(i);
            stringBuffer.append('\t');
            ++i;
        }
    }

    public void printTrailingComment(int numberOfNewLinesToInsert) {
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasWhitespaces = false;
            boolean hasLineComment = false;
            while ((this.currentToken = this.scanner.getNextToken()) != 68) {
                switch (this.currentToken) {
                    case 1000: {
                        int count = 0;
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (hasLineComment) {
                            if (count >= 1) {
                                currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
                                this.preserveEmptyLines(numberOfNewLinesToInsert, currentTokenStartPosition);
                                this.addDeleteEdit(currentTokenStartPosition, this.scanner.getCurrentTokenEndPosition());
                                this.scanner.resetTo(this.scanner.currentPosition, this.scannerEndPosition - 1);
                                return;
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        if (count > 1) {
                            this.printEmptyLines(numberOfNewLinesToInsert, this.scanner.getCurrentTokenStartPosition());
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        hasWhitespaces = true;
                        currentTokenStartPosition = this.scanner.currentPosition;
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        break;
                    }
                    case 1001: {
                        if (hasWhitespaces) {
                            this.space();
                        }
                        this.printLineComment();
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        break;
                    }
                    case 1002: {
                        if (hasWhitespaces) {
                            this.space();
                        }
                        this.printBlockComment(false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printTrailingComment() {
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasWhitespaces = false;
            boolean hasComment = false;
            boolean hasLineComment = false;
            while ((this.currentToken = this.scanner.getNextToken()) != 68) {
                switch (this.currentToken) {
                    case 1000: {
                        int count = 0;
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (hasLineComment) {
                            if (count >= 1) {
                                currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
                                this.preserveEmptyLines(count, currentTokenStartPosition);
                                this.addDeleteEdit(currentTokenStartPosition, this.scanner.getCurrentTokenEndPosition());
                                this.scanner.resetTo(this.scanner.currentPosition, this.scannerEndPosition - 1);
                                return;
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        if (count >= 1) {
                            if (hasComment) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        hasWhitespaces = true;
                        currentTokenStartPosition = this.scanner.currentPosition;
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        break;
                    }
                    case 1001: {
                        if (hasWhitespaces) {
                            this.space();
                        }
                        this.printLineComment();
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        break;
                    }
                    case 1002: {
                        if (hasWhitespaces) {
                            this.space();
                        }
                        this.printBlockComment(false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    void redoAlignment(AlignmentException e) {
        if (e.relativeDepth > 0) {
            --e.relativeDepth;
            this.currentAlignment = this.currentAlignment.enclosing;
            throw e;
        }
        this.resetAt(this.currentAlignment.location);
        this.scanner.resetTo(this.currentAlignment.location.inputOffset, this.scanner.eofPosition);
        this.currentAlignment.chunkKind = 0;
    }

    void redoMemberAlignment(AlignmentException e) {
        this.resetAt(this.memberAlignment.location);
        this.scanner.resetTo(this.memberAlignment.location.inputOffset, this.scanner.eofPosition);
        this.memberAlignment.chunkKind = 0;
    }

    public void reset() {
        this.checkLineWrapping = true;
        this.line = 0;
        this.column = 1;
        this.editsIndex = 0;
        this.nlsTagCounter = 0;
    }

    private void resetAt(Location location) {
        this.line = location.outputLine;
        this.column = location.outputColumn;
        this.indentationLevel = location.outputIndentationLevel;
        this.numberOfIndentations = location.numberOfIndentations;
        this.lastNumberOfNewLines = location.lastNumberOfNewLines;
        this.needSpace = location.needSpace;
        this.pendingSpace = location.pendingSpace;
        this.editsIndex = location.editsIndex;
        this.nlsTagCounter = location.nlsTagCounter;
        if (this.editsIndex > 0) {
            this.edits[this.editsIndex - 1] = location.textEdit;
        }
        this.formatter.lastLocalDeclarationSourceStart = location.lastLocalDeclarationSourceStart;
    }

    private void resize() {
        this.edits = new OptimizedReplaceEdit[this.editsIndex * 2];
        System.arraycopy(this.edits, 0, this.edits, 0, this.editsIndex);
    }

    void setIncludeComments(boolean on) {
        this.formatComments = on ? (this.formatComments |= 0x1000) : (this.formatComments &= 0xFFFFEFFF);
    }

    void setHeaderComment(int position) {
        this.headerEndPosition = position;
    }

    public void space() {
        if (!this.needSpace) {
            return;
        }
        this.lastNumberOfNewLines = 0;
        this.pendingSpace = true;
        ++this.column;
        this.needSpace = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(page width = " + this.pageWidth + ") - (tabChar = ");
        switch (this.tabChar) {
            case 1: {
                stringBuffer.append("TAB");
                break;
            }
            case 2: {
                stringBuffer.append("SPACE");
                break;
            }
            default: {
                stringBuffer.append("MIXED");
            }
        }
        stringBuffer.append(") - (tabSize = " + this.tabLength + ")").append(this.lineSeparator).append("(line = " + this.line + ") - (column = " + this.column + ") - (identationLevel = " + this.indentationLevel + ")").append(this.lineSeparator).append("(needSpace = " + this.needSpace + ") - (lastNumberOfNewLines = " + this.lastNumberOfNewLines + ") - (checkLineWrapping = " + this.checkLineWrapping + ")").append(this.lineSeparator).append("==================================================================================").append(this.lineSeparator);
        this.printRule(stringBuffer);
        return stringBuffer.toString();
    }

    public void unIndent() {
        this.indentationLevel -= this.indentationSize;
        --this.numberOfIndentations;
    }
}

