/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.eck.mdb;

import edu.hws.eck.mdb.I18n;
import edu.hws.eck.mdb.MandelbrotDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MandelbrotPanel
extends JPanel {
    private MandelbrotDisplay display;
    private JLabel statusBar;

    public MandelbrotPanel() {
        this.setLayout(new BorderLayout());
        this.display = new MandelbrotDisplay();
        this.statusBar = new JLabel(I18n.tr("Idle", new Object[0]));
        this.add((Component)this.display, "Center");
        this.add((Component)this.statusBar, "South");
        MouseHandler mouser = new MouseHandler();
        this.display.addMouseListener(mouser);
        this.display.addMouseMotionListener(mouser);
        this.display.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                String w = "" + MandelbrotPanel.this.display.getWidth();
                String h = "" + MandelbrotPanel.this.display.getHeight();
                MandelbrotPanel.this.statusBar.setText(I18n.tr("status.imageSize", w, h));
            }
        });
    }

    public MandelbrotDisplay getDisplay() {
        return this.display;
    }

    public void zoom(int x, int y, double factor, boolean movePointToCenter) {
        double xmin = this.display.getXmin();
        double xmax = this.display.getXmax();
        double ymin = this.display.getYmin();
        double ymax = this.display.getYmax();
        double newWidth = factor * (xmax - xmin);
        double newHeight = factor * (ymax - ymin);
        double centerX = xmin + (double)x / (double)this.display.getWidth() * (xmax - xmin);
        double centerY = ymax - (double)y / (double)this.display.getHeight() * (ymax - ymin);
        if (movePointToCenter) {
            this.display.setLimits(centerX - newWidth / 2.0, centerX + newWidth / 2.0, centerY - newHeight / 2.0, centerY + newHeight / 2.0);
        } else {
            double newXmin = centerX - newWidth * (centerX - xmin) / (xmax - xmin);
            double newYmin = centerY - newHeight * (centerY - ymin) / (ymax - ymin);
            this.display.setLimits(newXmin, newXmin + newWidth, newYmin, newYmin + newHeight);
        }
    }

    private void doShowCoordsInStatusBar(int x, int y) {
        double xmin = this.display.getXmin();
        double xmax = this.display.getXmax();
        double ymin = this.display.getYmin();
        double ymax = this.display.getYmax();
        double width = this.display.getWidth();
        double height = this.display.getHeight();
        double xCoord = xmin + (double)x / width * (xmax - xmin);
        double yCoord = ymax - (double)y / height * (ymax - ymin);
        double diff = xmax - xmin;
        int scale = 4;
        if (diff > 0.0) {
            while (diff < 1.0) {
                ++scale;
                diff *= 10.0;
            }
        }
        String xStr = String.format("%1." + scale + "f", xCoord);
        String yStr = String.format("%1." + scale + "f", yCoord);
        this.statusBar.setText(I18n.tr("status.mouseCoords", xStr, yStr));
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        int startX;
        int startY;
        boolean dragging;
        boolean zoomOut;
        boolean moved;
        boolean movePointToCenter;

        private MouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            MandelbrotPanel.this.doShowCoordsInStatusBar(this.startX, this.startY);
            this.dragging = false;
            if (MandelbrotPanel.this.display.getStatus() == "out of memory") {
                return;
            }
            this.startX = evt.getX();
            this.startY = evt.getY();
            this.zoomOut = evt.isShiftDown() || evt.isMetaDown();
            this.dragging = true;
            this.moved = false;
            this.movePointToCenter = evt.isAltDown();
        }

        public void mouseReleased(MouseEvent evt) {
            if (!this.dragging) {
                return;
            }
            if (this.moved) {
                MandelbrotPanel.this.display.applyZoom(this.zoomOut);
            } else if (this.zoomOut) {
                MandelbrotPanel.this.zoom(this.startX, this.startY, 2.0, this.movePointToCenter);
            } else {
                MandelbrotPanel.this.zoom(this.startX, this.startY, 0.5, this.movePointToCenter);
            }
            this.dragging = false;
        }

        public void mouseDragged(MouseEvent evt) {
            int x = evt.getX();
            int y = evt.getY();
            MandelbrotPanel.this.doShowCoordsInStatusBar(x, y);
            if (!this.dragging) {
                return;
            }
            int width = Math.abs(x - this.startX);
            int height = Math.abs(y - this.startY);
            if (Math.abs(width) < 3 || Math.abs(height) < 3) {
                if (!MandelbrotPanel.this.display.drawZoomBox(null)) {
                    this.dragging = false;
                }
                return;
            }
            this.moved = true;
            double aspect = (double)width / (double)height;
            double imageAspect = (double)MandelbrotPanel.this.display.getWidth() / (double)MandelbrotPanel.this.display.getHeight();
            if (aspect < imageAspect) {
                width = (int)((double)width * imageAspect / aspect + 0.49);
            } else if (aspect > imageAspect) {
                height = (int)((double)height * aspect / imageAspect + 0.49);
            }
            int x1 = x < this.startX ? this.startX - width : this.startX;
            int y1 = y < this.startY ? this.startY - height : this.startY;
            Rectangle rect = new Rectangle(x1, y1, width, height);
            if (!MandelbrotPanel.this.display.drawZoomBox(rect)) {
                this.dragging = false;
            }
        }

        public void mouseMoved(MouseEvent evt) {
            MandelbrotPanel.this.doShowCoordsInStatusBar(evt.getX(), evt.getY());
        }

        public void mouseExited(MouseEvent evt) {
            MandelbrotPanel.this.statusBar.setText("Idle");
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }
    }
}

