/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.eck.mdb;

import edu.hws.eck.mdb.MandelbrotPanel;
import edu.hws.eck.mdb.Menus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class MandelbrotApplet
extends JApplet {
    private static final String[] SETTINGS_FILE_LIST = new String[]{"settings1", "settings2", "settings3", "settings4", "settings5", "settings6", "settings7", "settings8", "settings9", "settings10", "settings11", "settings12"};
    private MandelbrotPanel panel;
    private Menus menuBar;

    public void init() {
        this.panel = new MandelbrotPanel();
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add(this.panel);
        content.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.setContentPane(content);
        JMenu exampleMenu = this.constructExampleMenu();
        this.menuBar = new Menus(this.panel, null, true);
        if (exampleMenu != null) {
            this.menuBar.add(exampleMenu);
        }
        this.setJMenuBar(this.menuBar);
    }

    private JMenu constructExampleMenu() {
        if (SETTINGS_FILE_LIST == null || SETTINGS_FILE_LIST.length == 0) {
            return null;
        }
        JMenu menu = new JMenu("Examples");
        int i = 0;
        while (i < SETTINGS_FILE_LIST.length) {
            final String str = SETTINGS_FILE_LIST[i];
            JMenuItem item = new JMenuItem(str);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotApplet.this.loadFile(str);
                }
            });
            menu.add(item);
            ++i;
        }
        return menu;
    }

    private void loadFile(String resourceName) {
        resourceName = "edu/hws/eck/mdb/examples/" + resourceName + ".mdb";
        ClassLoader cl = MandelbrotApplet.class.getClassLoader();
        URL resourceURL = cl.getResource(resourceName);
        if (resourceURL != null) {
            try {
                InputStream stream = resourceURL.openStream();
                DocumentBuilder docReader = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document xmldoc = docReader.parse(stream);
                this.menuBar.retrieveSettingsFromXML(xmldoc);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Internal Error.  Couldn't load example\n" + e);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Internal Error.  Couldn't find file.");
        }
    }

    public void destroy() {
        this.panel.getDisplay().shutDownThreads();
    }
}

