/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.eck.mdb;

import edu.hws.eck.mdb.MandelbrotFrame;
import edu.hws.eck.mdb.Menus;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;

public class Main {
    public static void main(String[] args) {
        final MandelbrotFrame frame = new MandelbrotFrame();
        Main.applyPreferences(frame);
        frame.adjustToScreenIfNecessary();
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                frame.getMandelbrotPanel().getDisplay().shutDownThreads();
                Main.savePreferences(frame);
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    private static void savePreferences(MandelbrotFrame frame) {
        try {
            String pathName = "/edu/hws/eck/mdb";
            Preferences root = Preferences.userRoot();
            Preferences node = root.node(pathName);
            Rectangle bounds = frame.getBounds();
            String boundsString = String.valueOf(bounds.x) + "," + bounds.y + "," + bounds.width + "," + bounds.height;
            node.put("mandelbrot.window.bounds", boundsString);
            Menus menus = (Menus)frame.getJMenuBar();
            String currentDir = menus.getSelectedDirectoryInFileChooser();
            if (currentDir != null) {
                node.put("mandelbort.filechooser.directory", currentDir);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyPreferences(MandelbrotFrame frame) {
        try {
            String pathName = "/edu/hws/eck/mdb";
            Preferences root = Preferences.userRoot();
            if (!root.nodeExists(pathName)) {
                return;
            }
            Preferences node = root.node(pathName);
            String boundsString = node.get("mandelbrot.window.bounds", null);
            if (boundsString != null) {
                String[] bounds = Main.explode(boundsString, ",");
                try {
                    int x = Integer.parseInt(bounds[0]);
                    int y = Integer.parseInt(bounds[1]);
                    int w = Integer.parseInt(bounds[2]);
                    int h = Integer.parseInt(bounds[3]);
                    if (w > 5000 || h > 5000) {
                        throw new NumberFormatException();
                    }
                    frame.setBounds(x, y, w, h);
                    frame.adjustToScreenIfNecessary();
                }
                catch (NumberFormatException x) {
                    // empty catch block
                }
            }
            Menus menus = (Menus)frame.getJMenuBar();
            String directory = node.get("mandelbort.filechooser.directory", null);
            if (directory != null) {
                menus.setSelectedDirectoryInFileChooser(directory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String[] explode(String str, String separators) {
        StringTokenizer tokenizer = new StringTokenizer(str, separators);
        int ct = tokenizer.countTokens();
        String[] tokens = new String[ct];
        int i = 0;
        while (i < ct) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }
}

