/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.eck.mdb;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class I18n {
    private static final String propertyFileName = "edu.hws.eck.mdb.strings";
    private static Locale locale;
    private static ResourceBundle translations;

    public static String tr(String key, Object ... args) {
        if (translations == null) {
            I18n.loadStrings();
        }
        if (translations == null) {
            return key;
        }
        try {
            String str = translations.getString(key);
            return MessageFormat.format(str, args);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static String trIfFound(String key, Object ... args) {
        if (translations == null) {
            I18n.loadStrings();
        }
        if (translations == null) {
            return null;
        }
        try {
            String str = translations.getString(key);
            return MessageFormat.format(str, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setLocale(Locale newLocale) {
        if (locale == null && newLocale != null || locale != null && !locale.equals(newLocale)) {
            locale = newLocale;
            translations = null;
        }
    }

    public static void setLanguage(String localeLanguageCode) {
        I18n.setLocale(new Locale(localeLanguageCode));
    }

    private static void loadStrings() {
        if (locale != null) {
            try {
                translations = ResourceBundle.getBundle(propertyFileName, locale);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            translations = ResourceBundle.getBundle(propertyFileName);
        }
        catch (Exception e) {
            translations = null;
        }
    }

    private I18n() {
    }
}

