/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.ide.undo.AbstractCreateResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.internal.ide.undo.AbstractResourceDescription;
import org.eclipse.ui.internal.ide.undo.ContainerDescription;
import org.eclipse.ui.internal.ide.undo.FileDescription;
import org.eclipse.ui.internal.ide.undo.IFileContentDescription;

public class CreateFileOperation
extends AbstractCreateResourcesOperation {
    public CreateFileOperation(IFile fileHandle, URI linkLocation, InputStream contents, String label) {
        super((ResourceDescription[])null, label);
        AbstractResourceDescription resourceDescription;
        if (fileHandle.getParent().exists()) {
            resourceDescription = new FileDescription(fileHandle, linkLocation, this.createFileContentDescription(fileHandle, contents));
        } else {
            ContainerDescription containerDescription = ContainerDescription.fromContainer(fileHandle.getParent());
            containerDescription.getFirstLeafFolder().addMember(new FileDescription(fileHandle, linkLocation, this.createFileContentDescription(fileHandle, contents)));
            resourceDescription = containerDescription;
        }
        this.setResourceDescriptions(new ResourceDescription[]{resourceDescription});
    }

    private IFileContentDescription createFileContentDescription(final IFile file, final InputStream contents) {
        return new IFileContentDescription(){

            public InputStream getContents() {
                if (contents != null) {
                    return contents;
                }
                return new ByteArrayInputStream(new byte[0]);
            }

            public String getCharset() {
                try {
                    return file.getCharset(false);
                }
                catch (CoreException coreException) {
                    return null;
                }
            }

            public boolean exists() {
                return true;
            }
        };
    }

    public IStatus computeExecutionStatus(IProgressMonitor monitor) {
        IStatus status = super.computeExecutionStatus(monitor);
        if (status.isOK()) {
            status = this.computeCreateStatus(false);
        }
        return status;
    }
}

