/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportTab;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;

public class ExportDestinationTab
extends AbstractExportTab {
    protected static final String S_EXPORT_TYPE = "exportType";
    protected static final String S_DESTINATION = "destination";
    protected static final String S_ZIP_FILENAME = "zipFileName";
    protected static final String S_INSTALL_DESTINATION = "installDestination";
    protected static final int TYPE_DIR = 1;
    protected static final int TYPE_ARCHIVE = 2;
    protected static final int TYPE_INSTALL = 3;
    protected static String ZIP_EXTENSION = ".zip";
    protected Button fArchiveFileButton;
    protected Combo fArchiveCombo;
    protected Button fBrowseFile;
    protected Button fDirectoryButton;
    protected Combo fDirectoryCombo;
    protected Button fBrowseDirectory;
    protected Button fInstallButton;
    protected Combo fInstallCombo;
    protected Button fBrowseInstall;

    public ExportDestinationTab(AbstractExportWizardPage page) {
        super(page);
    }

    public Control createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, 2, 1, 768);
        this.fDirectoryButton = SWTFactory.createRadioButton(composite, PDEUIMessages.ExportWizard_directory, 2);
        this.fDirectoryCombo = SWTFactory.createCombo(composite, 2048, 1, null);
        ((GridData)this.fDirectoryCombo.getLayoutData()).horizontalIndent = 15;
        this.fBrowseDirectory = SWTFactory.createPushButton(composite, PDEUIMessages.ExportWizard_browse, null);
        SWTUtil.setButtonDimensionHint(this.fBrowseDirectory);
        this.fArchiveFileButton = SWTFactory.createRadioButton(composite, PDEUIMessages.ExportWizard_archive, 2);
        this.fArchiveCombo = SWTFactory.createCombo(composite, 2048, 1, null);
        ((GridData)this.fArchiveCombo.getLayoutData()).horizontalIndent = 15;
        this.fBrowseFile = SWTFactory.createPushButton(composite, PDEUIMessages.ExportWizard_browse, null);
        SWTUtil.setButtonDimensionHint(this.fBrowseFile);
        this.fInstallButton = SWTFactory.createRadioButton(composite, PDEUIMessages.ExportDestinationTab_InstallIntoCurrentPlatform, 2);
        this.fInstallCombo = SWTFactory.createCombo(composite, 2048, 1, null);
        ((GridData)this.fInstallCombo.getLayoutData()).horizontalIndent = 15;
        this.fBrowseInstall = SWTFactory.createPushButton(composite, PDEUIMessages.ExportWizard_browse, null);
        SWTUtil.setButtonDimensionHint(this.fBrowseInstall);
        return composite;
    }

    protected void initialize(IDialogSettings settings) {
        String exportType = settings.get(S_EXPORT_TYPE);
        int exportTypeCode = 1;
        if (exportType != null && exportType.length() > 0) {
            try {
                exportTypeCode = Integer.parseInt(exportType);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.fDirectoryButton.setSelection(exportTypeCode == 1);
        this.fArchiveFileButton.setSelection(exportTypeCode == 2);
        this.fInstallButton.setSelection(exportTypeCode == 3);
        this.updateExportType();
        this.initializeCombo(settings, S_DESTINATION, this.fDirectoryCombo);
        this.initializeCombo(settings, S_ZIP_FILENAME, this.fArchiveCombo);
        this.initializeCombo(settings, S_INSTALL_DESTINATION, this.fInstallCombo);
        String defaultRepo = PDEPlugin.getWorkspace().getRoot().getLocation() + "/.metadata/.plugins/org.eclipse.pde.core/install/";
        if (this.fInstallCombo.indexOf(defaultRepo) == -1) {
            this.fInstallCombo.add(defaultRepo);
        }
        this.hookListeners();
    }

    protected void initializeCombo(IDialogSettings settings, String key, Combo combo) {
        super.initializeCombo(settings, key, combo);
        if (!this.isValidLocation(combo.getText().trim())) {
            combo.setText("");
        }
    }

    protected void updateExportType() {
        this.fArchiveCombo.setEnabled(this.fArchiveFileButton.getSelection());
        this.fBrowseFile.setEnabled(this.fArchiveFileButton.getSelection());
        this.fDirectoryCombo.setEnabled(this.fDirectoryButton.getSelection());
        this.fBrowseDirectory.setEnabled(this.fDirectoryButton.getSelection());
        this.fInstallCombo.setEnabled(this.fInstallButton.getSelection());
        this.fBrowseInstall.setEnabled(this.fInstallButton.getSelection());
        if (((BaseExportWizardPage)this.fPage).fOptionsTab != null) {
            ((BaseExportWizardPage)this.fPage).fOptionsTab.setEnabledForInstall(!this.fInstallButton.getSelection());
        }
    }

    protected void hookListeners() {
        this.fArchiveFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDestinationTab.this.updateExportType();
                ExportDestinationTab.this.fPage.pageChanged();
            }
        });
        this.fBrowseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDestinationTab.this.chooseFile(ExportDestinationTab.this.fArchiveCombo, new String[]{"*" + ZIP_EXTENSION});
            }
        });
        this.fArchiveCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDestinationTab.this.fPage.pageChanged();
            }
        });
        this.fDirectoryCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDestinationTab.this.fPage.pageChanged();
            }
        });
        this.fBrowseDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDestinationTab.this.chooseDestination(ExportDestinationTab.this.fDirectoryCombo);
            }
        });
        this.fInstallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDestinationTab.this.updateExportType();
                if (ExportDestinationTab.this.fInstallCombo.getText().trim().length() == 0 && ExportDestinationTab.this.fInstallCombo.getItemCount() > 0) {
                    ExportDestinationTab.this.fInstallCombo.select(0);
                }
            }
        });
        this.fInstallCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDestinationTab.this.fPage.pageChanged();
            }
        });
        this.fBrowseInstall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDestinationTab.this.chooseDestination(ExportDestinationTab.this.fInstallCombo);
            }
        });
    }

    private void chooseDestination(Combo combo) {
        DirectoryDialog dialog = new DirectoryDialog(this.fPage.getShell(), 8192);
        String path = combo.getText();
        if (path.trim().length() == 0) {
            path = PDEPlugin.getWorkspace().getRoot().getLocation().toString();
        }
        dialog.setFilterPath(path);
        dialog.setText(PDEUIMessages.ExportWizard_dialog_title);
        dialog.setMessage(PDEUIMessages.ExportWizard_dialog_message);
        String res = dialog.open();
        if (res != null) {
            if (combo.indexOf(res) == -1) {
                combo.add(res, 0);
            }
            combo.setText(res);
        }
    }

    protected void saveSettings(IDialogSettings settings) {
        int type;
        int n = type = this.fDirectoryButton.getSelection() ? 1 : 3;
        if (this.fArchiveFileButton.getSelection()) {
            type = 2;
        }
        settings.put(S_EXPORT_TYPE, type);
        this.saveCombo(settings, S_DESTINATION, this.fDirectoryCombo);
        this.saveCombo(settings, S_ZIP_FILENAME, this.fArchiveCombo);
        this.saveCombo(settings, S_INSTALL_DESTINATION, this.fInstallCombo);
    }

    protected String validate() {
        if (this.fArchiveFileButton.getSelection()) {
            if (this.fArchiveCombo.getText().trim().length() == 0) {
                return PDEUIMessages.ExportWizard_status_nofile;
            }
            if (!this.isValidLocation(this.fArchiveCombo.getText().trim())) {
                return PDEUIMessages.ExportWizard_status_invaliddirectory;
            }
        }
        if (this.fDirectoryButton.getSelection()) {
            if (this.fDirectoryCombo.getText().trim().length() == 0) {
                return PDEUIMessages.ExportWizard_status_nodirectory;
            }
            if (!this.isValidLocation(this.fDirectoryCombo.getText().trim())) {
                return PDEUIMessages.ExportWizard_status_invaliddirectory;
            }
        }
        if (this.fInstallButton.getSelection()) {
            if (this.fInstallCombo.getText().trim().length() == 0) {
                return PDEUIMessages.ExportWizard_status_nodirectory;
            }
            if (!this.isValidLocation(this.fInstallCombo.getText().trim())) {
                return PDEUIMessages.ExportWizard_status_invaliddirectory;
            }
        }
        return null;
    }

    protected String getFileName() {
        String path;
        if (this.fArchiveFileButton.getSelection() && (path = this.fArchiveCombo.getText()) != null && path.length() > 0) {
            String fileName = new Path(path).lastSegment();
            if (!fileName.endsWith(ZIP_EXTENSION)) {
                fileName = String.valueOf(fileName) + ZIP_EXTENSION;
            }
            return fileName;
        }
        return null;
    }

    protected String getDestination() {
        if (this.fArchiveFileButton.getSelection()) {
            String path = this.fArchiveCombo.getText();
            if (path.length() > 0) {
                path = new Path(path).removeLastSegments(1).toOSString();
                return new File(path).getAbsolutePath();
            }
            return "";
        }
        if (this.fInstallButton.getSelection()) {
            File dir = new File(this.fInstallCombo.getText().trim());
            return dir.getAbsolutePath();
        }
        File dir = new File(this.fDirectoryCombo.getText().trim());
        return dir.getAbsolutePath();
    }

    protected boolean doExportToDirectory() {
        return this.fDirectoryButton.getSelection() || this.fInstallButton.getSelection();
    }

    protected boolean doInstall() {
        return this.fInstallButton.getSelection();
    }
}

