/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesLabelProvider;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesView;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesViewPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class DependenciesViewTreePage
extends DependenciesViewPage {
    TreeViewer fTreeViewer;
    private OptionalFilter fHideOptionalFilter = new OptionalFilter();

    public DependenciesViewTreePage(DependenciesView view, ITreeContentProvider contentProvider) {
        super(view, (IContentProvider)contentProvider);
    }

    protected StructuredViewer createViewer(Composite parent) {
        this.fTreeViewer = new TreeViewer(parent, 770);
        this.fTreeViewer.setContentProvider(this.fContentProvider);
        final DependenciesLabelProvider labelProvider = new DependenciesLabelProvider(true);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fTreeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                labelProvider.dispose();
            }
        });
        this.fTreeViewer.setAutoExpandLevel(2);
        return this.fTreeViewer;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        if (toolBarManager.find("tree") != null) {
            toolBarManager.prependToGroup("tree", (IAction)new CollapseAllAction());
        } else {
            toolBarManager.add((IAction)new CollapseAllAction());
        }
    }

    protected void handleShowOptional(boolean isChecked, boolean refreshIfNecessary) {
        if (isChecked) {
            this.fTreeViewer.removeFilter((ViewerFilter)this.fHideOptionalFilter);
        } else {
            this.fTreeViewer.addFilter((ViewerFilter)this.fHideOptionalFilter);
        }
    }

    protected boolean isShowingOptional() {
        ViewerFilter[] filters = this.fTreeViewer.getFilters();
        int i = 0;
        while (i < filters.length) {
            if (filters[i].equals((Object)this.fHideOptionalFilter)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            this.setText(PDEUIMessages.DependenciesViewTreePage_CollapseAllAction_label);
            this.setDescription(PDEUIMessages.DependenciesViewTreePage_CollapseAllAction_description);
            this.setToolTipText(PDEUIMessages.DependenciesViewTreePage_CollapseAllAction_tooltip);
            this.setImageDescriptor(PDEPluginImages.DESC_COLLAPSE_ALL);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_COLLAPSE_ALL);
        }

        public void run() {
            super.run();
            DependenciesViewTreePage.this.fTreeViewer.collapseAll();
        }
    }

    class OptionalFilter
    extends ViewerFilter {
        OptionalFilter() {
        }

        public boolean select(Viewer v, Object parent, Object element) {
            if (element instanceof BundleSpecification) {
                return !((BundleSpecification)element).isOptional();
            }
            if (element instanceof ImportPackageSpecification) {
                return !"optional".equals(((ImportPackageSpecification)element).getDirective("resolution"));
            }
            return true;
        }
    }
}

