/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditorInputFactory;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class InternalClassFileEditorInput
implements IClassFileEditorInput,
IPersistableElement {
    private IClassFile fClassFile;

    public InternalClassFileEditorInput(IClassFile classFile) {
        this.fClassFile = classFile;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InternalClassFileEditorInput)) {
            return false;
        }
        InternalClassFileEditorInput other = (InternalClassFileEditorInput)obj;
        return this.fClassFile.equals(other.fClassFile);
    }

    public int hashCode() {
        return this.fClassFile.hashCode();
    }

    public IClassFile getClassFile() {
        return this.fClassFile;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getName() {
        return this.fClassFile.getElementName();
    }

    public String getToolTipText() {
        return this.fClassFile.getType().getFullyQualifiedName();
    }

    public ImageDescriptor getImageDescriptor() {
        try {
            if (this.fClassFile.isClass()) {
                return JavaPluginImages.DESC_OBJS_CFILECLASS;
            }
            return JavaPluginImages.DESC_OBJS_CFILEINT;
        }
        catch (JavaModelException javaModelException) {
            return JavaPluginImages.DESC_OBJS_CFILE;
        }
    }

    public boolean exists() {
        return this.fClassFile.exists();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IClassFile.class) {
            return this.fClassFile;
        }
        if (adapter == IJavaElement.class) {
            return this.fClassFile;
        }
        return null;
    }

    public void saveState(IMemento memento) {
        ClassFileEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return "org.eclipse.jdt.ui.ClassFileEditorInputFactory";
    }
}

