/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSListener;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.osgi.service.prefs.BackingStoreException;

public class KnownRepositories
implements IEclipsePreferences.INodeChangeListener,
IEclipsePreferences.IPreferenceChangeListener {
    private List repositoryListeners = new ArrayList();
    private Map repositories;
    private static KnownRepositories instance;

    public static synchronized KnownRepositories getInstance() {
        if (instance == null) {
            instance = new KnownRepositories();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepositoryListener(ICVSListener listener) {
        List list = this.repositoryListeners;
        synchronized (list) {
            this.repositoryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryListener(ICVSListener listener) {
        List list = this.repositoryListeners;
        synchronized (list) {
            this.repositoryListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICVSRepositoryLocation addRepository(ICVSRepositoryLocation repository, boolean broadcast) {
        CVSRepositoryLocation existingLocation;
        KnownRepositories knownRepositories = this;
        synchronized (knownRepositories) {
            existingLocation = this.internalGetRepository(repository.getLocation(false));
            if (existingLocation == null) {
                this.store((CVSRepositoryLocation)repository);
                existingLocation = (CVSRepositoryLocation)repository;
            }
        }
        if (broadcast) {
            final CVSRepositoryLocation location = existingLocation;
            ((CVSRepositoryLocation)repository).updateCache();
            this.fireNotification(new Notification(){

                public void notify(ICVSListener listener) {
                    listener.repositoryAdded(location);
                }
            });
        }
        return existingLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeRepository(final ICVSRepositoryLocation repository) {
        Object removed;
        KnownRepositories knownRepositories = this;
        synchronized (knownRepositories) {
            ((CVSRepositoryLocation)repository).dispose();
            removed = this.getRepositoriesMap().remove(repository.getLocation(false));
        }
        if (removed != null) {
            this.fireNotification(new Notification(){

                public void notify(ICVSListener listener) {
                    listener.repositoryRemoved(repository);
                }
            });
        }
    }

    public synchronized boolean isKnownRepository(String location) {
        return this.internalGetRepository(location) != null;
    }

    public synchronized ICVSRepositoryLocation[] getRepositories() {
        return this.getRepositoriesMap().values().toArray(new ICVSRepositoryLocation[this.getRepositoriesMap().size()]);
    }

    public synchronized ICVSRepositoryLocation getRepository(String location) throws CVSException {
        CVSRepositoryLocation repository = this.internalGetRepository(location);
        if (repository == null) {
            repository = CVSRepositoryLocation.fromString(location);
        }
        return repository;
    }

    private CVSRepositoryLocation internalGetRepository(String location) {
        return (CVSRepositoryLocation)this.getRepositoriesMap().get(location);
    }

    private void store(CVSRepositoryLocation location) {
        this.getRepositoriesMap().put(location.getLocation(), location);
        location.storePreferences();
    }

    private Map getRepositoriesMap() {
        if (this.repositories == null) {
            this.repositories = new HashMap();
            IEclipsePreferences prefs = (IEclipsePreferences)CVSRepositoryLocation.getParentPreferences();
            prefs.addNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            try {
                String[] keys = prefs.childrenNames();
                int i = 0;
                while (i < keys.length) {
                    String key = keys[i];
                    try {
                        IEclipsePreferences node = (IEclipsePreferences)prefs.node(key);
                        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                        String location = node.get("location", null);
                        if (location != null) {
                            this.repositories.put(location, CVSRepositoryLocation.fromString(location));
                        } else {
                            node.removeNode();
                            prefs.flush();
                        }
                    }
                    catch (CVSException e) {
                        CVSProviderPlugin.log((CoreException)((Object)e));
                    }
                    ++i;
                }
                if (this.repositories.isEmpty()) {
                    this.getRepositoriesFromProjects();
                }
            }
            catch (BackingStoreException e) {
                CVSProviderPlugin.log(4, CVSMessages.KnownRepositories_0, e);
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
        }
        return this.repositories;
    }

    private void getRepositoriesFromProjects() throws CVSException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            ICVSFolder folder;
            FolderSyncInfo info;
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)projects[i], (String)CVSProviderPlugin.getTypeId());
            if (provider != null && (info = (folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)projects[i])).getFolderSyncInfo()) != null) {
                this.addRepository(this.getRepository(info.getRoot()), false);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICVSListener[] getListeners() {
        List list = this.repositoryListeners;
        synchronized (list) {
            return this.repositoryListeners.toArray(new ICVSListener[this.repositoryListeners.size()]);
        }
    }

    private void fireNotification(Notification notification) {
        ICVSListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ICVSListener listener = listeners[i];
            notification.run(listener);
            ++i;
        }
    }

    public void added(IEclipsePreferences.NodeChangeEvent event) {
        ((IEclipsePreferences)event.getChild()).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void removed(IEclipsePreferences.NodeChangeEvent event) {
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("location".equals(event.getKey())) {
            String location = (String)event.getNewValue();
            if (location == null) {
                ((IEclipsePreferences)event.getNode()).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            } else {
                try {
                    this.addRepository(CVSRepositoryLocation.fromString(location), true);
                }
                catch (CVSException e) {
                    CVSProviderPlugin.log((CoreException)((Object)e));
                }
            }
        }
    }

    private abstract class Notification
    implements ISafeRunnable {
        private ICVSListener listener;

        private Notification() {
        }

        public void handleException(Throwable exception) {
        }

        public void run(ICVSListener listener) {
            this.listener = listener;
            Platform.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.notify(this.listener);
        }

        protected abstract void notify(ICVSListener var1);
    }
}

