/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.tasklist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTrace {
    private final int length;
    private final int offset;
    private final String stackTrace;
    private final Object comment;

    public StackTrace(String stackTrace, int offset, int length, Object comment) {
        this.stackTrace = stackTrace;
        this.offset = offset;
        this.length = length;
        this.comment = comment;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public int getLength() {
        return this.length;
    }

    public Object getComment() {
        return this.comment;
    }

    public static StackTrace[] getStackTrace(String s, Object comment) {
        String regexExceptionType = "^(.*\\.)+.+(Exception|Error|Throwable).*";
        String regexSkip = ".*\\.\\..*";
        String[] lines = s.split("\r\n|\n");
        int charStackStart = 0;
        int[] charPos = new int[1];
        boolean inStackTrace = false;
        ArrayList<String> stackTrace = null;
        ArrayList<StackTrace> stackTraces = new ArrayList<StackTrace>();
        int i = 0;
        while (i < lines.length) {
            if (lines[i].matches(regexSkip)) {
                charPos[0] = charPos[0] + (lines[i].length() + 2);
            } else if (lines[i].trim().matches(regexExceptionType) && !inStackTrace) {
                if (stackTrace != null && stackTrace.size() > 1) {
                    stackTraces.add(StackTrace.getStackTrace(stackTrace, charStackStart, charPos[0] - charStackStart, comment));
                }
                stackTrace = new ArrayList<String>();
                inStackTrace = true;
                stackTrace.add(lines[i]);
                charStackStart = charPos[0];
                charPos[0] = charPos[0] + (lines[i].length() + 2);
            } else if (inStackTrace) {
                int[] pos = new int[]{i};
                String stack = StackTrace.getNextAt(lines, pos, charPos);
                if (stack == null) {
                    inStackTrace = false;
                    if (stackTrace != null && stackTrace.size() > 1) {
                        stackTraces.add(StackTrace.getStackTrace(stackTrace, charStackStart, charPos[0] - charStackStart, comment));
                    }
                    stackTrace = null;
                } else if (stackTrace != null) {
                    stackTrace.add(stack);
                }
                i = pos[0];
            } else {
                charPos[0] = charPos[0] + (lines[i].length() + 2);
            }
            ++i;
        }
        if (stackTrace != null && stackTrace.size() > 1) {
            stackTraces.add(StackTrace.getStackTrace((List<String>)stackTrace, charStackStart, charPos[0] - charStackStart, comment));
        }
        if (stackTraces.size() == 0) {
            return null;
        }
        return StackTrace.getTracesFromList(stackTraces);
    }

    private static String getNextAt(String[] lines, int[] i, int[] charPos) {
        String regexAtString = "^at.*";
        String regexEndString = ".*:\\d+\\)$";
        int index = i[0];
        String l4 = null;
        String l3 = null;
        String l2 = null;
        String l1 = null;
        String res = null;
        if (lines.length <= index) {
            return null;
        }
        l1 = lines[index];
        if (lines.length > index + 1) {
            l2 = lines[index + 1];
        }
        if (lines.length > index + 2) {
            l3 = lines[index + 2];
        }
        if (lines.length > index + 3) {
            l4 = lines[index + 3];
        }
        if (!l1.trim().matches(regexAtString)) {
            return null;
        }
        charPos[0] = charPos[0] + (l1.length() + 2);
        res = l1;
        if (!res.trim().matches(regexEndString)) {
            if (l2 != null && l2.trim().matches(regexEndString)) {
                i[0] = index + 1;
                charPos[0] = charPos[0] + (l2.length() + 2);
                res = String.valueOf(res) + l2.trim();
            } else if (l2 != null && l3 != null && l3.trim().matches(regexEndString)) {
                i[0] = index + 2;
                charPos[0] = charPos[0] + (l2.length() + l3.length() + 4);
                res = String.valueOf(res) + l2.trim();
                res = String.valueOf(res) + l3.trim();
            } else if (l2 != null && l3 != null && l4 != null && l4.trim().matches(regexEndString)) {
                i[0] = index + 3;
                charPos[0] = charPos[0] + (l2.length() + l3.length() + l4.length() + 6);
                res = String.valueOf(res) + l2.trim();
                res = String.valueOf(res) + l3.trim();
                res = String.valueOf(res) + l4.trim();
            }
        }
        return res;
    }

    private static StackTrace getStackTrace(List<String> l, int offset, int length, Object comment) {
        String s = "";
        for (String s2 : l) {
            s = String.valueOf(s) + s2 + "\r\n";
        }
        return new StackTrace(s, offset, length, comment);
    }

    private static StackTrace[] getTracesFromList(List<StackTrace> l) {
        if (l == null || l.size() == 0) {
            return null;
        }
        int i = 0;
        StackTrace[] s = new StackTrace[l.size()];
        Iterator<StackTrace> iterator = l.iterator();
        while (iterator.hasNext()) {
            StackTrace st;
            s[i] = st = iterator.next();
            ++i;
        }
        return s;
    }

    public static String escapeForRegex(String s) {
        String sFixed = s;
        sFixed = sFixed.replaceAll("\\\\", "\\\\\\\\");
        sFixed = sFixed.replaceAll("\\$", "\\\\\\$");
        sFixed = sFixed.replaceAll("\\.", "\\\\.");
        sFixed = sFixed.replaceAll("\\?", "\\\\?");
        sFixed = sFixed.replaceAll("\\{", "\\\\{");
        sFixed = sFixed.replaceAll("\\}", "\\\\}");
        sFixed = sFixed.replaceAll("\\(", "\\\\(");
        sFixed = sFixed.replaceAll("\\)", "\\\\)");
        sFixed = sFixed.replaceAll("\\[", "\\\\[");
        sFixed = sFixed.replaceAll("\\]", "\\\\]");
        sFixed = sFixed.replaceAll("\\+", "\\\\+");
        sFixed = sFixed.replaceAll("\\*", "\\\\*");
        sFixed = sFixed.replaceAll("\\|", "\\\\|");
        sFixed = sFixed.replaceAll("\\^", "\\\\^");
        sFixed = sFixed.replaceAll("\\/", "\\\\/");
        return sFixed;
    }
}

