/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.generator.features;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteCategory;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteFeature;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.URLEntry;

public class SiteModel {
    private List archiveReferences;
    private Map categories;
    private URLEntry description;
    private List features;
    private String mirrorsURLString;
    private URLEntry[] associateSites;
    private List messageKeys;
    private Map localizations;

    public void addArchive(URLEntry archiveReference) {
        if (this.archiveReferences == null) {
            this.archiveReferences = new ArrayList();
        }
        if (!this.archiveReferences.contains(archiveReference)) {
            this.archiveReferences.add(archiveReference);
        }
    }

    public void addCategory(SiteCategory category) {
        if (this.categories == null) {
            this.categories = new HashMap();
        }
        if (!this.categories.containsKey(category.getName())) {
            this.categories.put(category.getName(), category);
            if (this.localizations != null && !this.localizations.isEmpty()) {
                category.setLocalizations(this.localizations);
            }
        }
    }

    public void addFeature(SiteFeature featureReference) {
        if (this.features == null) {
            this.features = new ArrayList();
        }
        this.features.add(featureReference);
    }

    public URLEntry[] getAssociatedSites() {
        return this.associateSites;
    }

    public SiteCategory getCategory(String name) {
        return this.categories == null ? null : this.categories.get(name);
    }

    public URLEntry getDescription() {
        return this.description;
    }

    public SiteFeature[] getFeatures() {
        if (this.features == null || this.features.size() == 0) {
            return new SiteFeature[0];
        }
        return this.features.toArray(new SiteFeature[0]);
    }

    public List getMessageKeys() {
        return this.messageKeys;
    }

    public String getMirrorsURL() {
        return this.mirrorsURLString;
    }

    public void setDescription(URLEntry description) {
        this.description = description;
    }

    public void setLocalizations(Map localizations) {
        this.localizations = localizations;
        if (localizations != null && !localizations.isEmpty() && this.categories != null && !this.categories.isEmpty()) {
            Iterator catIter = this.categories.entrySet().iterator();
            while (catIter.hasNext()) {
                Map.Entry entry = catIter.next();
                SiteCategory category = (SiteCategory)entry.getValue();
                category.setLocalizations(localizations);
            }
        }
    }

    public void setMessageKeys(List keys) {
        this.messageKeys = keys;
    }

    public void setMirrorsURLString(String mirrorsURL) {
        this.mirrorsURLString = mirrorsURL;
    }

    public void setAssociateSites(URLEntry[] associateSites) {
        this.associateSites = associateSites;
    }
}

