/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.SingleSelectionAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskContainerComparator;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TaskEditorActionPart
extends AbstractTaskEditorPart {
    private static final String KEY_OPERATION = "operation";
    private static final int DEFAULT_FIELD_WIDTH = 150;
    private static final int RADIO_OPTION_WIDTH = 120;
    private static final String KEY_ASSOCIATED_EDITOR = "associatedEditor";
    private List<Button> operationButtons;
    private Button submitButton;
    private Button attachContextButton;
    private Button addToCategory;
    private CCombo categoryChooser;
    private AbstractTaskCategory category;
    private TaskAttribute selectedOperationAttribute;

    public TaskEditorActionPart() {
        this.setPartName(Messages.TaskEditorActionPart_Actions);
    }

    protected void addAttachContextButton(Composite buttonComposite, FormToolkit toolkit) {
        this.attachContextButton = toolkit.createButton(buttonComposite, Messages.TaskEditorActionPart_Attach_Context, 32);
        this.attachContextButton.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_ATTACH));
    }

    private void createActionButtons(Composite buttonComposite, FormToolkit toolkit) {
        this.submitButton = toolkit.createButton(buttonComposite, Messages.TaskEditorActionPart_Submit, 0);
        GridData submitButtonData = new GridData(32);
        submitButtonData.widthHint = 100;
        this.submitButton.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY_SUBMIT));
        this.submitButton.setLayoutData((Object)submitButtonData);
        this.submitButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TaskEditorActionPart.this.getTaskEditorPage().doSubmit();
            }
        });
        this.setSubmitEnabled(true);
        toolkit.createLabel(buttonComposite, "    ");
        if (!this.getTaskData().isNew()) {
            this.addAttachContextButton(buttonComposite, toolkit);
        }
    }

    private void createCategoryChooser(Composite buttonComposite, FormToolkit toolkit) {
        this.addToCategory = this.getManagedForm().getToolkit().createButton(buttonComposite, Messages.TaskEditorActionPart_Add_to_Category, 32);
        this.categoryChooser = new CCombo(buttonComposite, 0x800008);
        this.categoryChooser.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.categoryChooser.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).create());
        toolkit.adapt((Control)this.categoryChooser, false, false);
        this.categoryChooser.setFont(TEXT_FONT);
        ITaskList taskList = TasksUiInternal.getTaskList();
        final ArrayList categories = new ArrayList(taskList.getCategories());
        Collections.sort(categories, new TaskContainerComparator());
        AbstractTaskCategory selectedCategory = TasksUiInternal.getSelectedCategory(TaskListView.getFromActivePerspective());
        int i = 0;
        int selectedIndex = 0;
        for (IRepositoryElement category : categories) {
            this.categoryChooser.add(category.getSummary());
            if (category.equals(selectedCategory)) {
                selectedIndex = i;
            }
            ++i;
        }
        this.categoryChooser.select(selectedIndex);
        this.categoryChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TaskEditorActionPart.this.categoryChooser.getSelectionIndex() != -1) {
                    TaskEditorActionPart.this.category = (AbstractTaskCategory)categories.get(TaskEditorActionPart.this.categoryChooser.getSelectionIndex());
                }
            }
        });
        this.categoryChooser.setEnabled(false);
        this.addToCategory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskEditorActionPart.this.markDirty();
                if (!TaskEditorActionPart.this.addToCategory.getSelection()) {
                    TaskEditorActionPart.this.category = null;
                } else if (TaskEditorActionPart.this.categoryChooser.getSelectionIndex() != -1) {
                    TaskEditorActionPart.this.category = (AbstractTaskCategory)categories.get(TaskEditorActionPart.this.categoryChooser.getSelectionIndex());
                }
                TaskEditorActionPart.this.categoryChooser.setEnabled(TaskEditorActionPart.this.addToCategory.getSelection());
            }
        });
        GridDataFactory.fillDefaults().hint(150, -1).span(3, -1).applyTo((Control)this.categoryChooser);
    }

    public AbstractTaskCategory getCategory() {
        return this.category;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Section section = this.createSection(parent, toolkit, true);
        Composite buttonComposite = toolkit.createComposite((Composite)section);
        GridLayout buttonLayout = EditorUtil.createSectionClientLayout();
        buttonLayout.numColumns = 4;
        buttonComposite.setLayout((Layout)buttonLayout);
        if (this.getTaskEditorPage().needsAddToCategory()) {
            this.createCategoryChooser(buttonComposite, toolkit);
        }
        this.selectedOperationAttribute = this.getTaskData().getRoot().getMappedAttribute("task.common.operation");
        if (this.selectedOperationAttribute != null && KEY_OPERATION.equals(this.selectedOperationAttribute.getMetaData().getType())) {
            TaskOperation selectedOperation = this.getTaskData().getAttributeMapper().getTaskOperation(this.selectedOperationAttribute);
            this.createRadioButtons(buttonComposite, toolkit, selectedOperation);
        }
        this.createOperationAttributes(buttonComposite, toolkit);
        this.createActionButtons(buttonComposite, toolkit);
        toolkit.paintBordersFor(buttonComposite);
        section.setClient((Control)buttonComposite);
        this.setSection(toolkit, section);
    }

    private void createOperationAttributes(Composite buttonComposite, FormToolkit toolkit) {
        Composite parent = null;
        for (TaskAttribute taskAttribute : this.getTaskData().getRoot().getAttributes().values()) {
            if (!"task.common.kind.operation".equals(taskAttribute.getMetaData().getKind())) continue;
            if (parent == null) {
                parent = toolkit.createComposite(buttonComposite);
                parent.setLayout((Layout)new GridLayout(2, false));
                GridDataFactory.fillDefaults().span(4, 1).grab(true, false).applyTo((Control)parent);
                toolkit.paintBordersFor(parent);
            }
            this.addAttribute(parent, toolkit, taskAttribute);
        }
    }

    private void addAttribute(Composite attributesComposite, FormToolkit toolkit, TaskAttribute taskAttribute) {
        AbstractAttributeEditor attributeEditor = this.createAttributeEditor(taskAttribute);
        if (attributeEditor.hasLabel() && attributeEditor.getLabel().length() != 0) {
            attributeEditor.createLabelControl(attributesComposite, toolkit);
            Label label = attributeEditor.getLabelControl();
            String text = label.getText();
            label.setText(text);
            GridData gd = GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(-1, -1).create();
            label.setLayoutData((Object)gd);
        }
        attributeEditor.createControl(attributesComposite, toolkit);
        this.getTaskEditorPage().getAttributeEditorToolkit().adapt(attributeEditor);
        GridData gd = new GridData(4, 2, true, false);
        gd.minimumWidth = 150;
        if (attributeEditor.getLabelControl() == null) {
            gd.horizontalSpan = 2;
        }
        attributeEditor.getControl().setLayoutData((Object)gd);
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute, Button button) {
        AbstractAttributeEditor editor = this.createAttributeEditor(attribute);
        if (editor != null) {
            editor.createControl(composite, toolkit);
            GridData gd = new GridData(32);
            gd.horizontalSpan = 3;
            Control editorControl = editor.getControl();
            if (editorControl instanceof CCombo) {
                if (!"macosx".equals(Platform.getOS())) {
                    gd.heightHint = 20;
                }
                gd.widthHint = 120;
            } else {
                gd.widthHint = 115;
            }
            editorControl.setLayoutData((Object)gd);
            if (editorControl instanceof CCombo) {
                ((CCombo)editorControl).addSelectionListener((SelectionListener)new SelectButtonListener(button));
            } else if (editorControl instanceof Text) {
                ((Text)editorControl).addModifyListener((ModifyListener)new SelectButtonListener(button));
                ((Text)editorControl).addVerifyListener((VerifyListener)new SelectButtonListener(button));
            } else if (editorControl instanceof StyledText) {
                ((StyledText)editorControl).getContent().addTextChangeListener((TextChangeListener)new SelectButtonListener(button));
            } else {
                editorControl.addFocusListener((FocusListener)new SelectButtonListener(button));
            }
            button.setData(KEY_ASSOCIATED_EDITOR, (Object)editor);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
        }
    }

    private void createRadioButtons(Composite buttonComposite, FormToolkit toolkit, TaskOperation selectedOperation) {
        List operations = this.getTaskData().getAttributeMapper().getTaskOperations(this.selectedOperationAttribute);
        if (operations.size() > 0) {
            this.operationButtons = new ArrayList<Button>();
            Button selectedButton = null;
            for (TaskOperation operation : operations) {
                Button button = toolkit.createButton(buttonComposite, operation.getLabel(), 16);
                button.setFont(TEXT_FONT);
                button.setData(KEY_OPERATION, (Object)operation);
                GridData radioData = new GridData(32);
                TaskAttribute associatedAttribute = this.getTaskData().getAttributeMapper().getAssoctiatedAttribute(operation);
                if (associatedAttribute != null) {
                    radioData.horizontalSpan = 1;
                    this.addAttribute(buttonComposite, toolkit, associatedAttribute, button);
                } else {
                    radioData.horizontalSpan = 4;
                }
                button.setLayoutData((Object)radioData);
                button.addSelectionListener((SelectionListener)new SelectButtonListener(button));
                this.operationButtons.add(button);
                if (!operation.equals((Object)selectedOperation)) continue;
                selectedButton = button;
            }
            if (selectedButton == null && !this.operationButtons.isEmpty()) {
                selectedButton = this.operationButtons.get(0);
            }
            this.setSelectedRadionButton(selectedButton, false);
        }
    }

    public boolean getAttachContext() {
        if (this.attachContextButton == null || this.attachContextButton.isDisposed()) {
            return false;
        }
        return this.attachContextButton.getSelection();
    }

    public void setSubmitEnabled(boolean enabled) {
        if (this.submitButton != null && !this.submitButton.isDisposed()) {
            this.submitButton.setEnabled(enabled);
            if (enabled) {
                this.submitButton.setToolTipText(MessageFormat.format(Messages.TaskEditorActionPart_Submit_to_X, this.getTaskEditorPage().getTaskRepository().getRepositoryUrl()));
            }
        }
    }

    private void setSelectedRadionButton(Button selectedButton, boolean updateModel) {
        if (selectedButton.getSelection()) {
            return;
        }
        selectedButton.setSelection(true);
        for (Button button : this.operationButtons) {
            if (button == selectedButton) continue;
            button.setSelection(false);
        }
        if (updateModel) {
            TaskOperation taskOperation = (TaskOperation)selectedButton.getData(KEY_OPERATION);
            this.getTaskData().getAttributeMapper().setTaskOperation(this.selectedOperationAttribute, taskOperation);
            this.getModel().attributeChanged(this.selectedOperationAttribute);
            AbstractAttributeEditor editor = (AbstractAttributeEditor)selectedButton.getData(KEY_ASSOCIATED_EDITOR);
            if (editor instanceof SingleSelectionAttributeEditor) {
                ((SingleSelectionAttributeEditor)editor).selectDefaultValue();
            }
        }
    }

    public class SelectButtonListener
    implements ModifyListener,
    VerifyListener,
    SelectionListener,
    FocusListener,
    TextChangeListener {
        private final Button button;

        public SelectButtonListener(Button button) {
            this.button = button;
        }

        public void modifyText(ModifyEvent e) {
            this.selected();
        }

        public void verifyText(VerifyEvent e) {
            this.selected();
        }

        public void widgetSelected(SelectionEvent e) {
            this.selected();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.selected();
        }

        public void focusGained(FocusEvent event) {
            this.selected();
        }

        public void focusLost(FocusEvent e) {
        }

        public void textChanged(TextChangedEvent event) {
            this.selected();
        }

        public void textSet(TextChangedEvent event) {
            this.selected();
        }

        public void textChanging(TextChangingEvent event) {
        }

        private void selected() {
            TaskEditorActionPart.this.setSelectedRadionButton(this.button, true);
        }
    }
}

