/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import org.eclipse.equinox.p2.internal.repository.comparator.Annotation;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPool;

public class RuntimeVisibleAnnotationsAttribute
extends ClassFileAttribute {
    private static final Annotation[] NO_ENTRIES = new Annotation[0];
    private int annotationsNumber;
    private Annotation[] annotations;

    public RuntimeVisibleAnnotationsAttribute(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.annotationsNumber = length = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.annotations = new Annotation[length];
            int i = 0;
            while (i < length) {
                Annotation annotation;
                this.annotations[i] = annotation = new Annotation(classFileBytes, constantPool, offset + readOffset);
                readOffset += annotation.sizeInBytes();
                ++i;
            }
        } else {
            this.annotations = NO_ENTRIES;
        }
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public int getAnnotationsNumber() {
        return this.annotationsNumber;
    }
}

