/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.ILiveHelpAction;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BookmarkManager;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.base.HelpDisplay;
import org.eclipse.help.internal.base.HelpProvider;
import org.eclipse.help.internal.base.util.IErrorUtil;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.help.internal.search.LocalSearchManager;
import org.eclipse.help.internal.search.SearchManager;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.help.internal.workingset.WorkingSetManager;
import org.osgi.framework.Bundle;

public final class BaseHelpSystem {
    private static final BaseHelpSystem instance = new BaseHelpSystem();
    public static final String BOOKMARKS = "bookmarks";
    public static final String WORKING_SETS = "workingSets";
    public static final String WORKING_SET = "workingSet";
    public static final int MODE_WORKBENCH = 0;
    public static final int MODE_INFOCENTER = 1;
    public static final int MODE_STANDALONE = 2;
    private int mode = 0;
    private SearchManager searchManager;
    private WorkingSetManager workingSetManager;
    private BookmarkManager bookmarkManager;
    private boolean webappStarted = false;
    private boolean webappRunning = false;
    private IErrorUtil defaultErrorMessenger;
    private IBrowser browser;
    private IBrowser internalBrowser;
    private HelpDisplay helpDisplay = null;
    static /* synthetic */ Class class$0;

    private BaseHelpSystem() {
    }

    public static BaseHelpSystem getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchManager getSearchManager() {
        if (BaseHelpSystem.getInstance().searchManager != null) return BaseHelpSystem.getInstance().searchManager;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.internal.base.BaseHelpSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (BaseHelpSystem.getInstance().searchManager != null) return BaseHelpSystem.getInstance().searchManager;
            BaseHelpSystem.getInstance().searchManager = new SearchManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return BaseHelpSystem.getInstance().searchManager;
        }
    }

    public static LocalSearchManager getLocalSearchManager() {
        return BaseHelpSystem.getSearchManager().getLocalSearchManager();
    }

    public static synchronized WorkingSetManager getWorkingSetManager() {
        if (BaseHelpSystem.getInstance().workingSetManager == null) {
            BaseHelpSystem.getInstance().workingSetManager = new WorkingSetManager();
        }
        return BaseHelpSystem.getInstance().workingSetManager;
    }

    public static synchronized BookmarkManager getBookmarkManager() {
        if (BaseHelpSystem.getInstance().bookmarkManager == null) {
            BaseHelpSystem.getInstance().bookmarkManager = new BookmarkManager();
        }
        return BaseHelpSystem.getInstance().bookmarkManager;
    }

    public synchronized void setBrowserInstance(IBrowser browser) {
        this.browser = browser;
    }

    public static synchronized IBrowser getHelpBrowser(boolean forceExternal) {
        if (!forceExternal && !BrowserManager.getInstance().isAlwaysUseExternal()) {
            if (BaseHelpSystem.getInstance().internalBrowser == null) {
                BaseHelpSystem.getInstance().internalBrowser = BrowserManager.getInstance().createBrowser(false);
            }
            return BaseHelpSystem.getInstance().internalBrowser;
        }
        if (BaseHelpSystem.getInstance().browser == null) {
            BaseHelpSystem.getInstance().browser = BrowserManager.getInstance().createBrowser(true);
        }
        return BaseHelpSystem.getInstance().browser;
    }

    public static synchronized HelpDisplay getHelpDisplay() {
        if (BaseHelpSystem.getInstance().helpDisplay == null) {
            BaseHelpSystem.getInstance().helpDisplay = new HelpDisplay();
        }
        return BaseHelpSystem.getInstance().helpDisplay;
    }

    public static void shutdown() throws CoreException {
        if (BaseHelpSystem.getInstance().bookmarkManager != null) {
            BaseHelpSystem.getInstance().bookmarkManager.close();
            BaseHelpSystem.getInstance().bookmarkManager = null;
        }
        if (BaseHelpSystem.getInstance().searchManager != null) {
            BaseHelpSystem.getInstance().searchManager.close();
            BaseHelpSystem.getInstance().searchManager = null;
        }
        if (BaseHelpSystem.getInstance().webappStarted) {
            WebappManager.stop("help");
        }
    }

    public static void startup() {
        try {
            BaseHelpSystem.setDefaultErrorUtil(new IErrorUtil(){

                public void displayError(String msg) {
                    System.out.println(msg);
                }

                public void displayError(String msg, Thread uiThread) {
                    System.out.println(msg);
                }
            });
        }
        catch (Exception e) {
            HelpBasePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.help.base", 0, "Error launching help.", (Throwable)e));
        }
        HelpPlugin.getDefault().setHelpProvider((HelpPlugin.IHelpProvider)new HelpProvider());
    }

    public static boolean ensureWebappRunning() {
        if (!BaseHelpSystem.getInstance().webappStarted) {
            BaseHelpSystem.getInstance().webappStarted = true;
            try {
                WebappManager.start("help");
            }
            catch (Exception e) {
                HelpBasePlugin.logError(HelpBaseResources.HelpWebappNotStarted, e);
                return false;
            }
            BaseHelpSystem.getInstance().webappRunning = true;
        }
        return BaseHelpSystem.getInstance().webappRunning;
    }

    public static URL resolve(String href, boolean documentOnly) {
        String url = null;
        if (href == null || href.indexOf("://") != -1) {
            url = href;
        } else {
            BaseHelpSystem.ensureWebappRunning();
            String base = BaseHelpSystem.getBase(documentOnly);
            url = href.startsWith("/") ? String.valueOf(base) + href : String.valueOf(base) + "/" + href;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL resolve(String href, String servlet) {
        String url = null;
        if (href == null || href.indexOf("://") != -1) {
            url = href;
        } else {
            BaseHelpSystem.ensureWebappRunning();
            String base = BaseHelpSystem.getBase(servlet);
            url = href.startsWith("/") ? String.valueOf(base) + href : String.valueOf(base) + "/" + href;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String unresolve(URL url) {
        return BaseHelpSystem.unresolve(url.toString());
    }

    public static String unresolve(String href) {
        String[] baseVariants = new String[]{BaseHelpSystem.getBase("/help/topic"), BaseHelpSystem.getBase("/help/nftopic"), BaseHelpSystem.getBase("/help/ntopic"), BaseHelpSystem.getBase("/help/rtopic")};
        int i = 0;
        while (i < baseVariants.length) {
            if (href.startsWith(baseVariants[i])) {
                return href.substring(baseVariants[i].length());
            }
            ++i;
        }
        return href;
    }

    private static String getBase(boolean documentOnly) {
        String servlet = documentOnly ? "/help/nftopic" : "/help/topic";
        return BaseHelpSystem.getBase(servlet);
    }

    private static String getBase(String servlet) {
        return "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + servlet;
    }

    public static int getMode() {
        return BaseHelpSystem.getInstance().mode;
    }

    public static void setMode(int mode) {
        BaseHelpSystem.getInstance().mode = mode;
        HelpSystem.setShared((mode == 1 ? 1 : 0) != 0);
    }

    public static void setDefaultErrorUtil(IErrorUtil em) {
        BaseHelpSystem.getInstance().defaultErrorMessenger = em;
    }

    public static IErrorUtil getDefaultErrorUtil() {
        return BaseHelpSystem.getInstance().defaultErrorMessenger;
    }

    public static String getProductName() {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return "";
        }
        String name = product.getName();
        return name == null ? "" : name;
    }

    public static void runLiveHelp(String pluginID, String className, String arg) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle == null) {
            return;
        }
        try {
            Class c = bundle.loadClass(className);
            Object o = c.newInstance();
            if (o != null && o instanceof ILiveHelpAction) {
                ILiveHelpAction helpExt = (ILiveHelpAction)o;
                if (arg != null) {
                    helpExt.setInitializationString(arg);
                }
                Thread runnableLiveHelp = new Thread((Runnable)helpExt);
                runnableLiveHelp.setDaemon(true);
                runnableLiveHelp.start();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Exception exception) {}
    }

    public static void checkMode() {
        if (!BaseHelpSystem.getInstance().webappStarted) {
            BaseHelpSystem.setMode(1);
        }
    }
}

