/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelContentProviderTarget;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelLabelProviderTarget;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.ModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.VirtualItem;
import org.eclipse.debug.internal.ui.viewers.model.VirtualTree;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

public class InternalVirtualTreeModelViewer
extends Viewer
implements VirtualTree.IVirtualItemListener,
ITreeModelViewer,
ITreeModelContentProviderTarget,
ITreeModelLabelProviderTarget {
    private static final String VISIBLE_COLUMNS = "VISIBLE_COLUMNS";
    private static final String SHOW_COLUMNS = "SHOW_COLUMNS";
    private static final String SIZE = "SIZE";
    private static final String COLUMN = "COLUMN";
    private static final String TREE_PATH_KEY = "TREE_PATH_KEY";
    private Display fDisplay;
    private IPresentationContext fContext;
    private Object fInput;
    private VirtualTree fTree;
    private Map fItemsMap = new HashMap();
    private boolean fNotifyUnmap = true;
    private TreeModelLabelProvider fLabelProvider;
    private TreeModelContentProvider fContentProvider;
    private boolean fPreservingSelecction;
    private boolean fRestoreSelection;
    private int fAutoExpandToLevel = 0;
    private IColumnPresentation fColumnPresentation = null;
    private Map fVisibleColumns = new HashMap();
    private Map fShowColumns = new HashMap();
    public static int ALL_LEVELS = -1;
    private static final VirtualItem[] EMPTY_ITEMS_ARRAY = new VirtualItem[0];
    private static ViewerFilter[] EMPTY_FILTER_ARRAY = new ViewerFilter[0];

    public InternalVirtualTreeModelViewer(Display display, int style, IPresentationContext context) {
        this.fDisplay = display;
        this.fContext = context;
        this.fTree = new VirtualTree(style);
        this.fTree.addItemListener(this);
        this.fContentProvider = new TreeModelContentProvider();
        this.fLabelProvider = new TreeModelLabelProvider(this);
        if ((style & 8) != 0) {
            this.getContentProvider().setSuppressModelControlDeltas(true);
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    public Control getControl() {
        return null;
    }

    public Display getDisplay() {
        return this.fDisplay;
    }

    public void setInput(Object input) {
        Object oldInput = this.fInput;
        this.getContentProvider().inputChanged(this, oldInput, input);
        this.fInput = input;
        this.fTree.setData(this.fInput);
        this.inputChanged(oldInput, this.fInput);
        this.refresh();
    }

    public void replace(Object parentElementOrTreePath, int index, Object element) {
        VirtualItem[] itemsToDisassociate;
        VirtualItem[] selectedItems = this.fTree.getSelection();
        TreeSelection selection = (TreeSelection)this.getSelection();
        if (parentElementOrTreePath instanceof TreePath) {
            TreePath elementPath = ((TreePath)parentElementOrTreePath).createChildPath(element);
            itemsToDisassociate = this.findItems(elementPath);
        } else {
            itemsToDisassociate = this.findItems(element);
        }
        VirtualItem[] parentItems = this.findItems(parentElementOrTreePath);
        int i = 0;
        while (i < parentItems.length) {
            VirtualItem parentItem = parentItems[i];
            if (index < parentItem.getItemCount()) {
                VirtualItem item = parentItem.getItem(new VirtualItem.Index(index));
                selection = this.adjustSelectionForReplace(selectedItems, selection, item, element, parentItem.getData());
                int j = 0;
                while (j < itemsToDisassociate.length) {
                    VirtualItem itemToDisassociate = itemsToDisassociate[j];
                    if (itemToDisassociate != item && itemsToDisassociate[j].getParent() == parentItem) {
                        this.disassociate(itemToDisassociate);
                        itemToDisassociate.getParent().clear(itemToDisassociate.getIndex());
                    }
                    ++j;
                }
                this.associate(element, item);
                this.doUpdate(item);
            }
            ++i;
        }
        if (!this.fPreservingSelecction) {
            this.internalSetSelection((ISelection)selection, false);
            ISelection newSelection = this.getSelection();
            if (!newSelection.equals(selection)) {
                this.handleInvalidSelection((ISelection)selection, newSelection);
            }
        }
        this.fTree.validate();
    }

    VirtualTree getTree() {
        return this.fTree;
    }

    public void insert(Object parentOrTreePath, Object element, int position) {
        VirtualItem parentItem;
        if (parentOrTreePath instanceof TreePath && (parentItem = this.findItem((TreePath)parentOrTreePath)) != null) {
            VirtualItem item = parentItem.addItem(position);
            item.setData(element);
        }
        this.fTree.validate();
    }

    public void remove(final Object parentOrTreePath, final int index) {
        final LinkedList<TreePath> oldSelection = new LinkedList<TreePath>(Arrays.asList(((TreeSelection)this.getSelection()).getPaths()));
        this.preservingSelection(new Runnable(){

            public void run() {
                TreePath removedPath = null;
                VirtualItem[] parentItems = InternalVirtualTreeModelViewer.this.findItems(parentOrTreePath);
                int i = 0;
                while (i < parentItems.length) {
                    VirtualItem parentItem = parentItems[i];
                    if (!parentItem.isDisposed() && index < parentItem.getItemCount()) {
                        VirtualItem item = parentItem.getItem(new VirtualItem.Index(index));
                        if (item.getData() != null) {
                            removedPath = InternalVirtualTreeModelViewer.this.getTreePathFromItem(item);
                            InternalVirtualTreeModelViewer.this.disassociate(item);
                        }
                        parentItem.remove(item.getIndex());
                    }
                    ++i;
                }
                if (removedPath != null) {
                    boolean removed = false;
                    Iterator it = oldSelection.iterator();
                    while (it.hasNext()) {
                        TreePath path = (TreePath)it.next();
                        if (!path.startsWith(removedPath, null)) continue;
                        it.remove();
                        removed = true;
                    }
                    if (removed) {
                        InternalVirtualTreeModelViewer.this.setSelection((ISelection)new TreeSelection(oldSelection.toArray(new TreePath[oldSelection.size()])), false);
                    }
                }
            }
        });
    }

    public void remove(Object elementOrPath) {
        if (elementOrPath.equals(this.getInput()) || TreePath.EMPTY.equals(elementOrPath)) {
            this.setInput(null);
            return;
        }
        VirtualItem[] items = this.findItems(elementOrPath);
        if (items.length > 0) {
            int j = 0;
            while (j < items.length) {
                this.disassociate(items[j]);
                items[j].getParent().remove(items[j].getIndex());
                ++j;
            }
        }
    }

    private TreeSelection adjustSelectionForReplace(VirtualItem[] selectedItems, TreeSelection selection, VirtualItem item, Object element, Object parentElement) {
        if (item.getData() != null || selectedItems.length == selection.size() || parentElement == null) {
            return selection;
        }
        int i = 0;
        while (i < selectedItems.length) {
            if (item == selectedItems[i]) {
                TreePath[] originalPaths = selection.getPaths();
                int length = originalPaths.length;
                TreePath[] paths = new TreePath[length + 1];
                System.arraycopy(originalPaths, 0, paths, 0, length);
                item.setData(element);
                paths[length] = this.getTreePathFromItem(item);
                item.setData(null);
                return new TreeSelection(paths, selection.getElementComparer());
            }
            ++i;
        }
        return selection;
    }

    public void reveal(TreePath path, int index) {
    }

    public int findElementIndex(TreePath parentPath, Object element) {
        VirtualItem item;
        VirtualItem parentItem = this.findItem(parentPath);
        if (parentItem != null && (item = parentItem.findItem(element)) != null) {
            return item.getIndex().intValue();
        }
        return -1;
    }

    private ITreeModelLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    private ITreeModelContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    public void refresh() {
        this.refresh(this.fTree);
        this.getTree().validate();
    }

    public void refresh(Object element) {
        VirtualItem[] items = this.findItems(element);
        int i = 0;
        while (i < items.length) {
            this.refresh(items[i]);
            this.getTree().validate(items[i]);
            ++i;
        }
    }

    private void refresh(VirtualItem item) {
        item.setNeedsCountUpdate();
        item.setNeedsLabelUpdate();
        if (item.getParent() == null) {
            this.virtualLazyUpdateChildCount(item);
        } else if (item.getExpanded()) {
            this.virtualLazyUpdateChildCount(item);
        } else if (item.getData() != null) {
            this.virtualLazyUpdateHasChildren(item);
        }
        VirtualItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setNeedsDataUpdate();
            this.refresh(items[i]);
            ++i;
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.resetColumns(input);
    }

    public int getAutoExpandLevel() {
        return this.fAutoExpandToLevel;
    }

    public void setAutoExpandLevel(int level) {
        this.fAutoExpandToLevel = level;
    }

    private VirtualItem findItem(TreePath path) {
        VirtualItem item = this.fTree;
        if (path.getSegmentCount() == 0) {
            return this.fTree;
        }
        int i = 0;
        while (item != null && i < path.getSegmentCount()) {
            Object segment = path.getSegment(i);
            item = item.findItem(segment);
            ++i;
        }
        return item;
    }

    private VirtualItem[] findItems(Object elementOrTreePath) {
        if (elementOrTreePath instanceof TreePath) {
            VirtualItem[] virtualItemArray;
            VirtualItem item = this.findItem((TreePath)elementOrTreePath);
            if (item == null) {
                virtualItemArray = EMPTY_ITEMS_ARRAY;
            } else {
                VirtualItem[] virtualItemArray2 = new VirtualItem[1];
                virtualItemArray = virtualItemArray2;
                virtualItemArray2[0] = item;
            }
            return virtualItemArray;
        }
        if (this.getInput().equals(elementOrTreePath)) {
            return new VirtualItem[]{this.getTree()};
        }
        List itemsList = (List)this.fItemsMap.get(elementOrTreePath);
        if (itemsList == null) {
            return EMPTY_ITEMS_ARRAY;
        }
        return itemsList.toArray(new VirtualItem[itemsList.size()]);
    }

    public void setElementData(TreePath path, int numColumns, String[] labels, ImageDescriptor[] images, FontData[] fontDatas, RGB[] foregrounds, RGB[] backgrounds) {
        VirtualItem item = this.findItem(path);
        if (item != null) {
            item.setData(VirtualItem.LABEL_KEY, labels);
            item.setData(VirtualItem.IMAGE_KEY, images);
            item.setData(VirtualItem.FOREGROUND_KEY, foregrounds);
            item.setData(VirtualItem.BACKGROUND_KEY, backgrounds);
            item.setData(VirtualItem.FONT_KEY, fontDatas);
        }
    }

    public void setChildCount(final Object elementOrTreePath, final int count) {
        this.preservingSelection(new Runnable(){

            public void run() {
                VirtualItem[] items = InternalVirtualTreeModelViewer.this.findItems(elementOrTreePath);
                int i = 0;
                while (i < items.length) {
                    VirtualItem[] children = items[i].getItems();
                    int j = 0;
                    while (j < children.length) {
                        if (children[j].getData() != null && children[j].getIndex().intValue() >= count) {
                            InternalVirtualTreeModelViewer.this.disassociate(children[j]);
                        }
                        ++j;
                    }
                    items[i].setItemCount(count);
                    ++i;
                }
            }
        });
        this.fTree.validate();
    }

    public void setHasChildren(final Object elementOrTreePath, final boolean hasChildren) {
        this.preservingSelection(new Runnable(){

            public void run() {
                VirtualItem[] items = InternalVirtualTreeModelViewer.this.findItems(elementOrTreePath);
                int i = 0;
                while (i < items.length) {
                    VirtualItem item = items[i];
                    if (!hasChildren) {
                        VirtualItem[] children = item.getItems();
                        int j = 0;
                        while (j < children.length) {
                            if (children[j].getData() != null) {
                                InternalVirtualTreeModelViewer.this.disassociate(children[j]);
                            }
                            ++j;
                        }
                    }
                    item.setHasItems(hasChildren);
                    if (hasChildren) {
                        if (!item.getExpanded()) {
                            item.setItemCount(-1);
                        } else if (item.needsCountUpdate()) {
                            InternalVirtualTreeModelViewer.this.virtualLazyUpdateChildCount(item);
                        }
                    }
                    ++i;
                }
            }
        });
    }

    private void virtualLazyUpdateHasChildren(VirtualItem item) {
        TreePath treePath = this.getTreePathFromItem(item);
        this.getContentProvider().updateHasChildren(treePath);
    }

    private void virtualLazyUpdateChildCount(VirtualItem item) {
        item.clearNeedsCountUpdate();
        this.getContentProvider().updateChildCount(this.getTreePathFromItem(item), item.getItemCount());
    }

    private void virtualLazyUpdateData(VirtualItem item) {
        item.clearNeedsDataUpdate();
        this.getContentProvider().updateElement(this.getTreePathFromItem(item.getParent()), item.getIndex().intValue());
    }

    private void virtualLazyUpdateLabel(VirtualItem item) {
        item.clearNeedsLabelUpdate();
        if (!this.getLabelProvider().update(this.getTreePathFromItem(item)) && item.getData() instanceof String) {
            item.setData(VirtualItem.LABEL_KEY, new String[]{(String)item.getData()});
        }
    }

    private TreePath getTreePathFromItem(VirtualItem item) {
        LinkedList<Object> segments = new LinkedList<Object>();
        while (item.getParent() != null) {
            segments.add(0, item.getData());
            item = item.getParent();
        }
        return new TreePath(segments.toArray());
    }

    private void unmapElement(Object element, VirtualItem item) {
        List itemsList;
        ITreeModelContentProvider provider;
        if (this.fNotifyUnmap && (provider = this.getContentProvider()) instanceof ModelContentProvider) {
            ((ModelContentProvider)((Object)provider)).unmapPath((TreePath)item.getData(TREE_PATH_KEY));
        }
        if ((itemsList = (List)this.fItemsMap.get(element)) != null) {
            itemsList.remove(item);
            if (itemsList.isEmpty()) {
                this.fItemsMap.remove(element);
            }
        }
    }

    private void mapElement(Object element, VirtualItem item) {
        ArrayList<VirtualItem> itemsList = (ArrayList<VirtualItem>)this.fItemsMap.remove(element);
        if (itemsList == null) {
            itemsList = new ArrayList<VirtualItem>(1);
        }
        if (!itemsList.contains(item)) {
            itemsList.add(item);
        }
        this.fItemsMap.put(element, itemsList);
        item.setData(TREE_PATH_KEY, this.getTreePathFromItem(item));
    }

    public void revealed(VirtualItem item) {
        if (item.needsDataUpdate()) {
            this.virtualLazyUpdateData(item);
        } else if (item.getData() != null) {
            if (item.needsLabelUpdate()) {
                this.virtualLazyUpdateLabel(item);
            }
            if (item.getExpanded() && item.hasItems() && item.needsCountUpdate()) {
                this.virtualLazyUpdateChildCount(item);
            }
        }
    }

    public void disposed(VirtualItem item) {
        Object data;
        if (!this.fTree.isDisposed() && (data = item.getData()) != null) {
            this.unmapElement(data, item);
        }
    }

    private void associate(Object element, VirtualItem item) {
        Object data = item.getData();
        if (data != null && data != element && data.equals(element)) {
            try {
                this.fNotifyUnmap = false;
                this.doAssociate(element, item);
            }
            finally {
                this.fNotifyUnmap = true;
            }
        } else {
            this.doAssociate(element, item);
        }
    }

    private void doAssociate(Object element, VirtualItem item) {
        Object data = item.getData();
        if (data != null && data != element && data.equals(element)) {
            this.unmapElement(data, item);
            item.setData(element);
            this.mapElement(element, item);
        } else {
            if (data != element) {
                if (data != null) {
                    this.unmapElement(element, item);
                    this.disassociate(item);
                }
                item.setData(element);
            }
            this.mapElement(element, item);
        }
    }

    private void disassociate(VirtualItem item) {
        this.unmapElement(item.getData(), item);
        item.setData(null);
        VirtualItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() != null) {
                this.disassociate(items[i]);
            }
            ++i;
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.setSelection(selection, reveal, false);
    }

    public void setSelection(ISelection selection, boolean reveal, boolean force) {
        if (!force && !this.overrideSelection(this.getSelection(), selection)) {
            return;
        }
        if (!this.fPreservingSelecction) {
            this.internalSetSelection(selection, reveal);
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        } else {
            this.fRestoreSelection = false;
            this.internalSetSelection(selection, reveal);
        }
    }

    private void internalSetSelection(ISelection selection, boolean reveal) {
        if (selection instanceof ITreeSelection) {
            TreePath[] paths = ((ITreeSelection)selection).getPaths();
            ArrayList<VirtualItem> newSelection = new ArrayList<VirtualItem>(paths.length);
            int i = 0;
            while (i < paths.length) {
                VirtualItem item = this.findItem(paths[i]);
                if (item != null) {
                    newSelection.add(item);
                }
                ++i;
            }
            this.fTree.setSelection(newSelection.toArray(new VirtualItem[newSelection.size()]));
            if (reveal && newSelection.size() > 0) {
                i = newSelection.size() - 1;
                while (i >= 0) {
                    this.fTree.showItem((VirtualItem)newSelection.get(i));
                    --i;
                }
            }
        } else {
            this.fTree.setSelection(EMPTY_ITEMS_ARRAY);
        }
        this.fTree.validate();
    }

    public void update(Object element) {
        VirtualItem[] items = this.findItems(element);
        int i = 0;
        while (i < items.length) {
            this.doUpdate(items[i]);
            ++i;
        }
    }

    public void doUpdate(VirtualItem item) {
        item.setNeedsLabelUpdate();
        this.fTree.validate(item);
    }

    public ISelection getSelection() {
        if (this.fTree.isDisposed()) {
            return TreeSelection.EMPTY;
        }
        VirtualItem[] items = this.fTree.getSelection();
        ArrayList<TreePath> list = new ArrayList<TreePath>(items.length);
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() != null) {
                list.add(this.getTreePathFromItem(items[i]));
            }
            ++i;
        }
        return new TreeSelection(list.toArray(new TreePath[list.size()]));
    }

    private void preservingSelection(Runnable updateCode) {
        ISelection oldSelection = null;
        try {
            oldSelection = this.getSelection();
            this.fRestoreSelection = true;
            this.fPreservingSelecction = true;
            updateCode.run();
        }
        finally {
            ISelection newSelection;
            this.fPreservingSelecction = false;
            if (this.fRestoreSelection) {
                this.internalSetSelection(oldSelection, false);
            }
            if (!(newSelection = this.getSelection()).equals(oldSelection)) {
                this.handleInvalidSelection(oldSelection, newSelection);
            }
        }
    }

    public void expandToLevel(Object elementOrTreePath, int level) {
        VirtualItem[] items = this.findItems(elementOrTreePath);
        if (items.length > 0) {
            this.expandToLevel(items[0], level);
        }
        this.fTree.validate();
    }

    public void setExpandedState(Object elementOrTreePath, boolean expanded) {
        VirtualItem[] items = this.findItems(elementOrTreePath);
        if (items.length > 0) {
            items[0].setExpanded(expanded);
        }
    }

    public boolean getExpandedState(Object elementOrTreePath) {
        VirtualItem[] items = this.findItems(elementOrTreePath);
        if (items.length > 0) {
            return items[0].getExpanded();
        }
        return false;
    }

    private void expandToLevel(VirtualItem item, int level) {
        if (level == ALL_LEVELS || level > 0) {
            if (!item.hasItems()) {
                return;
            }
            if (item.getItemCount() < 0) {
                this.virtualLazyUpdateChildCount(item);
                item.clearNeedsCountUpdate();
            }
            item.setExpanded(true);
            if (item.getData() == null) {
                this.virtualLazyUpdateData(item);
                return;
            }
            if (level == ALL_LEVELS || level > 1) {
                VirtualItem[] children = item.getItems();
                int newLevel = level == ALL_LEVELS ? ALL_LEVELS : level - 1;
                int i = 0;
                while (i < children.length) {
                    this.expandToLevel(children[i], newLevel);
                    ++i;
                }
            }
        }
    }

    private void handleInvalidSelection(ISelection selection, ISelection newSelection) {
        IModelSelectionPolicy selectionPolicy = ViewerAdapterService.getSelectionPolicy(selection, this.getPresentationContext());
        if (selectionPolicy != null) {
            while (!selection.equals(newSelection)) {
                ISelection temp = newSelection;
                if ((selection = selectionPolicy.replaceInvalidSelection(selection, newSelection)) == null) {
                    selection = TreeSelection.EMPTY;
                }
                if (temp.equals(selection)) break;
                this.internalSetSelection(selection, false);
                newSelection = this.getSelection();
            }
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, newSelection));
    }

    public boolean overrideSelection(ISelection current, ISelection candidate) {
        IModelSelectionPolicy selectionPolicy = ViewerAdapterService.getSelectionPolicy(current, this.getPresentationContext());
        if (selectionPolicy == null) {
            return true;
        }
        if (selectionPolicy.contains(candidate, this.getPresentationContext())) {
            return selectionPolicy.overrides(current, candidate, this.getPresentationContext());
        }
        return !selectionPolicy.isSticky(current, this.getPresentationContext());
    }

    public ViewerFilter[] getFilters() {
        return EMPTY_FILTER_ARRAY;
    }

    public void dispose() {
        if (this.fColumnPresentation != null) {
            this.fColumnPresentation.dispose();
        }
        this.fContext.dispose();
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
            this.fContentProvider = null;
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        this.fTree.removeItemListener(this);
        this.fTree.dispose();
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    private void resetColumns(Object input) {
        if (input != null) {
            IColumnPresentationFactory factory = ViewerAdapterService.getColumnPresentationFactory(input);
            PresentationContext context = (PresentationContext)this.getPresentationContext();
            String type = null;
            if (factory != null) {
                type = factory.getColumnPresentationId(context, input);
            }
            if (type != null) {
                if (this.fColumnPresentation != null && !this.fColumnPresentation.getId().equals(type)) {
                    this.fColumnPresentation.dispose();
                    this.fColumnPresentation = null;
                }
                if (this.fColumnPresentation == null) {
                    this.fColumnPresentation = factory.createColumnPresentation(context, input);
                    if (this.fColumnPresentation != null) {
                        this.fColumnPresentation.init(context);
                        this.configureColumns();
                    }
                }
            } else if (this.fColumnPresentation != null) {
                this.fColumnPresentation.dispose();
                this.fColumnPresentation = null;
                this.configureColumns();
            }
        }
    }

    protected void configureColumns() {
        if (this.fColumnPresentation != null) {
            IColumnPresentation build = null;
            if (this.isShowColumns(this.fColumnPresentation.getId())) {
                build = this.fColumnPresentation;
            }
            this.buildColumns(build);
        } else {
            this.buildColumns(null);
        }
    }

    public void setShowColumns(boolean show) {
        if (show) {
            if (!this.isShowColumns()) {
                this.fShowColumns.remove(this.fColumnPresentation.getId());
            }
        } else if (this.isShowColumns()) {
            this.fShowColumns.put(this.fColumnPresentation.getId(), Boolean.FALSE);
        }
        this.refreshColumns();
    }

    protected void refreshColumns() {
        this.configureColumns();
        this.refresh();
    }

    public boolean isShowColumns() {
        if (this.fColumnPresentation != null) {
            return this.isShowColumns(this.fColumnPresentation.getId());
        }
        return false;
    }

    public boolean canToggleColumns() {
        return this.fColumnPresentation != null && this.fColumnPresentation.isOptional();
    }

    protected boolean isShowColumns(String columnPresentationId) {
        Boolean bool = (Boolean)this.fShowColumns.get(columnPresentationId);
        if (bool == null) {
            return true;
        }
        return bool;
    }

    protected void buildColumns(IColumnPresentation presentation) {
        PresentationContext presentationContext = (PresentationContext)this.getPresentationContext();
        if (presentation != null) {
            presentationContext.setColumns(this.getVisibleColumns());
        } else {
            presentationContext.setColumns(null);
        }
    }

    public String[] getVisibleColumns() {
        IColumnPresentation presentation;
        if (this.isShowColumns() && (presentation = this.getColumnPresentation()) != null) {
            String[] columns = (String[])this.fVisibleColumns.get(presentation.getId());
            if (columns == null) {
                return presentation.getInitialColumns();
            }
            return columns;
        }
        return null;
    }

    public void setVisibleColumns(String[] ids) {
        IColumnPresentation presentation;
        if (ids != null && ids.length == 0) {
            ids = null;
        }
        if ((presentation = this.getColumnPresentation()) != null) {
            this.fVisibleColumns.remove(presentation.getId());
            if (ids != null) {
                String[] columns = presentation.getInitialColumns();
                if (columns.length == ids.length) {
                    int i = 0;
                    while (i < columns.length) {
                        if (!ids[i].equals(columns[i])) {
                            this.fVisibleColumns.put(presentation.getId(), ids);
                            break;
                        }
                        ++i;
                    }
                } else {
                    this.fVisibleColumns.put(presentation.getId(), ids);
                }
            }
            PresentationContext presentationContext = (PresentationContext)this.getPresentationContext();
            presentationContext.setColumns(this.getVisibleColumns());
            this.refreshColumns();
        }
    }

    public IColumnPresentation getColumnPresentation() {
        return this.fColumnPresentation;
    }

    public void saveState(IMemento memento) {
        IPresentationContext context;
        Map.Entry entry;
        Iterator iterator;
        if (!this.fShowColumns.isEmpty()) {
            iterator = this.fShowColumns.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                IMemento sizes = memento.createChild(SHOW_COLUMNS, (String)entry.getKey());
                sizes.putString(SHOW_COLUMNS, ((Boolean)entry.getValue()).toString());
            }
        }
        if (!this.fVisibleColumns.isEmpty()) {
            iterator = this.fVisibleColumns.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                String id = (String)entry.getKey();
                IMemento visible = memento.createChild(VISIBLE_COLUMNS, id);
                String[] columns = (String[])entry.getValue();
                visible.putInteger(SIZE, columns.length);
                int i = 0;
                while (i < columns.length) {
                    visible.putString(COLUMN + Integer.toString(i), columns[i]);
                    ++i;
                }
            }
        }
        if ((context = this.getPresentationContext()) instanceof PresentationContext) {
            PresentationContext pc = (PresentationContext)context;
            pc.saveProperites(memento);
        }
    }

    public void initState(IMemento memento) {
        String id;
        IMemento child;
        IMemento[] mementos = memento.getChildren(SHOW_COLUMNS);
        int i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            Boolean bool = Boolean.valueOf(child.getString(SHOW_COLUMNS));
            if (!bool.booleanValue()) {
                this.fShowColumns.put(id, bool);
            }
            ++i;
        }
        mementos = memento.getChildren(VISIBLE_COLUMNS);
        i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            Integer integer = child.getInteger(SIZE);
            if (integer != null) {
                int length = integer;
                String[] columns = new String[length];
                int j = 0;
                while (j < length) {
                    columns[j] = child.getString(COLUMN + Integer.toString(j));
                    ++j;
                }
                this.fVisibleColumns.put(id, columns);
            }
            ++i;
        }
        IPresentationContext context = this.getPresentationContext();
        if (context instanceof PresentationContext) {
            PresentationContext pc = (PresentationContext)context;
            pc.initProperties(memento);
        }
    }

    public void addViewerUpdateListener(IViewerUpdateListener listener) {
        ((ModelContentProvider)((Object)this.getContentProvider())).addViewerUpdateListener(listener);
    }

    public void removeViewerUpdateListener(IViewerUpdateListener listener) {
        ITreeModelContentProvider cp = this.getContentProvider();
        if (cp != null) {
            cp.removeViewerUpdateListener(listener);
        }
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        ((ModelContentProvider)((Object)this.getContentProvider())).addModelChangedListener(listener);
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        ITreeModelContentProvider cp = this.getContentProvider();
        if (cp != null) {
            cp.removeModelChangedListener(listener);
        }
    }

    public void addLabelUpdateListener(ILabelUpdateListener listener) {
        this.getLabelProvider().addLabelUpdateListener(listener);
    }

    public void removeLabelUpdateListener(ILabelUpdateListener listener) {
        this.getLabelProvider().removeLabelUpdateListener(listener);
    }

    public void autoExpand(TreePath elementPath) {
        int level = this.getAutoExpandLevel();
        if (!(level <= 0 && level != -1 || level != -1 && level < elementPath.getSegmentCount())) {
            this.expandToLevel(elementPath, 1);
        }
    }

    public int getChildCount(TreePath path) {
        VirtualItem[] items = this.findItems(path);
        if (items.length > 0) {
            return items[0].getItemCount();
        }
        return -1;
    }

    public Object getChildElement(TreePath path, int index) {
        VirtualItem[] items = this.findItems(path);
        if (items.length > 0 && index < items[0].getItemCount()) {
            return items[0].getItem(new VirtualItem.Index(index)).getData();
        }
        return null;
    }

    public TreePath getTopElementPath() {
        return null;
    }

    public void saveElementState(TreePath path, ModelDelta delta) {
        VirtualTree tree = this.getTree();
        VirtualItem[] selection = tree.getSelection();
        HashSet<VirtualItem> set = new HashSet<VirtualItem>();
        int i = 0;
        while (i < selection.length) {
            set.add(selection[i]);
            ++i;
        }
        VirtualItem[] items = null;
        VirtualItem parent = this.findItem(path);
        if (parent != null) {
            delta.setChildCount(((ModelContentProvider)((Object)this.getContentProvider())).viewToModelCount(path, parent.getItemCount()));
            if (parent.getExpanded()) {
                delta.setFlags(delta.getFlags() | 0x100000);
            }
            if (set.contains(parent)) {
                delta.setFlags(delta.getFlags() | 0x200000);
            }
            items = parent.getItems();
            int i2 = 0;
            while (i2 < items.length) {
                this.doSaveElementState(path, delta, items[i2], set);
                ++i2;
            }
        }
    }

    private void doSaveElementState(TreePath parentPath, ModelDelta delta, VirtualItem item, Collection set) {
        Object element = item.getData();
        if (element != null) {
            boolean expanded = item.getExpanded();
            boolean selected = set.contains(item);
            if (expanded || selected) {
                int flags = 0;
                if (expanded) {
                    flags |= 0x100000;
                }
                if (selected) {
                    flags |= 0x200000;
                }
                int modelIndex = ((ModelContentProvider)((Object)this.getContentProvider())).viewToModelIndex(parentPath, item.getIndex().intValue());
                TreePath elementPath = parentPath.createChildPath(element);
                int numChildren = ((ModelContentProvider)((Object)this.getContentProvider())).viewToModelCount(elementPath, item.getItemCount());
                ModelDelta childDelta = delta.addNode(element, modelIndex, flags, numChildren);
                if (expanded) {
                    VirtualItem[] items = item.getItems();
                    int i = 0;
                    while (i < items.length) {
                        this.doSaveElementState(elementPath, childDelta, items[i], set);
                        ++i;
                    }
                }
            }
        }
    }

    public void updateViewer(IModelDelta delta) {
        ((ModelContentProvider)((Object)this.getContentProvider())).updateNodes(new IModelDelta[]{delta}, true);
    }

    public ViewerLabel getElementLabel(TreePath path, String columnId) {
        VirtualItem item;
        if (path.getSegmentCount() == 0) {
            return null;
        }
        int columnIdx = -1;
        String[] visibleColumns = this.getVisibleColumns();
        if (columnId != null && visibleColumns != null) {
            int i = 0;
            i = 0;
            while (i < visibleColumns.length) {
                if (columnId.equals(this.getVisibleColumns()[i])) {
                    columnIdx = i;
                    break;
                }
                ++i;
            }
            if (i == visibleColumns.length) {
                return null;
            }
        } else {
            columnIdx = 0;
        }
        if ((item = this.findItem(path)) != null) {
            ViewerLabel label = new ViewerLabel(this.getText(item, columnIdx), this.getImage(item, columnIdx));
            label.setFont(this.getFont(item, columnIdx));
            label.setBackground(this.getBackground(item, columnIdx));
            label.setForeground(this.getForeground(item, columnIdx));
            return label;
        }
        return null;
    }

    private String getText(VirtualItem item, int columnIdx) {
        String[] texts = (String[])item.getData(VirtualItem.LABEL_KEY);
        if (texts != null && texts.length > columnIdx) {
            return texts[columnIdx];
        }
        return null;
    }

    private Image getImage(VirtualItem item, int columnIdx) {
        ImageDescriptor[] imageDescriptors = (ImageDescriptor[])item.getData(VirtualItem.IMAGE_KEY);
        if (imageDescriptors != null && imageDescriptors.length > columnIdx) {
            return this.getLabelProvider().getImage(imageDescriptors[columnIdx]);
        }
        return null;
    }

    private Font getFont(VirtualItem item, int columnIdx) {
        FontData[] fontDatas = (FontData[])item.getData(VirtualItem.FONT_KEY);
        if (fontDatas != null) {
            return this.getLabelProvider().getFont(fontDatas[columnIdx]);
        }
        return null;
    }

    public Color getForeground(VirtualItem item, int columnIdx) {
        RGB[] rgbs = (RGB[])item.getData(VirtualItem.FOREGROUND_KEY);
        if (rgbs != null) {
            return this.getLabelProvider().getColor(rgbs[columnIdx]);
        }
        return null;
    }

    public Color getBackground(VirtualItem item, int columnIdx) {
        RGB[] rgbs = (RGB[])item.getData(VirtualItem.BACKGROUND_KEY);
        if (rgbs != null) {
            return this.getLabelProvider().getColor(rgbs[columnIdx]);
        }
        return null;
    }
}

