/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.swt.graphics.Image;

public class ContextUiImages {
    private static ImageRegistry imageRegistry;
    private static final String T_ELCL = "elcl16";
    private static final String T_TOOL = "etool16";
    private static final URL baseURL;
    @Deprecated
    public static final ImageDescriptor COLOR_PALETTE;
    @Deprecated
    public static final ImageDescriptor STOP_SEARCH;
    @Deprecated
    public static final ImageDescriptor QUALIFY_NAMES;
    @Deprecated
    public static final ImageDescriptor EDGE_INHERITANCE;
    @Deprecated
    public static final ImageDescriptor EDGE_REFERENCE;
    @Deprecated
    public static final ImageDescriptor EDGE_ACCESS_READ;
    @Deprecated
    public static final ImageDescriptor EDGE_ACCESS_WRITE;
    public static final ImageDescriptor FILE_XML;
    public static final ImageDescriptor FILE_GENERIC;
    public static final ImageDescriptor FOLDER_GENERIC;

    static {
        baseURL = ContextUiPlugin.getDefault().getBundle().getEntry("/icons/");
        COLOR_PALETTE = ContextUiImages.create(T_ELCL, "color-palette.gif");
        STOP_SEARCH = ContextUiImages.create(T_ELCL, "stop_all.gif");
        QUALIFY_NAMES = ContextUiImages.create(T_TOOL, "qualify-names.gif");
        EDGE_INHERITANCE = ContextUiImages.create(T_ELCL, "edge-inheritance.gif");
        EDGE_REFERENCE = ContextUiImages.create(T_ELCL, "edge-reference.gif");
        EDGE_ACCESS_READ = ContextUiImages.create(T_ELCL, "edge-read.gif");
        EDGE_ACCESS_WRITE = ContextUiImages.create(T_ELCL, "edge-write.gif");
        FILE_XML = ContextUiImages.create(T_ELCL, "file-xml.gif");
        FILE_GENERIC = ContextUiImages.create(T_ELCL, "file_obj.gif");
        FOLDER_GENERIC = ContextUiImages.create(T_ELCL, "fldr_obj.gif");
    }

    public static ImageDescriptor create(String prefix, String name) {
        return ContextUiImages.create(prefix, name, baseURL);
    }

    public static ImageDescriptor create(String prefix, String name, URL baseURL) {
        try {
            return ImageDescriptor.createFromURL((URL)ContextUiImages.makeIconFileURL(prefix, name, baseURL));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name, URL baseURL) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        ImageRegistry imageRegistry = ContextUiImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage();
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }
}

