/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.integration;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelperRegistry;

public class ModelModifier {
    private static final String SET_PATTERN = "Set {0}";
    private static final String ADD_PATTERN = "Add {0}";
    private static final String REMOVE_PATTERN = "Remove {0}";
    private static final String DEFAULT_COMMAND_LABEL = "Command";
    private EditingDomain editingDomain;
    private List helpers;
    private List extendedHelpers;
    protected List additionalCommands;
    protected int status;
    public static final int NO_VALUE_CHANGE = 0;
    public static final int VALUE_CHANGE = 1;
    public static final int ERROR = 2;

    public ModelModifier() {
    }

    public ModelModifier(EditingDomain aDomain) {
        this.setEditingDomain(aDomain);
    }

    public void addHelper(ModifierHelper aHelper) {
        if (aHelper != null && !this.getHelpers().contains(aHelper)) {
            this.getHelpers().add(aHelper);
        }
    }

    public void addAdditionalCommand(Command aCommand) {
        if (aCommand != null && !this.getAdditionalCommands().contains(aCommand)) {
            this.additionalCommands.add(aCommand);
        }
    }

    public boolean canExecuteCommand() {
        return this.getEditingDomain() != null;
    }

    public int executeWithStatus() {
        try {
            this.execute();
            int n = this.status;
            Object var1_2 = null;
            this.status = -1;
            return n;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.status = -1;
            throw throwable;
        }
    }

    public boolean execute(ModifierHelper aHelper) {
        this.addHelper(aHelper);
        return this.execute();
    }

    public boolean execute(List someHelpers) {
        this.setHelpers(someHelpers);
        return this.execute();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() {
        boolean result = false;
        if (!this.canExecuteCommand()) {
            this.setStatus(2);
            return result;
        }
        try {
            Command command = this.createCommand();
            boolean bl = result = command != null;
            if (result) {
                this.getCommandStack().execute(command);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.release();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.release();
            return result;
        }
    }

    protected CommandStack getCommandStack() {
        if (this.getEditingDomain() != null) {
            return this.getEditingDomain().getCommandStack();
        }
        return null;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public ModifierHelper getFirstHelper() {
        if (this.helpers != null && this.getHelpers().size() > 0) {
            return (ModifierHelper)this.getHelpers().get(0);
        }
        return null;
    }

    public List getHelpers() {
        if (this.helpers == null) {
            this.helpers = new ArrayList();
        }
        return this.helpers;
    }

    public List getAdditionalCommands() {
        if (this.additionalCommands == null) {
            this.additionalCommands = new ArrayList();
        }
        return this.additionalCommands;
    }

    protected void release() {
        this.setEditingDomain(null);
        this.setHelpers(null);
    }

    public void setEditingDomain(EditingDomain newEditingDomain) {
        this.editingDomain = newEditingDomain;
    }

    public void setHelpers(List newHelpers) {
        this.helpers = newHelpers;
    }

    protected void setStatus(int statusCode) {
        if (statusCode > this.status) {
            this.status = statusCode;
        }
    }

    protected Command createAddCommand(ModifierHelper aHelper) {
        Object value = this.getValue(aHelper);
        Command command = null;
        if (this.valueChanged(aHelper.getOwner(), aHelper.getFeature(), value, false)) {
            command = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)aHelper.getOwner(), (Object)aHelper.getFeature(), (Object)value);
            ((AbstractCommand)command).setLabel(this.createCommandLabel(ADD_PATTERN, aHelper.getFeature()));
            this.setStatus(1);
        } else {
            this.setStatus(0);
        }
        return command;
    }

    public Command createCommand() {
        Command chainedCommand = this.createCommand(null, this.getHelpers());
        if (chainedCommand == null && this.additionalCommands != null && this.additionalCommands.isEmpty()) {
            this.setStatus(2);
            return null;
        }
        chainedCommand = this.appendAdditionalCommands(chainedCommand);
        return chainedCommand;
    }

    protected Command createCommand(Command chainedCommand, List helpersArg) {
        if (this.extendedHelpers == null) {
            this.extendedHelpers = new ArrayList();
        }
        if (!helpersArg.isEmpty()) {
            Iterator it = helpersArg.iterator();
            Command nextCommand = null;
            while (it.hasNext()) {
                nextCommand = this.createCommand((ModifierHelper)it.next());
                if (chainedCommand == null) {
                    chainedCommand = nextCommand;
                    continue;
                }
                if (nextCommand == null) continue;
                chainedCommand = chainedCommand.chain(nextCommand);
            }
        }
        if (!this.extendedHelpers.isEmpty()) {
            ArrayList copy = new ArrayList();
            copy.addAll(this.extendedHelpers);
            this.extendedHelpers.clear();
            chainedCommand = this.createCommand(chainedCommand, copy);
        }
        return chainedCommand;
    }

    protected Command appendAdditionalCommands(Command chainedCommand) {
        if (this.additionalCommands != null && !this.additionalCommands.isEmpty()) {
            int i = 0;
            while (i < this.additionalCommands.size()) {
                Command command = (Command)this.additionalCommands.get(i);
                chainedCommand = chainedCommand == null ? command : chainedCommand.chain(command);
                ++i;
            }
        }
        return chainedCommand;
    }

    protected Command createCommand(ModifierHelper aHelper) {
        if (aHelper == null) {
            return null;
        }
        ModifierHelper ownerHelper = aHelper.getOwnerHelper();
        if (aHelper.shouldUnsetValue() && ownerHelper != null) {
            return null;
        }
        Command command1 = this.createCommand(ownerHelper);
        Command command2 = this.primCreateCommand(aHelper);
        if (command1 != null) {
            command2 = command2 == null ? command1 : command2.chain(command1);
        }
        return command2;
    }

    protected String createCommandLabel(String aPattern, EStructuralFeature feature) {
        String replacement = feature == null ? DEFAULT_COMMAND_LABEL : feature.getName();
        return MessageFormat.format(aPattern, replacement);
    }

    protected Command createManyCommand(ModifierHelper aHelper) {
        if (aHelper.shouldUnsetValue()) {
            return this.createRemoveCommand(aHelper);
        }
        return this.createAddCommand(aHelper);
    }

    protected EObject createObjectFromHelper(ModifierHelper aHelper) {
        return aHelper.createNewObjectFromFeature();
    }

    protected Command createRemoveCommand(ModifierHelper aHelper) {
        Object value = this.getValue(aHelper);
        Command command = null;
        EStructuralFeature feature = aHelper.getFeature();
        if (this.valueChanged(aHelper.getOwner(), feature, value, true)) {
            command = this.isValueEqual(aHelper, value) ? RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)aHelper.getOwner(), (Object)feature, (Collection)((Collection)value)) : RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)aHelper.getOwner(), (Object)feature, (Object)value);
            ((AbstractCommand)command).setLabel(this.createCommandLabel(REMOVE_PATTERN, feature));
            this.setStatus(1);
        } else {
            this.setStatus(0);
        }
        return command;
    }

    private boolean isValueEqual(ModifierHelper aHelper, Object value) {
        return aHelper.getOwner().eGet(aHelper.getFeature()) == value;
    }

    protected Command createSingleCommand(ModifierHelper aHelper) {
        Object value = this.getValue(aHelper);
        Command command = null;
        if (this.valueChanged(aHelper.getOwner(), aHelper.getFeature(), value, aHelper.shouldUnsetValue())) {
            command = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)aHelper.getOwner(), (Object)aHelper.getFeature(), (Object)value);
            ((AbstractCommand)command).setLabel(this.createCommandLabel(SET_PATTERN, aHelper.getFeature()));
            this.setStatus(1);
        } else {
            this.setStatus(0);
        }
        return command;
    }

    protected Object createValueFromHelper(ModifierHelper aHelper) {
        EObject newObject = this.createObjectFromHelper(aHelper);
        this.setNewObjectAttributes(newObject, aHelper);
        return newObject;
    }

    protected boolean enumValueChanged(EObject anObject, EStructuralFeature aFeature, Object aValue) {
        Enumerator newEnumerator;
        if (!anObject.eIsSet(aFeature)) {
            return true;
        }
        Enumerator existingEnumerator = (Enumerator)anObject.eGet(aFeature);
        return existingEnumerator != (newEnumerator = this.getEnumerator(aFeature, aValue));
    }

    private Enumerator getEnumerator(EStructuralFeature aFeature, Object aValue) {
        if (aValue instanceof Enumerator) {
            return (Enumerator)aValue;
        }
        EEnum anEnum = (EEnum)aFeature.getEType();
        EEnumLiteral literal = null;
        if (aValue instanceof String) {
            literal = anEnum.getEEnumLiteral((String)aValue);
        } else if (aValue instanceof Integer) {
            literal = anEnum.getEEnumLiteral(((Integer)aValue).intValue());
        }
        if (literal != null) {
            return literal.getInstance();
        }
        return null;
    }

    protected Object getValue(ModifierHelper aHelper) {
        if (aHelper.mustCreateValue()) {
            Object value = this.createValueFromHelper(aHelper);
            aHelper.setValue(value);
        }
        return aHelper.getValue();
    }

    protected boolean manyValueChanged(EObject anObject, EStructuralFeature aFeature, Object aValue, boolean isUnset) {
        List list = (List)anObject.eGet(aFeature);
        if (isUnset) {
            return list.contains(aValue) || list == aValue && !list.isEmpty();
        }
        return !list.contains(aValue);
    }

    protected Command primCreateCommand(ModifierHelper aHelper) {
        Object value;
        Object command = this.doCreateCommand(aHelper);
        if (aHelper.shouldUnsetValue() && (value = aHelper.getValue()) instanceof EObject && !((EObject)value).eIsProxy()) {
            command = new ProxyWrappingCommand((Command)command, (EObject)value);
        }
        return command;
    }

    protected Command doCreateCommand(ModifierHelper aHelper) {
        List localHelpers;
        if (!aHelper.isComplete()) {
            this.setStatus(2);
            return null;
        }
        Command command = null;
        command = aHelper.getFeature().isMany() ? this.createManyCommand(aHelper) : this.createSingleCommand(aHelper);
        if (command != null && (localHelpers = ModifierHelperRegistry.getInstance().getHelpers(aHelper)) != null) {
            this.extendedHelpers.addAll(localHelpers);
        }
        return command;
    }

    protected void primRun(ModifierHelper aHelper) {
        if (aHelper.isComplete()) {
            Object value = this.getValue(aHelper);
            if (this.valueChanged(aHelper.getOwner(), aHelper.getFeature(), value, aHelper.shouldUnsetValue())) {
                this.setObjectAttribute(aHelper.getOwner(), aHelper.getFeature(), value, aHelper.shouldUnsetValue());
            }
        }
    }

    public void run() {
        if (!this.getHelpers().isEmpty()) {
            Iterator it = this.getHelpers().iterator();
            while (it.hasNext()) {
                this.run((ModifierHelper)it.next());
            }
        }
    }

    protected void run(ModifierHelper aHelper) {
        if (aHelper != null) {
            this.run(aHelper.getOwnerHelper());
            this.primRun(aHelper);
        }
    }

    protected void setNewObjectAttributes(EObject anObject, ModifierHelper aHelper) {
        HashMap attributes = aHelper.getAttributes();
        Iterator it = attributes.keySet().iterator();
        Object value = null;
        while (it.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)it.next();
            value = attributes.get(feature);
            this.setObjectAttribute(anObject, feature, value, false);
        }
    }

    protected void setObjectAttribute(EObject anObject, EStructuralFeature aFeature, Object aValue, boolean shouldUnsetValue) {
        if (aFeature.isMany()) {
            this.setObjectManyAttribute(anObject, aFeature, aValue, shouldUnsetValue);
        } else {
            this.setObjectSingleAttribute(anObject, aFeature, aValue, shouldUnsetValue);
        }
    }

    protected void setObjectEnumAttribute(EObject anObject, EStructuralFeature aFeature, Object aValue) {
        Enumerator enumerator = this.getEnumerator(aFeature, aValue);
        anObject.eSet(aFeature, (Object)enumerator);
    }

    protected void setObjectManyAttribute(EObject anObject, EStructuralFeature aFeature, Object aValue, boolean shouldUnsetValue) {
        List list = (List)anObject.eGet(aFeature);
        if (shouldUnsetValue) {
            list.remove(aValue);
        } else {
            list.add(aValue);
        }
    }

    protected void setObjectSingleAttribute(EObject anObject, EStructuralFeature aFeature, Object aValue, boolean shouldUnsetValue) {
        if (shouldUnsetValue) {
            anObject.eUnset(aFeature);
        } else if (aFeature.getEType() instanceof EEnum) {
            this.setObjectEnumAttribute(anObject, aFeature, aValue);
        } else {
            anObject.eSet(aFeature, aValue);
        }
    }

    protected boolean singleValueChanged(EObject anObject, EStructuralFeature aFeature, Object aValue, boolean isUnset) {
        if (aFeature.getEType() instanceof EEnum) {
            return this.enumValueChanged(anObject, aFeature, aValue);
        }
        Object existingValue = anObject.eGet(aFeature);
        if (existingValue == null && aValue == null) {
            return false;
        }
        if (existingValue != null && !existingValue.equals(aValue)) {
            return true;
        }
        return aValue != null && !aValue.equals(existingValue);
    }

    protected boolean valueChanged(EObject anObject, EStructuralFeature aFeature, Object aValue, boolean isUnset) {
        if (aFeature.isMany()) {
            return this.manyValueChanged(anObject, aFeature, aValue, isUnset);
        }
        return this.singleValueChanged(anObject, aFeature, aValue, isUnset);
    }

    public class ProxyWrappingCommand
    extends AbstractCommand {
        protected Command baseCommand = null;
        protected EObject eObject = null;
        protected Resource resource = null;

        public ProxyWrappingCommand(Command baseCommand, EObject eObject) {
            this.baseCommand = baseCommand;
            this.eObject = eObject;
            this.resource = eObject.eResource();
        }

        public boolean canExecute() {
            return this.baseCommand.canExecute();
        }

        public void execute() {
            ExtendedEcoreUtil.becomeProxy((EObject)this.eObject, (Resource)this.resource);
            this.baseCommand.execute();
        }

        public boolean canUndo() {
            return this.baseCommand.canUndo();
        }

        public void undo() {
            this.baseCommand.undo();
            ExtendedEcoreUtil.removeProxy((EObject)this.eObject, (Resource)this.resource);
        }

        public void redo() {
            ExtendedEcoreUtil.becomeProxy((EObject)this.eObject, (Resource)this.resource);
            this.baseCommand.redo();
        }

        public Collection getResult() {
            return this.baseCommand.getResult();
        }

        public Collection getAffectedObjects() {
            return this.baseCommand.getAffectedObjects();
        }

        public String getLabel() {
            return this.baseCommand.getLabel();
        }

        public String getDescription() {
            return this.baseCommand.getDescription();
        }

        public void dispose() {
            super.dispose();
            this.baseCommand.dispose();
        }
    }
}

